/*
 * Decompiled with CFR 0.152.
 */
package b3.entrypoint.fixp.sbe;

public enum OrdType {
    MARKET(49),
    LIMIT(50),
    STOP_LOSS(51),
    STOP_LIMIT(52),
    MARKET_WITH_LEFTOVER_AS_LIMIT(75),
    RLP(87),
    PEGGED_MIDPOINT(80),
    NULL_VAL(0);

    private final byte value;

    private OrdType(byte value) {
        this.value = value;
    }

    public byte value() {
        return this.value;
    }

    public static OrdType get(byte value) {
        switch (value) {
            case 49: {
                return MARKET;
            }
            case 50: {
                return LIMIT;
            }
            case 51: {
                return STOP_LOSS;
            }
            case 52: {
                return STOP_LIMIT;
            }
            case 75: {
                return MARKET_WITH_LEFTOVER_AS_LIMIT;
            }
            case 87: {
                return RLP;
            }
            case 80: {
                return PEGGED_MIDPOINT;
            }
            case 0: {
                return NULL_VAL;
            }
        }
        throw new IllegalArgumentException("Unknown value: " + value);
    }
}

