/*
 * Decompiled with CFR 0.152.
 */
package b3.entrypoint.fixp.sbe;

import b3.entrypoint.fixp.sbe.MessageHeaderEncoder;
import b3.entrypoint.fixp.sbe.MetaAttribute;
import b3.entrypoint.fixp.sbe.NegotiateDecoder;
import b3.entrypoint.fixp.sbe.UTCTimestampNanosEncoder;
import java.nio.ByteOrder;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.MessageEncoderFlyweight;

public final class NegotiateEncoder
implements MessageEncoderFlyweight {
    public static final int BLOCK_LENGTH = 38;
    public static final int TEMPLATE_ID = 1;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 0;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final NegotiateEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;
    private final UTCTimestampNanosEncoder timestamp = new UTCTimestampNanosEncoder();

    @Override
    public int sbeBlockLength() {
        return 38;
    }

    @Override
    public int sbeTemplateId() {
        return 1;
    }

    @Override
    public int sbeSchemaId() {
        return 1;
    }

    @Override
    public int sbeSchemaVersion() {
        return 0;
    }

    @Override
    public String sbeSemanticType() {
        return "";
    }

    @Override
    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int initialOffset() {
        return this.initialOffset;
    }

    @Override
    public int offset() {
        return this.offset;
    }

    @Override
    public NegotiateEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        this.limit(offset + 38);
        return this;
    }

    public NegotiateEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(38).templateId(1).schemaId(1).version(0);
        return this.wrap(buffer, offset + 8);
    }

    @Override
    public int encodedLength() {
        return this.limit - this.offset;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    @Override
    public void limit(int limit) {
        this.limit = limit;
    }

    public static int messageTypeId() {
        return 35;
    }

    public static int messageTypeSinceVersion() {
        return 0;
    }

    public static int messageTypeEncodingOffset() {
        return 0;
    }

    public static int messageTypeEncodingLength() {
        return 1;
    }

    public static String messageTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public static int sessionIDId() {
        return 35518;
    }

    public static int sessionIDSinceVersion() {
        return 0;
    }

    public static int sessionIDEncodingOffset() {
        return 0;
    }

    public static int sessionIDEncodingLength() {
        return 4;
    }

    public static String sessionIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long sessionIDNullValue() {
        return 0xFFFFFFFFL;
    }

    public static long sessionIDMinValue() {
        return 0L;
    }

    public static long sessionIDMaxValue() {
        return 0xFFFFFFFEL;
    }

    public NegotiateEncoder sessionID(long value) {
        this.buffer.putInt(this.offset + 0, (int)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int sessionVerIDId() {
        return 35519;
    }

    public static int sessionVerIDSinceVersion() {
        return 0;
    }

    public static int sessionVerIDEncodingOffset() {
        return 4;
    }

    public static int sessionVerIDEncodingLength() {
        return 8;
    }

    public static String sessionVerIDMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long sessionVerIDNullValue() {
        return -1L;
    }

    public static long sessionVerIDMinValue() {
        return 0L;
    }

    public static long sessionVerIDMaxValue() {
        return -2L;
    }

    public NegotiateEncoder sessionVerID(long value) {
        this.buffer.putLong(this.offset + 4, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int timestampId() {
        return 35520;
    }

    public static int timestampSinceVersion() {
        return 0;
    }

    public static int timestampEncodingOffset() {
        return 12;
    }

    public static int timestampEncodingLength() {
        return 8;
    }

    public static String timestampMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public UTCTimestampNanosEncoder timestamp() {
        this.timestamp.wrap(this.buffer, this.offset + 12);
        return this.timestamp;
    }

    public static int clientFlowId() {
        return 35516;
    }

    public static int clientFlowSinceVersion() {
        return 0;
    }

    public static int clientFlowEncodingOffset() {
        return 20;
    }

    public static int clientFlowEncodingLength() {
        return 1;
    }

    public static String clientFlowMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "constant";
        }
        return "";
    }

    public static int enteringFirmId() {
        return 35501;
    }

    public static int enteringFirmSinceVersion() {
        return 0;
    }

    public static int enteringFirmEncodingOffset() {
        return 20;
    }

    public static int enteringFirmEncodingLength() {
        return 4;
    }

    public static String enteringFirmMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long enteringFirmNullValue() {
        return 0xFFFFFFFFL;
    }

    public static long enteringFirmMinValue() {
        return 0L;
    }

    public static long enteringFirmMaxValue() {
        return 0xFFFFFFFEL;
    }

    public NegotiateEncoder enteringFirm(long value) {
        this.buffer.putInt(this.offset + 20, (int)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int onbehalfFirmId() {
        return 35517;
    }

    public static int onbehalfFirmSinceVersion() {
        return 0;
    }

    public static int onbehalfFirmEncodingOffset() {
        return 24;
    }

    public static int onbehalfFirmEncodingLength() {
        return 4;
    }

    public static String onbehalfFirmMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static long onbehalfFirmNullValue() {
        return 0L;
    }

    public static long onbehalfFirmMinValue() {
        return 0L;
    }

    public static long onbehalfFirmMaxValue() {
        return 0xFFFFFFFEL;
    }

    public NegotiateEncoder onbehalfFirm(long value) {
        this.buffer.putInt(this.offset + 24, (int)value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int senderLocationId() {
        return 35503;
    }

    public static int senderLocationSinceVersion() {
        return 0;
    }

    public static int senderLocationEncodingOffset() {
        return 28;
    }

    public static int senderLocationEncodingLength() {
        return 10;
    }

    public static String senderLocationMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static byte senderLocationNullValue() {
        return 0;
    }

    public static byte senderLocationMinValue() {
        return 32;
    }

    public static byte senderLocationMaxValue() {
        return 126;
    }

    public static int senderLocationLength() {
        return 10;
    }

    public NegotiateEncoder senderLocation(int index, byte value) {
        if (index < 0 || index >= 10) {
            throw new IndexOutOfBoundsException("index out of range: index=" + index);
        }
        int pos = this.offset + 28 + index * 1;
        this.buffer.putByte(pos, value);
        return this;
    }

    public static String senderLocationCharacterEncoding() {
        return "ASCII";
    }

    public NegotiateEncoder putSenderLocation(byte[] src, int srcOffset) {
        int length = 10;
        if (srcOffset < 0 || srcOffset > src.length - 10) {
            throw new IndexOutOfBoundsException("Copy will go out of range: offset=" + srcOffset);
        }
        this.buffer.putBytes(this.offset + 28, src, srcOffset, 10);
        return this;
    }

    public NegotiateEncoder senderLocation(String src) {
        int srcLength;
        int length = 10;
        int n = srcLength = null == src ? 0 : src.length();
        if (srcLength > 10) {
            throw new IndexOutOfBoundsException("String too large for copy: byte length=" + srcLength);
        }
        this.buffer.putStringWithoutLengthAscii(this.offset + 28, src);
        for (int start = srcLength; start < 10; ++start) {
            this.buffer.putByte(this.offset + 28 + start, (byte)0);
        }
        return this;
    }

    public NegotiateEncoder senderLocation(CharSequence src) {
        int i;
        int srcLength;
        int length = 10;
        int n = srcLength = null == src ? 0 : src.length();
        if (srcLength > 10) {
            throw new IndexOutOfBoundsException("CharSequence too large for copy: byte length=" + srcLength);
        }
        for (i = 0; i < srcLength; ++i) {
            char charValue = src.charAt(i);
            byte byteValue = (byte)(charValue > '\u007f' ? 63 : (byte)charValue);
            this.buffer.putByte(this.offset + 28 + i, byteValue);
        }
        for (i = srcLength; i < 10; ++i) {
            this.buffer.putByte(this.offset + 28 + i, (byte)0);
        }
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        NegotiateDecoder decoder = new NegotiateDecoder();
        decoder.wrap(this.buffer, this.initialOffset, 38, 0);
        return decoder.appendTo(builder);
    }
}

