/*
 * Decompiled with CFR 0.152.
 */
package b3.entrypoint.fixp.sbe;

import b3.entrypoint.fixp.sbe.MemoEncodingDecoder;
import java.nio.ByteOrder;
import org.agrona.MutableDirectBuffer;
import org.agrona.sbe.CompositeEncoderFlyweight;

public final class MemoEncodingEncoder
implements CompositeEncoderFlyweight {
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 0;
    public static final int ENCODED_LENGTH = -1;
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private int offset;
    private MutableDirectBuffer buffer;

    @Override
    public MemoEncodingEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        return this;
    }

    @Override
    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    @Override
    public int offset() {
        return this.offset;
    }

    @Override
    public int encodedLength() {
        return -1;
    }

    @Override
    public int sbeSchemaId() {
        return 1;
    }

    @Override
    public int sbeSchemaVersion() {
        return 0;
    }

    public static int lengthEncodingOffset() {
        return 0;
    }

    public static int lengthEncodingLength() {
        return 1;
    }

    public static short lengthNullValue() {
        return 255;
    }

    public static short lengthMinValue() {
        return 0;
    }

    public static short lengthMaxValue() {
        return 40;
    }

    public MemoEncodingEncoder length(short value) {
        this.buffer.putByte(this.offset + 0, (byte)value);
        return this;
    }

    public static int varDataEncodingOffset() {
        return 1;
    }

    public static int varDataEncodingLength() {
        return -1;
    }

    public static byte varDataNullValue() {
        return 0;
    }

    public static byte varDataMinValue() {
        return 32;
    }

    public static byte varDataMaxValue() {
        return 126;
    }

    public static int numInGroupEncodingOffset() {
        return 0;
    }

    public static int numInGroupEncodingLength() {
        return 1;
    }

    public static short numInGroupNullValue() {
        return 255;
    }

    public static short numInGroupMinValue() {
        return 0;
    }

    public static short numInGroupMaxValue() {
        return 254;
    }

    public MemoEncodingEncoder numInGroup(short value) {
        this.buffer.putByte(this.offset + 0, (byte)value);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        MemoEncodingDecoder decoder = new MemoEncodingDecoder();
        decoder.wrap(this.buffer, this.offset);
        return decoder.appendTo(builder);
    }
}

