/*
 * Decompiled with CFR 0.152.
 */
package uk.co.firstzero.csv;

import java.io.File;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import uk.co.firstzero.csv.CsvDiff;
import uk.co.firstzero.diff.CsvReport;

public class AntCsvDiff
extends Task {
    private Vector<FileSet> fileSets = new Vector();
    private String keyColumns;
    private String testDirectory;
    private String resultDirectory;
    private char separator = (char)44;
    private static Logger logger = Logger.getLogger(AntCsvDiff.class);

    public Vector<FileSet> getFileSets() {
        return this.fileSets;
    }

    public void setFileSets(Vector<FileSet> fileSets) {
        this.fileSets = fileSets;
    }

    public String getTestDirectory() {
        return this.testDirectory;
    }

    public void setTestDirectory(String testDirectory) {
        this.testDirectory = testDirectory;
    }

    public void addFileSet(FileSet fileset) {
        if (!this.fileSets.contains(fileset)) {
            this.fileSets.add(fileset);
        }
    }

    public void setSeparator(char separator) {
        this.separator = separator;
    }

    public char getSeparator() {
        return this.separator;
    }

    public void setResultDirectory(String resultDirectory) {
        this.resultDirectory = resultDirectory;
    }

    public String getResultDirectory() {
        return this.resultDirectory;
    }

    public void execute() {
        File testDir = new File(this.testDirectory);
        if (!testDir.exists()) {
            System.err.println(this.testDirectory + " does not exist");
            System.exit(1);
        }
        for (FileSet fileset : this.fileSets) {
            String[] filesInSet;
            DirectoryScanner ds = fileset.getDirectoryScanner(this.getProject());
            File controlDir = ds.getBasedir();
            for (String filename : filesInSet = ds.getIncludedFiles()) {
                logger.debug((Object)("Processing " + filename));
                try {
                    logger.trace((Object)("Initialising controlFile - " + controlDir + "/" + filename));
                    File controlFile = new File(controlDir, filename);
                    logger.trace((Object)("Initialising testFile - " + testDir + "/" + filename));
                    File testFile = new File(testDir, filename);
                    logger.trace((Object)"Initialising report");
                    String name = controlFile.getName();
                    CsvReport report = new CsvReport(this.resultDirectory + "/report_" + name + ".csv");
                    CsvDiff csv = new CsvDiff(controlFile.getCanonicalPath(), testFile.getCanonicalPath(), this.separator);
                    csv.setReport(report);
                    csv.setKeyColumns(this.keyColumns);
                    csv.diff();
                }
                catch (Exception e) {
                    System.out.println("Unable to process " + filename);
                }
            }
        }
    }
}

