/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.support;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.SimpleAssociationHandler;
import org.springframework.data.mapping.SimplePropertyHandler;
import org.springframework.data.mapping.model.BeanWrapper;
import org.springframework.data.repository.support.Repositories;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class DomainObjectMerger {
    private final Repositories repositories;
    private final ConversionService conversionService;

    @Autowired
    public DomainObjectMerger(Repositories repositories, ConversionService conversionService) {
        Assert.notNull((Object)repositories, (String)"Repositories must not be null!");
        Assert.notNull((Object)conversionService, (String)"ConversionService must not be null!");
        this.repositories = repositories;
        this.conversionService = conversionService;
    }

    public void merge(Object from, Object target, final NullHandlingPolicy nullPolicy) {
        if (from == null || target == null) {
            return;
        }
        final BeanWrapper fromWrapper = BeanWrapper.create((Object)from, (ConversionService)this.conversionService);
        final BeanWrapper targetWrapper = BeanWrapper.create((Object)target, (ConversionService)this.conversionService);
        final PersistentEntity entity = this.repositories.getPersistentEntity(target.getClass());
        entity.doWithProperties(new SimplePropertyHandler(){

            public void doWithPersistentProperty(PersistentProperty<?> persistentProperty) {
                Object sourceValue = fromWrapper.getProperty(persistentProperty);
                Object targetValue = targetWrapper.getProperty(persistentProperty);
                if (entity.isIdProperty(persistentProperty)) {
                    return;
                }
                if (ObjectUtils.nullSafeEquals((Object)sourceValue, (Object)targetValue)) {
                    return;
                }
                if (nullPolicy == NullHandlingPolicy.APPLY_NULLS || sourceValue != null) {
                    targetWrapper.setProperty(persistentProperty, sourceValue);
                }
            }
        });
        entity.doWithAssociations(new SimpleAssociationHandler(){

            public void doWithAssociation(Association<? extends PersistentProperty<?>> association) {
                PersistentProperty persistentProperty = association.getInverse();
                Object fromVal = fromWrapper.getProperty(persistentProperty);
                if (!DomainObjectMerger.isNullOrEmpty(fromVal) && !fromVal.equals(targetWrapper.getProperty(persistentProperty))) {
                    targetWrapper.setProperty(persistentProperty, fromVal);
                }
            }
        });
    }

    static boolean isNullOrEmpty(Object source) {
        if (source == null) {
            return true;
        }
        if (source instanceof Iterable) {
            return !((Iterable)source).iterator().hasNext();
        }
        if (ObjectUtils.isArray((Object)source)) {
            return ObjectUtils.isEmpty((Object[])((Object[])source));
        }
        return false;
    }

    public static enum NullHandlingPolicy {
        APPLY_NULLS,
        IGNORE_NULLS;

    }
}

