/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.projection;

import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class SpelEvaluatingMethodInterceptor
implements MethodInterceptor {
    private final SpelExpressionParser parser;
    private final ParserContext parserContext;
    private final EvaluationContext evaluationContext;
    private final MethodInterceptor delegate;

    public SpelEvaluatingMethodInterceptor(MethodInterceptor delegate, Object target, BeanFactory beanFactory) {
        Assert.notNull((Object)delegate, (String)"Delegate MethodInterceptor must not be null!");
        Assert.notNull((Object)target, (String)"TargetObject must not be null!");
        StandardEvaluationContext evaluationContext = new StandardEvaluationContext((Object)new TargetWrapper(target));
        if (beanFactory != null) {
            evaluationContext.setBeanResolver((BeanResolver)new BeanFactoryResolver(beanFactory));
        }
        this.evaluationContext = evaluationContext;
        this.parser = new SpelExpressionParser();
        this.parserContext = new TemplateParserContext();
        this.delegate = delegate;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        Value annotation = method.getAnnotation(Value.class);
        if (annotation == null || !StringUtils.hasText((String)annotation.value())) {
            return this.delegate.invoke(invocation);
        }
        Expression expression = this.parser.parseExpression(annotation.value(), this.parserContext);
        return expression.getValue(this.evaluationContext);
    }

    static class TargetWrapper {
        private final Object target;

        public TargetWrapper(Object target) {
            this.target = target;
        }

        public Object getTarget() {
            return this.target;
        }
    }
}

