/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.projection;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.rest.core.projection.ProjectingMethodInterceptor;
import org.springframework.data.rest.core.projection.ProjectionFactory;
import org.springframework.data.rest.core.projection.PropertyAccessingMethodInterceptor;
import org.springframework.data.rest.core.projection.SpelEvaluatingMethodInterceptor;
import org.springframework.data.util.AnnotationDetectionMethodCallback;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class ProxyProjectionFactory
implements ProjectionFactory {
    private final Map<Class<?>, Boolean> typeCache = new HashMap();
    private BeanFactory beanFactory;

    public ProxyProjectionFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Override
    public <T> T createProjection(Object source, Class<T> projectionType) {
        Assert.isTrue((boolean)projectionType.isInterface(), (String)"Projection type must be an interface!");
        if (source == null) {
            return null;
        }
        ProxyFactory factory = new ProxyFactory();
        factory.setTarget(source);
        factory.setOpaque(true);
        factory.setInterfaces(new Class[]{projectionType, TargetClassAware.class});
        factory.addAdvice((Advice)new TargetClassAwareMethodInterceptor(source.getClass()));
        factory.addAdvice((Advice)this.getMethodInterceptor(source, projectionType));
        return (T)factory.getProxy();
    }

    private MethodInterceptor getMethodInterceptor(Object source, Class<?> projectionType) {
        PropertyAccessingMethodInterceptor propertyInvocationInterceptor = new PropertyAccessingMethodInterceptor(source);
        return new ProjectingMethodInterceptor(this, this.getSpelMethodInterceptorIfNecessary(source, projectionType, propertyInvocationInterceptor));
    }

    private MethodInterceptor getSpelMethodInterceptorIfNecessary(Object source, Class<?> projectionType, MethodInterceptor delegate) {
        if (!this.typeCache.containsKey(projectionType)) {
            AnnotationDetectionMethodCallback callback = new AnnotationDetectionMethodCallback(Value.class);
            ReflectionUtils.doWithMethods(projectionType, (ReflectionUtils.MethodCallback)callback);
            this.typeCache.put(projectionType, callback.hasFoundAnnotation());
        }
        return this.typeCache.get(projectionType) != false ? new SpelEvaluatingMethodInterceptor(delegate, source, this.beanFactory) : delegate;
    }

    private static class TargetClassAwareMethodInterceptor
    implements MethodInterceptor {
        private static final Method GET_TARGET_CLASS_METHOD;
        private final Class<?> targetClass;

        public TargetClassAwareMethodInterceptor(Class<?> targetClass) {
            Assert.notNull(targetClass, (String)"Target class must not be null!");
            this.targetClass = targetClass;
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            if (invocation.getMethod().equals(GET_TARGET_CLASS_METHOD)) {
                return this.targetClass;
            }
            return invocation.proceed();
        }

        static {
            try {
                GET_TARGET_CLASS_METHOD = TargetClassAware.class.getMethod("getTargetClass", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public static interface TargetClassAware
    extends org.springframework.aop.TargetClassAware {
        @JsonIgnore
        public Class<?> getTargetClass();
    }
}

