/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.projection;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapper;
import org.springframework.data.util.DirectFieldAccessFallbackBeanWrapper;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

class PropertyAccessingMethodInterceptor
implements MethodInterceptor {
    private final BeanWrapper target;

    public PropertyAccessingMethodInterceptor(Object target) {
        Assert.notNull((Object)target, (String)"Proxy target must not be null!");
        this.target = new DirectFieldAccessFallbackBeanWrapper(target);
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        if (ReflectionUtils.isObjectMethod((Method)method)) {
            return invocation.proceed();
        }
        PropertyDescriptor descriptor = BeanUtils.findPropertyForMethod((Method)method);
        if (descriptor == null) {
            throw new IllegalStateException("Invoked method is not a property accessor!");
        }
        return this.target.getPropertyValue(descriptor.getName());
    }
}

