/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.mapping;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.Param;
import org.springframework.data.rest.core.Path;
import org.springframework.data.rest.core.annotation.RestResource;
import org.springframework.data.rest.core.mapping.MethodResourceMapping;
import org.springframework.data.rest.core.mapping.ParameterMetadata;
import org.springframework.data.rest.core.mapping.ParametersMetadata;
import org.springframework.data.rest.core.mapping.ResourceDescription;
import org.springframework.data.rest.core.mapping.ResourceMapping;
import org.springframework.hateoas.core.AnnotationAttribute;
import org.springframework.hateoas.core.MethodParameters;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class RepositoryMethodResourceMapping
implements MethodResourceMapping {
    private static final AnnotationAttribute PARAM_VALUE = new AnnotationAttribute(Param.class);
    private final boolean isExported;
    private final String rel;
    private final Path path;
    private final Method method;
    private final boolean paging;
    private final boolean sorting;
    private final List<ParameterMetadata> parameterMetadata;

    public RepositoryMethodResourceMapping(Method method, ResourceMapping resourceMapping) {
        Assert.notNull((Object)method, (String)"Method must not be null!");
        Assert.notNull((Object)resourceMapping, (String)"ResourceMapping must not be null!");
        RestResource annotation = (RestResource)AnnotationUtils.findAnnotation((Method)method, RestResource.class);
        String resourceRel = resourceMapping.getRel();
        this.isExported = annotation != null ? annotation.exported() : true;
        this.rel = annotation == null || !StringUtils.hasText((String)annotation.rel()) ? method.getName() : annotation.rel();
        this.path = annotation == null || !StringUtils.hasText((String)annotation.path()) ? new Path(method.getName()) : new Path(annotation.path());
        this.method = method;
        this.parameterMetadata = RepositoryMethodResourceMapping.discoverParameterMetadata(method, resourceRel.concat(".").concat(this.rel));
        List<Class<?>> parameterTypes = Arrays.asList(method.getParameterTypes());
        this.paging = parameterTypes.contains(Pageable.class);
        this.sorting = parameterTypes.contains(Sort.class);
    }

    private static final List<ParameterMetadata> discoverParameterMetadata(Method method, String baseRel) {
        ArrayList<ParameterMetadata> result = new ArrayList<ParameterMetadata>();
        for (MethodParameter parameter : new MethodParameters(method, PARAM_VALUE).getParameters()) {
            if (!StringUtils.hasText((String)parameter.getParameterName())) continue;
            result.add(new ParameterMetadata(parameter, baseRel));
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public boolean isExported() {
        return this.isExported;
    }

    @Override
    public String getRel() {
        return this.rel;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public ParametersMetadata getParametersMetadata() {
        return new ParametersMetadata(this.parameterMetadata);
    }

    @Override
    public boolean isPagingResource() {
        return this.paging;
    }

    @Override
    public boolean isSortableResource() {
        return this.sorting;
    }

    @Override
    public ResourceDescription getDescription() {
        return null;
    }
}

