/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.mapping;

import org.springframework.context.annotation.Primary;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.core.Path;
import org.springframework.data.rest.core.mapping.CollectionResourceMapping;
import org.springframework.data.rest.core.mapping.RepositoryResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceDescription;
import org.springframework.data.rest.core.mapping.ResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.mapping.SearchResourceMappings;
import org.springframework.util.Assert;

class RepositoryAwareResourceInformation
implements ResourceMetadata {
    private final Repositories repositories;
    private final CollectionResourceMapping mapping;
    private final RepositoryResourceMappings provider;
    private final RepositoryMetadata repositoryInterface;

    public RepositoryAwareResourceInformation(Repositories repositories, CollectionResourceMapping mapping, RepositoryResourceMappings provider, RepositoryMetadata repositoryMetadata) {
        Assert.notNull((Object)repositories, (String)"Repositories must not be null!");
        Assert.notNull((Object)mapping, (String)"CollectionResourceMapping must not be null!");
        Assert.notNull((Object)provider, (String)"ResourceMetadataProvider must not be null!");
        Assert.notNull((Object)repositoryMetadata, (String)"RepositoryMetadata must not be null!");
        this.repositories = repositories;
        this.mapping = mapping;
        this.provider = provider;
        this.repositoryInterface = repositoryMetadata;
    }

    public boolean isPrimary() {
        return AnnotationUtils.findAnnotation((Class)this.repositoryInterface.getRepositoryInterface(), Primary.class) != null;
    }

    @Override
    public Class<?> getDomainType() {
        return this.repositoryInterface.getDomainType();
    }

    @Override
    public boolean isManagedResource(PersistentProperty<?> property) {
        Assert.notNull(property, (String)"PersistentProperty must not be null!");
        return this.repositories.hasRepositoryFor(property.getActualType());
    }

    @Override
    public ResourceMapping getMappingFor(PersistentProperty<?> property) {
        return this.provider.getMappingFor(property);
    }

    @Override
    public boolean isExported(PersistentProperty<?> property) {
        return this.provider.isMapped(property);
    }

    @Override
    public boolean isExported() {
        return this.mapping.isExported();
    }

    @Override
    public String getRel() {
        return this.mapping.getRel();
    }

    @Override
    public String getItemResourceRel() {
        return this.mapping.getItemResourceRel();
    }

    @Override
    public Path getPath() {
        return this.mapping.getPath();
    }

    @Override
    public boolean isPagingResource() {
        return this.mapping.isPagingResource();
    }

    @Override
    public ResourceDescription getDescription() {
        return this.mapping.getDescription();
    }

    @Override
    public ResourceDescription getItemResourceDescription() {
        return this.mapping.getItemResourceDescription();
    }

    @Override
    public Class<?> getExcerptProjection() {
        return this.mapping.getExcerptProjection();
    }

    @Override
    public SearchResourceMappings getSearchResourceMappings() {
        return this.provider.getSearchResourceMappings(this.repositoryInterface.getDomainType());
    }
}

