/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.invoke;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.core.CrudMethods;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.query.Param;
import org.springframework.data.rest.core.annotation.RestResource;
import org.springframework.data.rest.core.invoke.RepositoryInvoker;
import org.springframework.hateoas.core.AnnotationAttribute;
import org.springframework.hateoas.core.MethodParameters;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

class ReflectionRepositoryInvoker
implements RepositoryInvoker {
    private static final AnnotationAttribute PARAM_ANNOTATION = new AnnotationAttribute(Param.class);
    private final Object repository;
    private final CrudMethods methods;
    private final RepositoryInformation information;
    private final ConversionService conversionService;

    public ReflectionRepositoryInvoker(Object repository, RepositoryInformation information, ConversionService conversionService) {
        Assert.notNull((Object)repository, (String)"Repository must not be null!");
        Assert.notNull((Object)information, (String)"RepositoryInformation must not be null!");
        Assert.notNull((Object)conversionService, (String)"ConversionService must not be null!");
        this.repository = repository;
        this.methods = information.getCrudMethods();
        this.information = information;
        this.conversionService = conversionService;
    }

    @Override
    public boolean hasFindAllMethod() {
        return this.methods.hasFindAllMethod();
    }

    @Override
    public boolean exposesFindAll() {
        return this.methods.hasFindAllMethod() && this.exposes(this.methods.getFindAllMethod());
    }

    @Override
    public Iterable<Object> invokeFindAll(Sort sort) {
        return (Iterable)this.invoke(this.methods.getFindAllMethod(), sort);
    }

    @Override
    public Iterable<Object> invokeFindAll(Pageable pageable) {
        if (!this.exposesFindAll()) {
            return Collections.emptyList();
        }
        Method method = this.methods.getFindAllMethod();
        Class<?>[] types = method.getParameterTypes();
        if (types.length == 0) {
            return (Iterable)this.invoke(method, new Object[0]);
        }
        if (Sort.class.isAssignableFrom(types[0])) {
            return (Iterable)this.invoke(method, pageable == null ? null : pageable.getSort());
        }
        return (Iterable)this.invoke(method, pageable);
    }

    @Override
    public boolean hasSaveMethod() {
        return this.methods.hasSaveMethod();
    }

    @Override
    public boolean exposesSave() {
        return this.methods.hasSaveMethod() && this.exposes(this.methods.getSaveMethod());
    }

    @Override
    public <T> T invokeSave(T object) {
        return this.invoke(this.methods.getSaveMethod(), object);
    }

    @Override
    public boolean hasFindOneMethod() {
        return this.methods.hasFindOneMethod();
    }

    @Override
    public boolean exposesFindOne() {
        return this.methods.hasFindOneMethod() && this.exposes(this.methods.getFindOneMethod());
    }

    @Override
    public <T> T invokeFindOne(Serializable id) {
        return this.invoke(this.methods.getFindOneMethod(), this.convertId(id));
    }

    @Override
    public boolean hasDeleteMethod() {
        return this.methods.hasDelete();
    }

    @Override
    public boolean exposesDelete() {
        return this.methods.hasDelete() && this.exposes(this.methods.getDeleteMethod());
    }

    @Override
    public void invokeDelete(Serializable id) {
        Method method = this.methods.getDeleteMethod();
        Class<?> parameterType = method.getParameterTypes()[0];
        List<Class> idTypes = Arrays.asList(this.information.getIdType(), Serializable.class);
        if (idTypes.contains(parameterType)) {
            this.invoke(method, this.convertId(id));
        } else {
            this.invoke(method, this.invokeFindOne(id));
        }
    }

    private boolean exposes(Method method) {
        RestResource annotation = (RestResource)AnnotationUtils.findAnnotation((Method)method, RestResource.class);
        return annotation == null ? true : annotation.exported();
    }

    @Override
    public Object invokeQueryMethod(Method method, Map<String, String[]> parameters, Pageable pageable, Sort sort) {
        return this.invoke(method, this.prepareParameters(method, parameters, pageable, sort));
    }

    private Object[] prepareParameters(Method method, Map<String, String[]> rawParameters, Pageable pageable, Sort sort) {
        List parameters = new MethodParameters(method, PARAM_ANNOTATION).getParameters();
        if (parameters.isEmpty()) {
            return new Object[0];
        }
        Object[] result = new Object[parameters.size()];
        Sort sortToUse = pageable == null ? sort : pageable.getSort();
        for (int i = 0; i < result.length; ++i) {
            MethodParameter param = (MethodParameter)parameters.get(i);
            Class targetType = param.getParameterType();
            if (Pageable.class.isAssignableFrom(targetType)) {
                result[i] = pageable;
                continue;
            }
            if (Sort.class.isAssignableFrom(targetType)) {
                result[i] = sortToUse;
                continue;
            }
            String parameterName = param.getParameterName();
            if (!StringUtils.hasText((String)parameterName)) {
                throw new IllegalArgumentException("No @Param annotation found on query method " + method.getName() + " for parameter " + parameterName);
            }
            String[] parameterValue = rawParameters.get(parameterName);
            String[] value = parameterValue == null ? null : (parameterValue.length == 1 ? parameterValue[0] : parameterValue);
            result[i] = this.conversionService.convert((Object)value, TypeDescriptor.forObject((Object)value), new TypeDescriptor(param));
        }
        return result;
    }

    private <T> T invoke(Method method, Object ... arguments) {
        ReflectionUtils.makeAccessible((Method)method);
        return (T)ReflectionUtils.invokeMethod((Method)method, (Object)this.repository, (Object[])arguments);
    }

    protected Serializable convertId(Serializable id) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        return (Serializable)this.conversionService.convert((Object)id, this.information.getIdType());
    }
}

