/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.invoke;

import java.io.Serializable;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.rest.core.invoke.CrudRepositoryInvoker;

class PagingAndSortingRepositoryInvoker
extends CrudRepositoryInvoker {
    private final PagingAndSortingRepository<Object, Serializable> repository;

    public PagingAndSortingRepositoryInvoker(PagingAndSortingRepository<Object, Serializable> repository, RepositoryInformation information, ConversionService conversionService) {
        super((CrudRepository<Object, Serializable>)repository, information, conversionService);
        this.repository = repository;
    }

    @Override
    public Iterable<Object> invokeFindAll(Sort sort) {
        return sort == null ? this.invokeFindAll() : this.repository.findAll(sort);
    }

    @Override
    public Iterable<Object> invokeFindAll(Pageable pageable) {
        return pageable == null ? this.invokeFindAll() : this.repository.findAll(pageable);
    }
}

