/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.invoke;

import java.lang.reflect.Method;

public enum CrudMethod {
    COUNT,
    DELETE_ALL,
    DELETE_ONE,
    DELETE_SOME,
    FIND_ALL,
    FIND_ONE,
    FIND_SOME,
    SAVE_ONE,
    SAVE_SOME;


    public static CrudMethod fromMethod(Method m) {
        boolean some;
        String s = m.getName();
        Class<?>[] paramTypes = m.getParameterTypes();
        boolean bl = some = paramTypes.length > 0 && Iterable.class.isAssignableFrom(paramTypes[0]);
        if ("count".equals(s)) {
            return COUNT;
        }
        if ("delete".equals(s)) {
            return some ? DELETE_SOME : DELETE_ONE;
        }
        if ("deleteAll".equals(s)) {
            return DELETE_ALL;
        }
        if ("findAll".equals(s)) {
            return some ? FIND_SOME : FIND_ALL;
        }
        if ("findOne".equals(s)) {
            return FIND_ONE;
        }
        if ("save".equals(s)) {
            return some ? SAVE_SOME : SAVE_ONE;
        }
        return null;
    }

    public String toMethodName() {
        switch (this) {
            case COUNT: {
                return "count";
            }
            case DELETE_ALL: {
                return "deleteAll";
            }
            case DELETE_ONE: 
            case DELETE_SOME: {
                return "delete";
            }
            case FIND_ALL: 
            case FIND_SOME: {
                return "findAll";
            }
            case FIND_ONE: {
                return "findOne";
            }
            case SAVE_ONE: 
            case SAVE_SOME: {
                return "save";
            }
        }
        return null;
    }
}

