/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core.config;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.data.rest.core.config.MetadataConfiguration;
import org.springframework.data.rest.core.config.ProjectionDefinitionConfiguration;
import org.springframework.data.rest.core.config.ResourceMapping;
import org.springframework.data.rest.core.config.ResourceMappingConfiguration;
import org.springframework.hateoas.MediaTypes;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;

public class RepositoryRestConfiguration {
    private URI baseUri = URI.create("");
    private int defaultPageSize = 20;
    private int maxPageSize = 1000;
    private String pageParamName = "page";
    private String limitParamName = "size";
    private String sortParamName = "sort";
    private MediaType defaultMediaType = MediaTypes.HAL_JSON;
    private boolean useHalAsDefaultJsonMediaType = true;
    private boolean returnBodyOnCreate = false;
    private boolean returnBodyOnUpdate = false;
    private List<Class<?>> exposeIdsFor = new ArrayList();
    private ResourceMappingConfiguration domainMappings = new ResourceMappingConfiguration();
    private ResourceMappingConfiguration repoMappings = new ResourceMappingConfiguration();
    private final ProjectionDefinitionConfiguration projectionConfiguration;
    private final MetadataConfiguration metadataConfiguration;

    public RepositoryRestConfiguration() {
        this(new ProjectionDefinitionConfiguration(), new MetadataConfiguration());
    }

    public RepositoryRestConfiguration(ProjectionDefinitionConfiguration projectionConfiguration, MetadataConfiguration metadataConfiguration) {
        Assert.notNull((Object)projectionConfiguration, (String)"ProjectionDefinitionConfiguration must not be null!");
        Assert.notNull((Object)metadataConfiguration, (String)"MetadataConfiguration must not be null!");
        this.projectionConfiguration = projectionConfiguration;
        this.metadataConfiguration = metadataConfiguration;
    }

    public URI getBaseUri() {
        return this.baseUri;
    }

    public RepositoryRestConfiguration setBaseUri(URI baseUri) {
        Assert.notNull((Object)baseUri, (String)"The base URI cannot be null.");
        this.baseUri = baseUri;
        return this;
    }

    public RepositoryRestConfiguration setBaseUri(String baseUri) {
        Assert.notNull((Object)baseUri, (String)"The base URI cannot be null.");
        this.baseUri = URI.create(baseUri);
        return this;
    }

    public int getDefaultPageSize() {
        return this.defaultPageSize;
    }

    public RepositoryRestConfiguration setDefaultPageSize(int defaultPageSize) {
        Assert.isTrue((defaultPageSize > 0 ? 1 : 0) != 0, (String)"Page size must be greater than 0.");
        this.defaultPageSize = defaultPageSize;
        return this;
    }

    public int getMaxPageSize() {
        return this.maxPageSize;
    }

    public RepositoryRestConfiguration setMaxPageSize(int maxPageSize) {
        Assert.isTrue((this.defaultPageSize > 0 ? 1 : 0) != 0, (String)"Maximum page size must be greater than 0.");
        this.maxPageSize = maxPageSize;
        return this;
    }

    public String getPageParamName() {
        return this.pageParamName;
    }

    public RepositoryRestConfiguration setPageParamName(String pageParamName) {
        Assert.notNull((Object)pageParamName, (String)"Page param name cannot be null.");
        this.pageParamName = pageParamName;
        return this;
    }

    public String getLimitParamName() {
        return this.limitParamName;
    }

    public RepositoryRestConfiguration setLimitParamName(String limitParamName) {
        Assert.notNull((Object)limitParamName, (String)"Limit param name cannot be null.");
        this.limitParamName = limitParamName;
        return this;
    }

    public String getSortParamName() {
        return this.sortParamName;
    }

    public RepositoryRestConfiguration setSortParamName(String sortParamName) {
        Assert.notNull((Object)sortParamName, (String)"Sort param name cannot be null.");
        this.sortParamName = sortParamName;
        return this;
    }

    public MediaType getDefaultMediaType() {
        return this.defaultMediaType;
    }

    public RepositoryRestConfiguration setDefaultMediaType(MediaType defaultMediaType) {
        this.defaultMediaType = defaultMediaType;
        return this;
    }

    public boolean useHalAsDefaultJsonMediaType() {
        return this.useHalAsDefaultJsonMediaType;
    }

    public RepositoryRestConfiguration useHalAsDefaultJsonMediaType(boolean useHalAsDefaultJsonMediaType) {
        this.useHalAsDefaultJsonMediaType = useHalAsDefaultJsonMediaType;
        return this;
    }

    public boolean isReturnBodyOnCreate() {
        return this.returnBodyOnCreate;
    }

    public RepositoryRestConfiguration setReturnBodyOnCreate(boolean returnBodyOnCreate) {
        this.returnBodyOnCreate = returnBodyOnCreate;
        return this;
    }

    public boolean isReturnBodyOnUpdate() {
        return this.returnBodyOnUpdate;
    }

    public RepositoryRestConfiguration setReturnBodyOnUpdate(boolean returnBodyOnUpdate) {
        this.returnBodyOnUpdate = returnBodyOnUpdate;
        return this;
    }

    public ResourceMapping setResourceMappingForDomainType(Class<?> domainType) {
        return this.domainMappings.setResourceMappingFor(domainType);
    }

    public ResourceMapping getResourceMappingForDomainType(Class<?> domainType) {
        return this.domainMappings.getResourceMappingFor(domainType);
    }

    public boolean hasResourceMappingForDomainType(Class<?> domainType) {
        return this.domainMappings.hasResourceMappingFor(domainType);
    }

    public ResourceMappingConfiguration getDomainTypesResourceMappingConfiguration() {
        return this.domainMappings;
    }

    public ResourceMapping setResourceMappingForRepository(Class<?> repositoryInterface) {
        return this.repoMappings.setResourceMappingFor(repositoryInterface);
    }

    public ResourceMapping getResourceMappingForRepository(Class<?> repositoryInterface) {
        return this.repoMappings.getResourceMappingFor(repositoryInterface);
    }

    public boolean hasResourceMappingForRepository(Class<?> repositoryInterface) {
        return this.repoMappings.hasResourceMappingFor(repositoryInterface);
    }

    public ResourceMapping findRepositoryMappingForPath(String path) {
        Class<?> type = this.repoMappings.findTypeForPath(path);
        if (null == type) {
            return null;
        }
        return this.repoMappings.getResourceMappingFor(type);
    }

    public boolean isIdExposedFor(Class<?> domainType) {
        return this.exposeIdsFor.contains(domainType);
    }

    public RepositoryRestConfiguration exposeIdsFor(Class<?> ... domainTypes) {
        Collections.addAll(this.exposeIdsFor, domainTypes);
        return this;
    }

    public ProjectionDefinitionConfiguration projectionConfiguration() {
        return this.projectionConfiguration;
    }

    public MetadataConfiguration metadataConfiguration() {
        return this.metadataConfiguration;
    }
}

