/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core;

import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

public class UriToEntityConverter
implements ConditionalGenericConverter {
    private static final TypeDescriptor URI_TYPE = TypeDescriptor.valueOf(URI.class);
    private static final TypeDescriptor STRING_TYPE = TypeDescriptor.valueOf(String.class);
    private final PersistentEntities entities;
    private final Set<GenericConverter.ConvertiblePair> convertiblePairs;
    private final ConversionService conversionService;

    public UriToEntityConverter(PersistentEntities entities, ConversionService conversionService) {
        Assert.notNull((Object)entities, (String)"PersistentEntities must not be null!");
        Assert.notNull((Object)conversionService, (String)"ConversionService must not be null!");
        HashSet<GenericConverter.ConvertiblePair> convertiblePairs = new HashSet<GenericConverter.ConvertiblePair>();
        for (TypeInformation domainType : entities.getManagedTypes()) {
            Class rawType = domainType.getType();
            PersistentEntity entity = entities.getPersistentEntity(rawType);
            if (!entity.hasIdProperty()) continue;
            convertiblePairs.add(new GenericConverter.ConvertiblePair(URI.class, domainType.getType()));
        }
        this.convertiblePairs = Collections.unmodifiableSet(convertiblePairs);
        this.entities = entities;
        this.conversionService = conversionService;
    }

    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return this.conversionService.canConvert(STRING_TYPE, targetType);
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return this.convertiblePairs;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        PersistentEntity entity = this.entities.getPersistentEntity(targetType.getType());
        if (entity == null) {
            throw new ConversionFailedException(sourceType, targetType, source, (Throwable)new IllegalArgumentException("No PersistentEntity information available for " + targetType.getType()));
        }
        URI uri = (URI)source;
        String[] parts = uri.getPath().split("/");
        if (parts.length < 2) {
            throw new ConversionFailedException(sourceType, targetType, source, (Throwable)new IllegalArgumentException("Cannot resolve URI " + uri + ". Is it local or remote? Only local URIs are resolvable."));
        }
        return this.conversionService.convert((Object)parts[parts.length - 1], targetType.getType());
    }
}

