/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caeldev.spring.mvc;

import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@ControllerAdvice
public class RestExceptionHandler {
    @ExceptionHandler(value={IllegalArgumentException.class})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public ErrorInfo notFound(HttpServletRequest req) {
        String errorURL = req.getRequestURL().toString();
        return new ErrorInfo(errorURL, "Resource not found");
    }

    private class ErrorInfo {
        private final String errorURL;
        private final String message;

        public ErrorInfo(String errorURL, String message) {
            this.errorURL = errorURL;
            this.message = message;
        }

        public String getErrorURL() {
            return this.errorURL;
        }

        public String getMessage() {
            return this.message;
        }

        public int hashCode() {
            return Objects.hash(this.errorURL, this.message);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ErrorInfo other = (ErrorInfo)obj;
            return Objects.equals(this.errorURL, other.errorURL) && Objects.equals(this.message, other.message);
        }
    }
}

