/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caeldev.spring.mvc;

import org.springframework.hateoas.ResourceSupport;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

public class ResponseEntityBuilder<T extends ResourceSupport> {
    private HttpStatus statusCode;
    private T resource;
    private HttpHeaders headers = new HttpHeaders();

    ResponseEntityBuilder() {
    }

    public static <V extends ResourceSupport> ResponseEntityBuilder<V> responseEntityBuilder() {
        return new ResponseEntityBuilder();
    }

    public ResponseEntityBuilder<T> statusCode(HttpStatus statusCode) {
        this.statusCode = statusCode;
        return this;
    }

    public ResponseEntityBuilder<T> entity(T resource) {
        this.resource = resource;
        return this;
    }

    public ResponseEntityBuilder<T> header(String key, String value) {
        this.headers.add(key, value);
        return this;
    }

    public ResponseEntity<T> build() {
        return new ResponseEntity(this.resource, (MultiValueMap)this.headers, this.statusCode);
    }
}

