/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caeldev.spring.mvc;

import com.google.common.base.Optional;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.joda.time.LocalTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.springframework.web.util.UrlPathHelper;
import uk.co.caeldev.spring.mvc.ETagBuilder;

public abstract class ResourceInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceInterceptor.class);

    protected abstract String entityHashCodeByUUID(String var1);

    protected abstract String getUUIDVariableName();

    protected Optional<String> resolveHashCode(HttpServletRequest request) {
        Optional<String> uuid = this.getUUIDFromURI(request, this.getUUIDVariableName());
        if (!uuid.isPresent()) {
            return Optional.absent();
        }
        LOGGER.info("Resolved UUID from URL: {}", uuid.get());
        try {
            return Optional.of((Object)this.entityHashCodeByUUID((String)uuid.get()));
        }
        catch (IllegalArgumentException e) {
            LOGGER.info("Entity HashCode not Found");
            return Optional.absent();
        }
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        LOGGER.info("preHandle start");
        Optional<String> hashCode = this.resolveHashCode(request);
        if (!hashCode.isPresent()) {
            LOGGER.debug("HashCode not present");
            return super.preHandle(request, response, handler);
        }
        String token = ETagBuilder.eTagBuilder().value((String)hashCode.get()).build();
        LOGGER.debug("Token generated: {}", (Object)token);
        HttpMethod method = HttpMethod.valueOf((String)request.getMethod());
        LOGGER.debug("HTTP METHOD {}", (Object)method);
        switch (method) {
            case GET: {
                response.setHeader("ETag", token);
                response.setHeader("Last-Modified", LocalTime.now().toString());
                break;
            }
            case PUT: {
                Optional previousToken = Optional.fromNullable((Object)request.getHeader("If-Match"));
                if (!previousToken.isPresent()) {
                    response.sendError(HttpStatus.PRECONDITION_REQUIRED.value());
                    return false;
                }
                if (((String)previousToken.get()).equals(token)) break;
                LOGGER.debug("Previous token: {}", previousToken.orNull());
                response.sendError(HttpStatus.PRECONDITION_FAILED.value());
                return false;
            }
        }
        return super.preHandle(request, response, handler);
    }

    protected Optional<String> getUUIDFromURI(HttpServletRequest request, String variableNameUUID) {
        LOGGER.info("Get UUID from URI");
        UrlPathHelper urlPathHelper = new UrlPathHelper();
        Map pathVariables = (Map)request.getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
        Map decodedPathVariables = urlPathHelper.decodePathVariables(request, pathVariables);
        return Optional.fromNullable(decodedPathVariables.get(variableNameUUID));
    }
}

