/*
 * Decompiled with CFR 0.152.
 */
package top.xtcoder.service;

import cn.dev33.satoken.stp.StpUtil;
import cn.hutool.core.io.FileUtil;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import net.coobird.thumbnailator.Thumbnails;
import org.nutz.dao.Dao;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import top.xtcoder.common.Funs;
import top.xtcoder.config.FileUploadConf;
import top.xtcoder.entity.system.FileInfo;

@Service
public class UploadService {
    @Autowired
    private FileUploadConf fileUploadConf;
    @Autowired
    private Dao dao;

    public FileInfo uploadAndSaveDB(File file, String originalFilename, String title) throws Exception {
        FileInfo data = this.upload(file, originalFilename, title);
        data = (FileInfo)data.insertOrUpdate(this.dao);
        return data;
    }

    public FileInfo upload(File file, String originalFilename, String title) throws Exception {
        String dir = this.fileUploadConf.getSavePath();
        System.out.println("dir=" + dir);
        String ymd = Funs.getNowLocalDate();
        File fileBaseDir = new File(dir);
        if (!fileBaseDir.canWrite()) {
            throw new Exception("\u4e0a\u4f20\u76ee\u5f55\u6ca1\u6709\u5199\u6743\u9650\u3002");
        }
        File fileDir = new File(dir + File.separator + ymd);
        if (!fileDir.exists()) {
            fileDir.mkdirs();
            File f = new File(dir + File.separator + ymd + File.separator + "index.html");
            f.createNewFile();
        }
        String fileSuffix = originalFilename.substring(originalFilename.lastIndexOf(".")).toLowerCase();
        if (!Arrays.asList(this.fileUploadConf.extMap().get("all").split(",")).contains(fileSuffix)) {
            throw new Exception("\u4e0a\u4f20\u6587\u4ef6\u662f\u4e0d\u5141\u8bb8\u4e0a\u4f20\u7684\u6587\u4ef6\u7c7b\u578b\u3002");
        }
        String fileName = Funs.getFileNameBySm3() + fileSuffix;
        File saveFile = new File(fileDir + File.separator + fileName);
        if (Arrays.asList(this.fileUploadConf.extMap().get("imageNoGif").split(",")).contains(fileSuffix)) {
            if (file.length() > 0x200000L) {
                this.compress(file, saveFile, (double)0.7f);
            } else {
                FileUtil.copy((File)file, (File)saveFile, (boolean)true);
            }
        } else {
            FileUtil.copy((File)file, (File)saveFile, (boolean)true);
        }
        String path = "/" + ymd + "/" + fileName;
        String url = this.fileUploadConf.getBaseUrl() + path;
        FileInfo data = new FileInfo();
        data.init();
        data.setName(originalFilename);
        data.setTitle(title);
        data.setPath(path);
        data.setUrl(url);
        data.setSuffix(fileSuffix.replace(".", ""));
        data.setSize(saveFile.length());
        String userid = "DEFAULT";
        String usertype = "DEFAULT";
        try {
            userid = StpUtil.getLoginId().toString().substring(1);
            usertype = StpUtil.getLoginId().toString().substring(0, 1);
        }
        catch (Exception e) {
            System.err.println("\u672a\u767b\u5f55\u7528\u6237\u4e0a\u4f20\uff0c\u91c7\u7528\u9ed8\u8ba4userid=DEFAULT");
        }
        data.setUserid(userid);
        return data;
    }

    public void compress(File file, File saveFile, double scale) {
        try {
            Thumbnails.of((File[])new File[]{file}).scale(scale).toFile(saveFile.getPath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void compress(InputStream is, File saveFile, double scale) {
        try {
            Thumbnails.of((InputStream[])new InputStream[]{is}).scale(scale).toFile(saveFile.getPath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

