/*
 * Decompiled with CFR 0.152.
 */
package top.xtcoder.redis;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.BoundSetOperations;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Component;
import top.xtcoder.common.Jacksons;

@Component
public class RedisCache {
    @Autowired
    public RedisTemplate redisTemplate;

    public <T> ValueOperations<String, T> setCacheObject(String key, T value) {
        ValueOperations operation = this.redisTemplate.opsForValue();
        operation.set((Object)key, value);
        return operation;
    }

    public <T> ValueOperations<String, T> setCacheObject(String key, T value, Integer timeout, TimeUnit timeUnit) {
        ValueOperations operation = this.redisTemplate.opsForValue();
        operation.set((Object)key, value, (long)timeout.intValue(), timeUnit);
        return operation;
    }

    public <T> T getCacheObject(String key) {
        ValueOperations operation = this.redisTemplate.opsForValue();
        return (T)operation.get((Object)key);
    }

    public void deleteObject(String key) {
        if (this.hashKeys(key)) {
            this.redisTemplate.delete((Object)key);
        }
    }

    public void deleteObject(Collection collection) {
        this.redisTemplate.delete(collection);
    }

    public <T> ListOperations<String, T> setCacheList(String key, List<T> dataList) {
        ListOperations listOperation = this.redisTemplate.opsForList();
        if (null != dataList) {
            int size = dataList.size();
            for (int i = 0; i < size; ++i) {
                listOperation.leftPush((Object)key, dataList.get(i));
            }
        }
        return listOperation;
    }

    public <T> List<T> getCacheList(String key) {
        ArrayList<Object> dataList = new ArrayList<Object>();
        ListOperations listOperation = this.redisTemplate.opsForList();
        Long size = listOperation.size((Object)key);
        int i = 0;
        while ((long)i < size) {
            dataList.add(listOperation.index((Object)key, (long)i));
            ++i;
        }
        return dataList;
    }

    public <T> BoundSetOperations<String, T> setCacheSet(String key, Set<T> dataSet) {
        BoundSetOperations setOperation = this.redisTemplate.boundSetOps((Object)key);
        Iterator<T> it = dataSet.iterator();
        while (it.hasNext()) {
            setOperation.add(new Object[]{it.next()});
        }
        return setOperation;
    }

    public <T> Set<T> getCacheSet(String key) {
        Set dataSet = new HashSet();
        BoundSetOperations operation = this.redisTemplate.boundSetOps((Object)key);
        dataSet = operation.members();
        return dataSet;
    }

    public <T> HashOperations<String, String, T> setCacheMap(String key, Map<String, T> dataMap) {
        HashOperations hashOperations = this.redisTemplate.opsForHash();
        if (null != dataMap) {
            for (Map.Entry<String, T> entry : dataMap.entrySet()) {
                hashOperations.put((Object)key, (Object)entry.getKey(), entry.getValue());
            }
        }
        return hashOperations;
    }

    public int getCacheInt(String key) {
        ValueOperations operation = this.redisTemplate.opsForValue();
        return operation.get((Object)key) == null ? 0 : (Integer)operation.get((Object)key);
    }

    public <T> Map<String, T> getCacheMap(String key) {
        Map map = this.redisTemplate.opsForHash().entries((Object)key);
        return map;
    }

    public Collection<String> keys(String pattern) {
        return this.redisTemplate.keys((Object)pattern);
    }

    public <T> ValueOperations<String, T> setCacheData(String key, T value, long minutes) {
        ValueOperations operation = this.redisTemplate.opsForValue();
        operation.set((Object)key, value, Duration.ofMinutes(minutes));
        return operation;
    }

    public <T> ValueOperations<String, T> resetCacheData(String key, T value, long minutes) {
        if (this.hashKeys(key)) {
            this.deleteObject(key);
        }
        ValueOperations operation = this.redisTemplate.opsForValue();
        operation.set((Object)key, value, Duration.ofMinutes(minutes));
        return operation;
    }

    public <T> ValueOperations<String, T> resetCacheData(String key, T value) {
        if (this.hashKeys(key)) {
            this.deleteObject(key);
        }
        ValueOperations operation = this.redisTemplate.opsForValue();
        operation.set((Object)key, value);
        return operation;
    }

    public boolean hashKeys(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    public void deleteBySuffix(String key) {
        Set keys = this.redisTemplate.keys((Object)("*" + key));
        this.redisTemplate.delete((Collection)keys);
    }

    public void deleteByPrex(String key) {
        Set keys = this.redisTemplate.keys((Object)(key + "*"));
        this.redisTemplate.delete((Collection)keys);
    }

    public Set<String> keysPrex(String keyPrefix) {
        String realKey = "*" + keyPrefix + "*";
        try {
            return (Set)this.redisTemplate.execute(connection -> {
                HashSet<String> binaryKeys = new HashSet<String>();
                try {
                    Cursor cursor = connection.scan(ScanOptions.scanOptions().match(realKey).count(Integer.MAX_VALUE).build());
                    while (cursor.hasNext()) {
                        binaryKeys.add(new String((byte[])cursor.next()));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return binaryKeys;
            });
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean removeAll(String keyPrefix) {
        try {
            Set<String> keys = this.keysPrex(keyPrefix);
            if (keys != null) {
                this.redisTemplate.delete(keys);
            }
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    public long getExpire(String key, TimeUnit timeUnit) {
        return this.redisTemplate.getExpire((Object)key, timeUnit);
    }

    public long getExpireMin(String key) {
        return this.redisTemplate.getExpire((Object)key, TimeUnit.MINUTES);
    }

    public long getExpireSeconds(String key) {
        return this.redisTemplate.getExpire((Object)key, TimeUnit.SECONDS);
    }

    public <T> Object setListString(String key, List<T> list) {
        if (this.hashKeys(key)) {
            this.deleteObject(key);
        }
        ValueOperations operation = this.redisTemplate.opsForValue();
        operation.set((Object)key, (Object)Jacksons.toJSONString(list));
        return operation;
    }

    public <T> List<T> getListString(String key, Class<T> clazz) {
        if (!this.hashKeys(key)) {
            return null;
        }
        ValueOperations operation = this.redisTemplate.opsForValue();
        Object rsdata = operation.get((Object)key);
        List<T> list = Jacksons.toList(rsdata.toString(), clazz);
        return list;
    }
}

