/*
 * Decompiled with CFR 0.152.
 */
package top.xtcoder.exception;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.validation.UnexpectedTypeException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nutz.json.Json;
import org.nutz.lang.util.NutMap;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.multipart.MultipartException;
import top.xtcoder.core.Resp;

@RestControllerAdvice
public class CustomExceptionResolver {
    private final Logger log = LogManager.getLogger(CustomExceptionResolver.class);
    @Value(value="${spring.servlet.multipart.max-file-size:''}")
    private String maxFileSize;
    @Value(value="${spring.servlet.multipart.max-request-size:''}")
    private String maxRequestSize;

    @ExceptionHandler(value={Exception.class})
    public Object handleException(Exception e, HttpServletRequest req) {
        System.out.println("\u5168\u5c40\u5f02\u5e38\u5904\u7406...");
        e.printStackTrace();
        return new Resp().error("\u8fd4\u56de\u5f02\u5e38\u4fe1\u606f\uff0c\u8bf7\u67e5\u770b\u540e\u53f0\u8be6\u7ec6\u4fe1\u606f").data(NutMap.NEW().addv("message", (Object)e.getMessage()));
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class, UnexpectedTypeException.class})
    public Object handleException(MethodArgumentNotValidException e, HttpServletRequest req) {
        System.out.println("\u53c2\u6570\u5f02\u5e38\u5904\u7406...");
        String msg = ((ObjectError)e.getBindingResult().getAllErrors().get(0)).getDefaultMessage();
        ArrayList<NutMap> errorMaps = new ArrayList<NutMap>();
        for (ObjectError error : e.getBindingResult().getAllErrors()) {
            NutMap errorMap = NutMap.WRAP((String)Json.toJson((Object)error));
            errorMap.remove((Object)"arguments");
            errorMap.remove((Object)"codes");
            errorMaps.add(errorMap);
        }
        e.printStackTrace();
        return new Resp().error(msg).data(errorMaps);
    }

    @ExceptionHandler(value={MultipartException.class})
    public Object fileUploadExceptionHandler(MultipartException e) {
        System.out.println("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff0c\u670d\u52a1\u5668\u5f02\u5e38:" + e.getMessage());
        return new Resp().error("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff0c\u670d\u52a1\u5668\u5f02\u5e38");
    }

    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    public Object uploadException(MaxUploadSizeExceededException e) {
        return new Resp().error("\u4e0a\u4f20\u6587\u4ef6\u5927\u5c0f\u8d85\u51fa\u9650\u5236,\u5355\u4e2a\u6587\u4ef6\u4e0d\u80fd\u8d85\u8fc7\uff1a" + this.maxFileSize + "\uff0c\u591a\u6587\u4ef6\u603b\u5927\u5c0f\u4e0d\u80fd\u8d85\u8fc7\uff1a" + this.maxRequestSize);
    }
}

