/*
 * Decompiled with CFR 0.152.
 */
package top.xtcoder.controller.system;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.Dao;
import org.nutz.dao.QueryResult;
import org.nutz.dao.pager.Pager;
import org.nutz.json.Json;
import org.nutz.lang.Strings;
import org.nutz.lang.util.NutMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import top.xtcoder.core.KV;
import top.xtcoder.core.Resp;
import top.xtcoder.entity.system.SysConfigType;
import top.xtcoder.entity.system.SysConfigs;
import top.xtcoder.service.ConfigService;

@Api(tags={"\u7cfb\u7edf\u914d\u7f6e\u6a21\u5757"})
@RestController
@RequestMapping(value={"/prbase/system/config"})
public class SysConfigController {
    @Autowired
    private Dao dao;
    @Autowired
    private ConfigService configService;

    @ApiOperation(value="\u7cfb\u7edf\u914d\u7f6e-\u6dfb\u52a0/\u7f16\u8f91")
    @PostMapping(value={"/addOrUpdate"})
    public Resp<SysConfigs> addOrUpdate(@Valid @RequestBody SysConfigs data) {
        SysConfigType type;
        if (data.getFieldType() < 1 || data.getFieldType() > 3) {
            return new Resp().error("\u5b57\u6bb5\u7c7b\u578b\u4e0d\u5408\u6cd5[1:\u666e\u901a\u503c\uff0c2:\u5355\u9009\u6846, 3:\u591a\u9009\u503c]");
        }
        if (data.getFieldType() == 2 || data.getFieldType() == 3) {
            try {
                Json.fromJsonAsList(KV.class, (CharSequence)data.getFieldValue());
            }
            catch (Exception e) {
                return new Resp().error("\u914d\u7f6e\u7684\u503c\u4e0d\u6b63\u786e\uff0c\u683c\u5f0f\u4e3a[{k, v}...]json\u5b57\u7b26\u4e32");
            }
        }
        if ((type = (SysConfigType)this.dao.fetch(SysConfigType.class, data.getFieldTypeId())) == null) {
            return new Resp().error("\u5b57\u6bb5\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        data.setFieldTypeName(type.getTypeName());
        Cnd c = Cnd.where((String)"isdelete", (String)"=", (Object)0).and("field_code", "=", (Object)data.getFieldCode());
        if (!Strings.isBlank((CharSequence)data.getId())) {
            c.and("id", "!=", (Object)data.getId());
        }
        int count = this.dao.count(SysConfigs.class, (Condition)c);
        if (count > 0) {
            return new Resp().error("\u8be5\u5b57\u6bb5\u4ee3\u7801\u5df2\u88ab\u4f7f\u7528\u4e86");
        }
        data.insertOrUpdate(this.dao);
        return Resp.OBJ_O(data);
    }

    @ApiOperation(value="\u7cfb\u7edf\u914d\u7f6e-\u8f6f\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Resp delete(@RequestParam(value="id") String id, HttpServletRequest request) {
        if (Strings.isBlank((CharSequence)id)) {
            return new Resp().error("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SysConfigs tea = (SysConfigs)this.dao.fetch(SysConfigs.class, id);
        if (tea == null) {
            return new Resp().error("\u8be5\u6570\u636e\u5df2\u7ecf\u88ab\u5220\u9664\u4e86");
        }
        tea.setIsdelete(1);
        int num = this.dao.update((Object)tea);
        return Resp.OBJ_O(num);
    }

    @ApiOperation(value="\u7cfb\u7edf\u914d\u7f6e-\u5217\u8868")
    @GetMapping(value={"/list"})
    public Resp<SysConfigs> list(@ApiParam(value="\u5b57\u6bb5\u7c7b\u578b\u4e0d\u5408\u6cd5[-100:\u4e0d\u9650, 1:\u666e\u901a\u503c\uff0c2:\u5355\u9009\u6846, 3:\u591a\u9009\u503c]") @RequestParam(name="fieldType", defaultValue="-100") int fieldType, @ApiParam(value="\u5206\u7c7bID, \u7a7a\u5168\u90e8") @RequestParam(name="typeid", defaultValue="") String typeid, @ApiParam(value="\u9875\u6570") @RequestParam(name="page", defaultValue="1") int page, @ApiParam(value="\u6bcf\u9875\u663e\u793a\u6761\u6570") @RequestParam(name="limit", defaultValue="10") int limit) {
        Cnd cnd = Cnd.where((String)"isdelete", (String)"=", (Object)0);
        if (fieldType != -100) {
            cnd.and("field_type", "=", (Object)fieldType);
        }
        if (Strings.isNotBlank((CharSequence)typeid)) {
            cnd.and("field_type_id", "=", (Object)typeid);
        }
        Pager pager = this.dao.createPager(page, limit);
        pager.setRecordCount(this.dao.count(SysConfigs.class, (Condition)cnd));
        List list = this.dao.query(SysConfigs.class, (Condition)cnd.asc("field_code"), pager);
        ArrayList maps = new ArrayList();
        if (list != null) {
            list.forEach(item -> {
                NutMap map = NutMap.WRAP((String)Json.toJson((Object)item));
                maps.add(map);
            });
        }
        return new Resp<QueryResult>().ok("\u83b7\u53d6\u6210\u529f", new QueryResult(maps, pager));
    }

    @ApiOperation(value="\u7cfb\u7edf\u914d\u7f6e-\u8bfb\u53d6\u914d\u7f6e")
    @GetMapping(value={"/getConfig"})
    public Resp<SysConfigs> getConfig(@ApiParam(value="\u914d\u7f6e\u5206\u7c7b\u540d\u79f0") @RequestParam(name="fieldTypeName", defaultValue="") String fieldTypeName, @ApiParam(value="\u5b57\u6bb5\u4ee3\u7801") @RequestParam(name="fieldCode", defaultValue="") String fieldCode) {
        if (Strings.isBlank((CharSequence)fieldCode)) {
            return new Resp().error("\u5b57\u6bb5\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Cnd cnd = Cnd.where((String)"isdelete", (String)"=", (Object)0);
        if (Strings.isNotBlank((CharSequence)fieldCode)) {
            cnd.and("field_code", "=", (Object)fieldCode);
        }
        if (Strings.isNotBlank((CharSequence)fieldTypeName)) {
            cnd.and("fieldTypeName", "=", (Object)fieldTypeName);
        }
        SysConfigs config = (SysConfigs)this.dao.fetch(SysConfigs.class, (Condition)cnd);
        NutMap map = NutMap.WRAP((String)Json.toJson((Object)config));
        if (config.getFieldType() == 2 || config.getFieldType() == 3) {
            map.put((Object)"fieldValue", (Object)Json.fromJsonAsList(NutMap.class, (CharSequence)Json.toJson((Object)config.getFieldValue())));
        }
        return new Resp<NutMap>().ok("\u83b7\u53d6\u6210\u529f", map);
    }

    @ApiOperation(value="\u7cfb\u7edf\u914d\u7f6e-\u8bfb\u53d6\u5b57\u7b26\u4e32\u914d\u7f6e")
    @GetMapping(value={"/getStrConfig"})
    public Resp getStrConfig(@ApiParam(value="\u5b57\u6bb5\u4ee3\u7801") @RequestParam(name="fieldCode", defaultValue="") String fieldCode) {
        if (Strings.isBlank((CharSequence)fieldCode)) {
            return new Resp().error("\u5b57\u6bb5\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return new Resp<String>().ok("\u83b7\u53d6\u6210\u529f", this.configService.getStrConfig(fieldCode));
    }

    @ApiOperation(value="\u7cfb\u7edf\u914d\u7f6e-\u8bfb\u53d6\u591a\u4e2a\u5b57\u7b26\u4e32\u914d\u7f6e-\u666e\u901a\u6587\u672c\u503c")
    @GetMapping(value={"/getStrConfigs"})
    public Resp getStrConfigs(@ApiParam(value="\u5b57\u6bb5\u4ee3\u7801,\u591a\u4e2a\u7528\u9017\u53f7(,)\u597d\u5206\u5272") @RequestParam(name="fieldCodes", defaultValue="") String fieldCodes) {
        if (Strings.isBlank((CharSequence)fieldCodes)) {
            return new Resp().error("\u5b57\u6bb5\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return new Resp<NutMap>().ok("\u83b7\u53d6\u6210\u529f", this.configService.getStrConfigs(fieldCodes));
    }

    @ApiOperation(value="\u7cfb\u7edf\u914d\u7f6e-\u8bfb\u53d6\u6570\u5b57\u914d\u7f6e")
    @GetMapping(value={"/getIntConfig"})
    public Resp getIntConfig(@ApiParam(value="\u5b57\u6bb5\u4ee3\u7801") @RequestParam(name="fieldCode", defaultValue="") String fieldCode) {
        if (Strings.isBlank((CharSequence)fieldCode)) {
            return new Resp().error("\u5b57\u6bb5\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return new Resp<Integer>().ok("\u83b7\u53d6\u6210\u529f", this.configService.getIntConfig(fieldCode));
    }

    @ApiOperation(value="\u7cfb\u7edf\u914d\u7f6e-\u8bfb\u53d6\u5b57\u7b26\u4e32\u914d\u7f6e")
    @GetMapping(value={"/getKvConfig"})
    public Resp getKvConfig(@ApiParam(value="\u5b57\u6bb5\u4ee3\u7801") @RequestParam(name="fieldCode", defaultValue="") String fieldCode) {
        if (Strings.isBlank((CharSequence)fieldCode)) {
            return new Resp().error("\u5b57\u6bb5\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return new Resp<List<KV>>().ok("\u83b7\u53d6\u6210\u529f", this.configService.getKvConfig(fieldCode));
    }
}

