/*
 * Decompiled with CFR 0.152.
 */
package top.xtcoder.controller.system;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.Dao;
import org.nutz.dao.Sqls;
import org.nutz.dao.sql.Sql;
import org.nutz.dao.sql.SqlCallback;
import org.nutz.lang.util.NutMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import top.xtcoder.core.Resp;
import top.xtcoder.entity.system.Role;
import top.xtcoder.entity.system.RolePermission;

@Api(tags={"\u521d\u59cb\u5316\u6a21\u5757"})
@RestController
@RequestMapping(value={"/prbase/system/init"})
public class InitController {
    @Autowired
    private Dao dao;

    @ApiOperation(value="\u751f\u6210\u521d\u59cb\u5b89\u88c5\u6587\u4ef6")
    @GetMapping(value={"/build"})
    public Resp<NutMap> getbuild() {
        List rolePermissions = this.dao.query(RolePermission.class, null);
        rolePermissions.forEach(item -> {
            Role role = (Role)this.dao.fetch(Role.class, (Condition)Cnd.where((String)"id", (String)"=", (Object)item.getRoleid()));
            item.setRolecode(role.getCode());
            item.insertOrUpdate(this.dao);
        });
        List<String> insertSqls = this.getBuildSql("permission");
        insertSqls.addAll(this.getBuildSql("role_permission"));
        insertSqls.addAll(this.getBuildSql("sys_configs"));
        insertSqls.addAll(this.getBuildSql("sys_config_type"));
        try {
            String path = System.getProperty("user.dir");
            String filepath = path + "/zqtapi/src/main/resources/sqls/build.sql";
            System.out.println("filepath=" + filepath);
            File f = new File(filepath);
            FileWriter fw = new FileWriter(f.getPath());
            int len = insertSqls.size();
            String str = "";
            for (int i = 0; i < len; ++i) {
                str = insertSqls.get(i);
                fw.write("/* build" + i + " */");
                fw.write("\r\n");
                fw.write(str + ";");
                fw.write("\r\n");
            }
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Resp.ERROR("\u5199\u5165\u5931\u8d25");
        }
        Date date = new Date();
        long time = date.getTime();
        NutMap map = NutMap.NEW();
        map.addv("time", (Object)time);
        return Resp.OK("ok", map);
    }

    private List<String> getBuildSql(final String table) {
        Sql sql = Sqls.create((String)"SELECT * FROM $table");
        sql.vars().set("table", (Object)table);
        sql.setCallback(new SqlCallback(){

            public Object invoke(Connection connection, ResultSet resultSet, Sql sql) throws SQLException {
                ResultSetMetaData rsmd = resultSet.getMetaData();
                int count = rsmd.getColumnCount() + 1;
                ArrayList<String> insertSqls = new ArrayList<String>();
                String tmpsql = "";
                String fielden = "";
                String fieldval = "";
                while (resultSet.next()) {
                    tmpsql = "insert into " + table;
                    for (int i = 1; i < count; ++i) {
                        fielden = fielden + rsmd.getColumnLabel(i) + ",";
                        fieldval = resultSet.getString(i) == null ? fieldval + "''," : fieldval + "'" + resultSet.getString(i).replace("'", "''") + "',";
                    }
                    tmpsql = tmpsql + "(" + fielden.substring(0, fielden.length() - 1) + ") values(" + fieldval.substring(0, fieldval.length() - 1) + ")";
                    insertSqls.add(tmpsql);
                    fielden = "";
                    fieldval = "";
                }
                return insertSqls;
            }
        });
        this.dao.execute(sql);
        ArrayList<String> insertSqls = new ArrayList();
        insertSqls = sql.getList(String.class);
        return insertSqls;
    }
}

