/*
 * Decompiled with CFR 0.152.
 */
package top.xtcoder.controller.file;

import cn.hutool.core.io.FileUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.Dao;
import org.nutz.dao.util.cri.SqlExpression;
import org.nutz.dao.util.cri.SqlExpressionGroup;
import org.nutz.filepool.FilePool;
import org.nutz.lang.Files;
import org.nutz.lang.util.NutMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import top.xtcoder.common.Funs;
import top.xtcoder.config.FileUploadConf;
import top.xtcoder.core.Resp;
import top.xtcoder.entity.system.FileInfo;
import top.xtcoder.service.UploadService;

@Api(tags={"\u901a\u7528\u6587\u4ef6\u4e0a\u4f20\u6a21\u5757"})
@RestController
@RequestMapping(value={"/prbase/file/upload"})
public class UploadFileController {
    @Autowired
    private FileUploadConf fileUploadConf;
    @Autowired
    private UploadService uploadService;
    @Autowired
    private Dao dao;
    @Autowired
    private FilePool pool;

    @Order(value=0)
    @ApiOperation(value="\u5355\u6587\u4ef6\u4e0a\u4f20\u65b9\u6cd5-\u4e0d\u4fdd\u5b58\u5230\u6570\u636e\u5e93", consumes="multipart/form-data")
    @ApiImplicitParams(value={@ApiImplicitParam(name="file", value="\u6587\u4ef6\u6d41\u6570\u636e", required=true, paramType="form", dataType="__File")})
    @PostMapping(value={"/singleFiles"})
    public Resp<FileInfo> singleFiles(@RequestParam(value="file", required=true) MultipartFile file, HttpServletRequest request) {
        try {
            String fileName = file.getOriginalFilename();
            File tmpFile = this.pool.createFile(Files.getSuffix((String)fileName));
            file.transferTo(tmpFile);
            FileInfo fileInfo = this.uploadService.upload(tmpFile, file.getOriginalFilename(), file.getOriginalFilename());
            tmpFile.deleteOnExit();
            return Resp.OK("OK", fileInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Resp.ERROR(e.getMessage());
        }
    }

    @Order(value=1)
    @ApiOperation(value="\u6279\u91cf\u6587\u4ef6\u4e0a\u4f20\u65b9\u6cd5-\u4e0d\u4fdd\u5b58\u5230\u6570\u636e\u5e93", consumes="multipart/form-data")
    @ApiImplicitParam(name="files", value="\u6587\u4ef6\u6d41\u6570\u636e", required=true, dataType="__File", allowMultiple=true)
    @PostMapping(value={"/batchFiles"})
    public Resp<List<FileInfo>> batchFiles(MultipartFile[] files, HttpServletRequest request) {
        if (files == null || files.length <= 0) {
            return new Resp().error("\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a");
        }
        try {
            ArrayList<FileInfo> fileInfos = new ArrayList<FileInfo>();
            for (MultipartFile file : files) {
                String fileName = file.getOriginalFilename();
                File tmpFile = this.pool.createFile(Files.getSuffix((String)fileName));
                file.transferTo(tmpFile);
                FileInfo fileInfo = this.uploadService.upload(tmpFile, file.getOriginalFilename(), file.getOriginalFilename());
                fileInfos.add(fileInfo);
                tmpFile.deleteOnExit();
            }
            return Resp.OK("\u4e0a\u4f20\u6210\u529f", fileInfos);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Resp.ERROR(e.getMessage());
        }
    }

    @Order(value=2)
    @ApiOperation(value="\u5355\u6587\u4ef6\u4e0a\u4f20\u65b9\u6cd5-\u4fdd\u5b58\u5230\u6570\u636e\u5e93", consumes="multipart/form-data")
    @ApiImplicitParams(value={@ApiImplicitParam(name="file", value="\u6587\u4ef6\u6d41\u6570\u636e", required=true, paramType="form", dataType="__File")})
    @PostMapping(value={"/singleFilesSaveDB"})
    public Resp<FileInfo> singleFilesSaveDB(@RequestParam(value="file", required=true) MultipartFile file, HttpServletRequest request) {
        try {
            String fileName = file.getOriginalFilename();
            File tmpFile = this.pool.createFile(Files.getSuffix((String)fileName));
            file.transferTo(tmpFile);
            FileInfo fileInfo = this.uploadService.uploadAndSaveDB(tmpFile, file.getOriginalFilename(), file.getOriginalFilename());
            tmpFile.deleteOnExit();
            return Resp.OK("OK", fileInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Resp.ERROR(e.getMessage());
        }
    }

    @Order(value=3)
    @ApiOperation(value="\u6279\u91cf\u6587\u4ef6\u4e0a\u4f20\u65b9\u6cd5-\u4fdd\u5b58\u5230\u6570\u636e\u5e93", consumes="multipart/form-data")
    @ApiImplicitParam(name="files", value="\u6587\u4ef6\u6d41\u6570\u636e", required=true, dataType="__File", allowMultiple=true)
    @PostMapping(value={"/batchFilesSaveDB"})
    public Resp<List<FileInfo>> batchFilesSaveDB(MultipartFile[] files, HttpServletRequest request) {
        if (files == null || files.length <= 0) {
            return new Resp().error("\u6587\u4ef6\u5217\u8868\u4e3a\u7a7a");
        }
        try {
            ArrayList<FileInfo> fileInfos = new ArrayList<FileInfo>();
            for (MultipartFile file : files) {
                String fileName = file.getOriginalFilename();
                File tmpFile = this.pool.createFile(Files.getSuffix((String)fileName));
                file.transferTo(tmpFile);
                FileInfo fileInfo = this.uploadService.uploadAndSaveDB(tmpFile, file.getOriginalFilename(), file.getOriginalFilename());
                fileInfos.add(fileInfo);
                tmpFile.deleteOnExit();
            }
            return Resp.OK("\u4e0a\u4f20\u6210\u529f", fileInfos);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Resp.ERROR(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u901a\u8fc7\u6587\u4ef6id\u4e0b\u8f7d\u6587\u4ef6")
    @GetMapping(value={"/filedown"})
    @Order(value=4)
    public String filedown(@ApiParam(value="\u4e0b\u8f7d\u6587\u4ef6\u540d \u4e3a\u7a7a\u9ed8\u8ba4\u4e3a\u4e0a\u4f20\u65f6\u5019\u7684\u6587\u4ef6\u540d\u79f0") @RequestParam(name="outFileName", defaultValue="") String outFileName, @ApiParam(value="fileid") @RequestParam String fileid, HttpServletRequest request, HttpServletResponse response) {
        File file;
        if (Funs.isBlank(fileid)) {
            response.reset();
            response.setContentType("text/html");
            response.setHeader("Content-Type", "text/html;charset=UTF-8");
            return "<script>alert('fileid');</script>";
        }
        Cnd cnd = Cnd.where((String)"isdelete", (String)"=", (Object)0).and("id", "=", (Object)fileid);
        FileInfo f = (FileInfo)this.dao.fetch(FileInfo.class, (Condition)cnd);
        if (f == null) {
            response.reset();
            response.setContentType("text/html");
            response.setHeader("Content-Type", "text/html;charset=UTF-8");
            return "<script>alert('\u6ca1\u6709\u627e\u5230\u8be5\u8bb0\u5f55');</script>";
        }
        String saveFilePath = f.getPath();
        String docTitle = f.getName();
        if (Funs.isBlank(saveFilePath)) {
            response.reset();
            response.setContentType("text/html");
            response.setHeader("Content-Type", "text/html;charset=UTF-8");
            return "<script>alert('\u9274\u6743\u5931\u8d25\uff0ccode\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u4e0b\u8f7d');</script>";
        }
        if (Funs.isNotBlank(docTitle)) {
            outFileName = docTitle;
        }
        String fileSaveName = saveFilePath;
        if (!saveFilePath.startsWith(this.fileUploadConf.getSavePath())) {
            fileSaveName = this.fileUploadConf.getSavePath() + saveFilePath;
        }
        if (!(file = new File(fileSaveName)).exists()) {
            response.reset();
            response.setContentType("text/html");
            response.setHeader("Content-Type", "text/html;charset=UTF-8");
            return "<script>alert('\u4e0b\u8f7d\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25\u3010\u6587\u4ef6\u4e0d\u5b58\u5728\u3011\uff0c\u8bf7\u91cd\u65b0\u5bfc\u51fa');</script>";
        }
        String ext = FileUtil.extName((String)saveFilePath);
        if (Funs.isBlank(outFileName)) {
            outFileName = "\u5bfc\u51fa-" + Funs.getNowFullTimeNum() + "." + ext;
        }
        Funs.setDownloadHeader(request, response, outFileName);
        byte[] buff = new byte[1024];
        BufferedInputStream bis = null;
        ServletOutputStream os = null;
        try {
            os = response.getOutputStream();
            bis = new BufferedInputStream(new FileInputStream(file));
            int i = bis.read(buff);
            while (i != -1) {
                os.write(buff, 0, buff.length);
                os.flush();
                i = bis.read(buff);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    @ApiOperation(value="\u6587\u4ef6\u5217\u8868")
    @PostMapping(value={"/filelist"})
    @Order(value=5)
    public Resp<NutMap> filelist(@ApiParam(value="fileids \u6587\u4ef6ID") @RequestBody List<String> fileids, HttpServletRequest request, HttpServletResponse response) {
        Cnd cnd = Cnd.where((String)"isdelete", (String)"=", (Object)0);
        SqlExpressionGroup e = Cnd.cri().where().andInStrList("id", fileids);
        cnd.and((SqlExpression)e);
        List list = this.dao.query(FileInfo.class, (Condition)cnd);
        NutMap item = NutMap.NEW();
        item.addv("list", (Object)list);
        return Resp.OK("successful", item);
    }
}

