/*
 * Decompiled with CFR 0.152.
 */
package top.xtcoder.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.ejlchina.searcher.dialect.Dialect;
import com.ejlchina.searcher.dialect.PostgreSqlDialect;
import javax.sql.DataSource;
import org.beetl.core.Function;
import org.beetl.core.GroupTemplate;
import org.beetl.sql.core.ClasspathLoader;
import org.beetl.sql.core.ConnectionSource;
import org.beetl.sql.core.ConnectionSourceHelper;
import org.beetl.sql.core.Interceptor;
import org.beetl.sql.core.NameConversion;
import org.beetl.sql.core.SQLLoader;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.UnderlinedNameConversion;
import org.beetl.sql.core.db.DBStyle;
import org.beetl.sql.core.db.MySqlStyle;
import org.beetl.sql.ext.DebugInterceptor;
import org.noear.wood.DbContext;
import org.nutz.dao.Dao;
import org.nutz.dao.impl.NutDao;
import org.nutz.dao.util.Daos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import top.xtcoder.common.btsql.BlankFun;
import top.xtcoder.common.btsql.Vo2PgsqlFieldFun;
import top.xtcoder.config.NutzdaoConfig;

@Configuration
@PropertySource(value={"classpath:druid.properties"})
public class DruidConfig {
    private Logger logger = LoggerFactory.getLogger(DruidConfig.class);
    @Autowired
    private NutzdaoConfig config;

    @Bean(destroyMethod="close", initMethod="init")
    @ConfigurationProperties(prefix="spring.datasource")
    public DataSource druidDataSource() {
        return new DruidDataSource();
    }

    @Bean
    public Dao dao(DataSource druidDataSource) {
        String[] entityPackages;
        NutDao dao = new NutDao(druidDataSource);
        if (this.config.isAutoCreate() && (entityPackages = this.config.getEntityPackage()) != null && entityPackages.length > 0) {
            for (String ep : entityPackages) {
                System.out.println("\u626b\u63cf\u5b9e\u4f53\u3010" + ep + "\u3011\uff0c\u81ea\u52a8\u5efa\u8868");
                Daos.createTablesInPackage((Dao)dao, (String)ep, (boolean)false);
            }
        }
        return dao;
    }

    @Bean
    public DbContext woodDb(DataSource druidDataSource) {
        DbContext woodDb = new DbContext(druidDataSource);
        return woodDb;
    }

    @Bean
    public Dialect myDialect() {
        return new PostgreSqlDialect();
    }

    @Bean
    public SQLManager sqlManager(DataSource druidDataSource) {
        MySqlStyle mysql = new MySqlStyle();
        ClasspathLoader loader = new ClasspathLoader("/sqls");
        UnderlinedNameConversion nc = new UnderlinedNameConversion();
        ConnectionSource source = ConnectionSourceHelper.getSingle((DataSource)druidDataSource);
        SQLManager sqlManager = new SQLManager((DBStyle)mysql, (SQLLoader)loader, source, (NameConversion)nc, new Interceptor[]{new DebugInterceptor()});
        GroupTemplate gt = sqlManager.getBeetl().getGroupTemplate();
        gt.registerFunction("vo2PgsqlField", (Function)new Vo2PgsqlFieldFun());
        gt.registerFunction("isBlank", (Function)new BlankFun());
        return sqlManager;
    }
}

