/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.websocket.redis;

import java.util.HashMap;
import javax.websocket.Session;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import top.jfunc.websocket.memory.MemWebSocketManager;
import top.jfunc.websocket.redis.action.BroadCastAction;
import top.jfunc.websocket.redis.action.RemoveAction;
import top.jfunc.websocket.redis.action.SendMessageAction;
import top.jfunc.websocket.utils.JsonUtil;
import top.jfunc.websocket.utils.WebSocketUtil;

public class RedisWebSocketManager
extends MemWebSocketManager {
    public static final String CHANNEL = "websocket";
    private static final String COUNT_KEY = "RedisWebSocketManagerCountKey";
    protected StringRedisTemplate stringRedisTemplate;

    public RedisWebSocketManager(StringRedisTemplate stringRedisTemplate) {
        this.stringRedisTemplate = stringRedisTemplate;
    }

    @Override
    public void put(String identifier, Session session) {
        super.put(identifier, session);
        this.countChange(1);
    }

    @Override
    public void remove(String identifier) {
        boolean containsKey = this.localWebSocketMap().containsKey(identifier);
        if (containsKey) {
            super.remove(identifier);
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            map.put("action", RemoveAction.class.getName());
            map.put("identifier", identifier);
            this.stringRedisTemplate.convertAndSend(CHANNEL, (Object)JsonUtil.serializeMap(map));
        }
        this.countChange(-1);
    }

    @Override
    public int size() {
        return this.getCount();
    }

    @Override
    public void sendMessage(String identifier, String message) {
        Session session = this.get(identifier);
        if (null != session) {
            WebSocketUtil.sendMessage(session, message);
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("action", SendMessageAction.class.getName());
        map.put("identifier", identifier);
        map.put("message", message);
        this.stringRedisTemplate.convertAndSend(this.getChannel(), (Object)JsonUtil.serializeMap(map));
    }

    @Override
    public void broadcast(String message) {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put("action", BroadCastAction.class.getName());
        map.put("message", message);
        this.stringRedisTemplate.convertAndSend(this.getChannel(), (Object)JsonUtil.serializeMap(map));
    }

    protected String getChannel() {
        return CHANNEL;
    }

    private void countChange(int delta) {
        ValueOperations value = this.stringRedisTemplate.opsForValue();
        int count = this.getCount((ValueOperations<String, String>)value);
        count = (count += delta) > 0 ? count : 0;
        value.set((Object)COUNT_KEY, (Object)("" + count));
    }

    private int getCount() {
        ValueOperations value = this.stringRedisTemplate.opsForValue();
        return this.getCount((ValueOperations<String, String>)value);
    }

    private int getCount(ValueOperations<String, String> value) {
        String countStr = (String)value.get((Object)COUNT_KEY);
        int count = 0;
        if (null != countStr) {
            count = Integer.parseInt(countStr);
        }
        return count;
    }
}

