/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.websocket.redis;

import java.util.concurrent.CountDownLatch;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.data.redis.listener.adapter.MessageListenerAdapter;
import top.jfunc.websocket.redis.DefaultRedisReceiver;
import top.jfunc.websocket.redis.RedisReceiver;
import top.jfunc.websocket.redis.RedisWebSocketManager;
import top.jfunc.websocket.redis.action.ActionConfig;
import top.jfunc.websocket.utils.SpringContextHolder;

@Configuration
@Import(value={ActionConfig.class})
public class RedisWebSocketConfig {
    @Bean
    public StringRedisTemplate stringRedisTemplate(RedisConnectionFactory redisConnectionFactory) {
        return new StringRedisTemplate(redisConnectionFactory);
    }

    @Bean(value={"webSocketManager"})
    @ConditionalOnMissingBean(name={"webSocketManager"})
    public RedisWebSocketManager webSocketManager(@Autowired StringRedisTemplate stringRedisTemplate) {
        return new RedisWebSocketManager(stringRedisTemplate);
    }

    @Bean
    public CountDownLatch latch() {
        return new CountDownLatch(1);
    }

    @Bean(value={"receiver"})
    public RedisReceiver receiver(@Autowired @Qualifier(value="latch") CountDownLatch latch) {
        return new DefaultRedisReceiver(latch);
    }

    @Bean
    public MessageListenerAdapter listenerAdapter(@Qualifier(value="receiver") RedisReceiver receiver) {
        return new MessageListenerAdapter((Object)receiver, "receiveMessage");
    }

    @Bean(value={"redisMessageListenerContainer"})
    public RedisMessageListenerContainer redisMessageListenerContainer(RedisConnectionFactory connectionFactory, MessageListenerAdapter listenerAdapter) {
        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(connectionFactory);
        container.addMessageListener((MessageListener)listenerAdapter, (Topic)new PatternTopic("websocket"));
        return container;
    }

    @Bean
    @ConditionalOnMissingBean
    public SpringContextHolder springContextHolder() {
        return new SpringContextHolder();
    }
}

