/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.websocket.redis;

import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.jfunc.json.impl.JSONObject;
import top.jfunc.websocket.WebSocketManager;
import top.jfunc.websocket.redis.RedisReceiver;
import top.jfunc.websocket.redis.action.Action;
import top.jfunc.websocket.utils.SpringContextHolder;

public class DefaultRedisReceiver
implements RedisReceiver {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRedisReceiver.class);
    public static final String IDENTIFIER = "identifier";
    public static final String ACTION = "action";
    private CountDownLatch latch;

    public DefaultRedisReceiver(CountDownLatch latch) {
        this.latch = latch;
    }

    @Override
    public void receiveMessage(String message) {
        LOGGER.info(message);
        JSONObject object = new JSONObject(message);
        if (!object.containsKey(ACTION)) {
            return;
        }
        String actionName = object.getString(ACTION);
        Action action = this.getAction(actionName);
        action.doMessage(this.getWebSocketManager(), object);
        this.latch.countDown();
    }

    private Action getAction(String actionName) {
        boolean containsBean = SpringContextHolder.getApplicationContext().containsBean(actionName);
        if (!containsBean) {
            throw new RuntimeException("\u5bb9\u5668\u4e2d\u4e0d\u5b58\u5728\u5904\u7406\u8fd9\u4e2a\u8bf7\u6c42 " + actionName + " \u7684Action\uff0c\u8bf7\u786e\u4fdd\u6b63\u786e\u6ce8\u5165\u4e86");
        }
        return SpringContextHolder.getBean(actionName, Action.class);
    }

    protected WebSocketManager getWebSocketManager() {
        boolean containsBean = SpringContextHolder.getApplicationContext().containsBean("webSocketManager");
        if (!containsBean) {
            throw new RuntimeException("\u5bb9\u5668\u4e2d\u4e0d\u5b58\u5728WebSocketManager\uff0c\u8bf7\u786e\u4fdd\u6b63\u786e\u6ce8\u5165webSocketManger");
        }
        return SpringContextHolder.getBean("webSocketManager", WebSocketManager.class);
    }
}

