/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.websocket.memory;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.Session;
import top.jfunc.websocket.WebSocketManager;
import top.jfunc.websocket.utils.WebSocketUtil;

public class MemWebSocketManager
implements WebSocketManager {
    private final Map<String, Session> connections = new ConcurrentHashMap<String, Session>(100);

    @Override
    public Session get(String identifier) {
        return this.connections.get(identifier);
    }

    @Override
    public void put(String identifier, Session session) {
        this.connections.put(identifier, session);
    }

    @Override
    public void remove(String identifier) {
        this.connections.remove(identifier);
    }

    @Override
    public Map<String, Session> localWebSocketMap() {
        return this.connections;
    }

    @Override
    public void sendMessage(String identifier, String message) {
        Session session = this.get(identifier);
        if (null == session) {
            throw new RuntimeException("identifier \u4e0d\u5b58\u5728");
        }
        WebSocketUtil.sendMessage(session, message);
    }

    @Override
    public void broadcast(String message) {
        this.localWebSocketMap().values().forEach(session -> WebSocketUtil.sendMessage(session, message));
    }

    @Override
    public void onMessage(String identifier, String message) {
    }
}

