/*
 * Decompiled with CFR 0.152.
 */
package top.jfunc.websocket;

import javax.websocket.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.jfunc.common.utils.StrUtil;
import top.jfunc.websocket.WebSocketManager;
import top.jfunc.websocket.utils.SpringContextHolder;
import top.jfunc.websocket.utils.WebSocketUtil;

public class WebSocketEndpoint {
    public static final String IDENTIFIER = "identifier";
    private static final Logger logger = LoggerFactory.getLogger(WebSocketEndpoint.class);

    public void connect(String identifier, Session session) {
        try {
            if (StrUtil.isBlank((CharSequence)identifier)) {
                return;
            }
            WebSocketManager websocketManager = this.getWebSocketManager();
            websocketManager.put(identifier, session);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void disconnect(String identifier) {
        this.getWebSocketManager().remove(identifier);
    }

    public void receiveMessage(String identifier, String message, Session session) {
        WebSocketManager webSocketManager = this.getWebSocketManager();
        if (webSocketManager.isPing(identifier, message)) {
            String pong = webSocketManager.pong(identifier, message);
            WebSocketUtil.sendMessage(session, pong);
            return;
        }
        webSocketManager.onMessage(identifier, message);
    }

    protected WebSocketManager getWebSocketManager() {
        return SpringContextHolder.getBean("webSocketManager", WebSocketManager.class);
    }
}

