/*
 * Decompiled with CFR 0.152.
 */
package tl.lin.data.map;

import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.io.Writable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Object2FloatOpenHashMapWritable<K extends Writable>
extends Object2FloatOpenHashMap<K>
implements Writable {
    private static final long serialVersionUID = 902668143762455L;

    public void readFields(DataInput in) throws IOException {
        this.clear();
        int numEntries = in.readInt();
        if (numEntries == 0) {
            return;
        }
        String keyClassName = in.readUTF();
        try {
            Class<?> keyClass = Class.forName(keyClassName);
            for (int i = 0; i < numEntries; ++i) {
                Writable objK = (Writable)keyClass.newInstance();
                objK.readFields(in);
                float s = in.readFloat();
                this.put(objK, s);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.size());
        if (this.size() == 0) {
            return;
        }
        Object2FloatMap.FastEntrySet entries = this.object2FloatEntrySet();
        Object2FloatMap.Entry first = (Object2FloatMap.Entry)entries.iterator().next();
        Writable objK = (Writable)first.getKey();
        out.writeUTF(objK.getClass().getCanonicalName());
        for (Object2FloatMap.Entry e : this.object2FloatEntrySet()) {
            ((Writable)e.getKey()).write(out);
            out.writeFloat(((Float)e.getValue()).floatValue());
        }
    }

    public byte[] serialize() throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        DataOutputStream dataOut = new DataOutputStream(bytesOut);
        this.write(dataOut);
        return bytesOut.toByteArray();
    }

    public static <K extends Writable> Object2FloatOpenHashMapWritable<K> create(DataInput in) throws IOException {
        Object2FloatOpenHashMapWritable<K> m = new Object2FloatOpenHashMapWritable<K>();
        m.readFields(in);
        return m;
    }

    public static <K extends Writable> Object2FloatOpenHashMapWritable<K> create(byte[] bytes) throws IOException {
        return Object2FloatOpenHashMapWritable.create(new DataInputStream(new ByteArrayInputStream(bytes)));
    }

    public void plus(Object2FloatOpenHashMapWritable<K> m) {
        for (Object2FloatMap.Entry e : m.object2FloatEntrySet()) {
            Writable key = (Writable)e.getKey();
            if (this.containsKey(key)) {
                this.put(key, this.get(key).floatValue() + ((Float)e.getValue()).floatValue());
                continue;
            }
            this.put(key, (Float)e.getValue());
        }
    }

    public int dot(Object2FloatOpenHashMapWritable<K> m) {
        int s = 0;
        for (Object2FloatMap.Entry e : m.object2FloatEntrySet()) {
            Writable key = (Writable)e.getKey();
            if (!this.containsKey(key)) continue;
            s = (int)((float)s + this.get(key).floatValue() * ((Float)e.getValue()).floatValue());
        }
        return s;
    }

    public void increment(K key) {
        if (this.containsKey(key)) {
            this.put(key, this.get(key).floatValue() + 1.0f);
        } else {
            this.put(key, 1.0f);
        }
    }
}

