/*
 * Decompiled with CFR 0.152.
 */
package tech.ytsaurus.skiff;

import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import tech.ytsaurus.yson.BufferReference;
import tech.ytsaurus.yson.BufferedStreamZeroCopyInput;
import tech.ytsaurus.yson.StreamReader;
import tech.ytsaurus.yson.ZeroCopyInput;

public class SkiffParser {
    private final StreamReader reader;
    private final BufferReference bufferReference = new BufferReference();

    public SkiffParser(InputStream input) {
        this.reader = new StreamReader((ZeroCopyInput)new BufferedStreamZeroCopyInput(input, 65536));
    }

    public byte parseInt8() {
        return this.reader.readByte();
    }

    public short parseInt16() {
        this.getDataInLittleEndian(2);
        byte[] buffer = this.bufferReference.getBuffer();
        int bufferOffset = this.bufferReference.getOffset();
        return (short)(buffer[bufferOffset] & 0xFF | (buffer[bufferOffset + 1] & 0xFF) << 8);
    }

    public int parseInt32() {
        this.getDataInLittleEndian(4);
        byte[] buffer = this.bufferReference.getBuffer();
        int bufferOffset = this.bufferReference.getOffset();
        return buffer[bufferOffset] & 0xFF | (buffer[bufferOffset + 1] & 0xFF) << 8 | (buffer[bufferOffset + 2] & 0xFF) << 16 | (buffer[bufferOffset + 3] & 0xFF) << 24;
    }

    public long parseInt64() {
        this.getDataInLittleEndian(8);
        long result = 0L;
        for (int i = 7; i >= 0; --i) {
            result <<= 8;
            result |= (long)(this.bufferReference.getBuffer()[this.bufferReference.getOffset() + i] & 0xFF);
        }
        return result;
    }

    public BigInteger parseInt128() {
        byte[] data = this.getDataInBigEndian(16);
        int sign = data[0] < 0 ? -1 : 1;
        return new BigInteger(sign, data);
    }

    public long parseUint8() {
        return this.reader.readByte() & 0xFF;
    }

    public long parseUint16() {
        this.getDataInLittleEndian(2);
        byte[] buffer = this.bufferReference.getBuffer();
        int bufferOffset = this.bufferReference.getOffset();
        return buffer[bufferOffset] & 0xFF | (buffer[bufferOffset + 1] & 0xFF) << 8;
    }

    public long parseUint32() {
        return new BigInteger(1, this.getDataInBigEndian(4)).longValue();
    }

    public long parseUint64() {
        return new BigInteger(1, this.getDataInBigEndian(8)).longValue();
    }

    public BigInteger parseUint128() {
        return new BigInteger(1, this.getDataInBigEndian(16));
    }

    public double parseDouble() {
        return ByteBuffer.wrap(this.getDataInBigEndian(8)).order(ByteOrder.BIG_ENDIAN).getDouble();
    }

    public boolean parseBoolean() {
        return this.reader.readByte() != 0;
    }

    public BufferReference parseString32() {
        int length = this.parseInt32();
        if (length < 0) {
            throw new IllegalArgumentException("Max length of string in Java = Integer.MAX_VALUE");
        }
        this.getDataInLittleEndian(length);
        return this.bufferReference;
    }

    public BufferReference parseYson32() {
        return this.parseString32();
    }

    public short parseVariant8Tag() {
        return (short)(this.reader.readByte() & 0xFF);
    }

    public int parseVariant16Tag() {
        return (int)this.parseUint16();
    }

    public byte[] getDataInBigEndian(int length) {
        this.getDataInLittleEndian(length);
        byte[] data = new byte[length];
        for (int i = length - 1; i >= 0; --i) {
            data[length - i - 1] = this.bufferReference.getBuffer()[this.bufferReference.getOffset() + i];
        }
        return data;
    }

    public boolean hasMoreData() {
        boolean isNotEOF;
        boolean bl = isNotEOF = this.reader.tryReadByte() != Integer.MAX_VALUE;
        if (isNotEOF) {
            this.reader.unreadByte();
        }
        return isNotEOF;
    }

    private void getDataInLittleEndian(int length) {
        this.reader.readBytes(length, this.bufferReference);
    }
}

