/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.db.list.token;

import java.beans.ConstructorProperties;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;
import tech.ydb.yoj.repository.db.list.BadListingException;
import tech.ydb.yoj.repository.db.list.GenericListResult;
import tech.ydb.yoj.repository.db.list.ListRequest;
import tech.ydb.yoj.repository.db.list.token.PageToken;

public final class FallbackPageToken
implements PageToken {
    @NonNull
    private final PageToken primary;
    @NonNull
    private final PageToken fallback;
    private final boolean encodeAsPrimary;

    @Override
    @Nullable
    public <T, R> String encode(@NonNull GenericListResult<T, R> result) {
        if (result == null) {
            throw new NullPointerException("result is marked non-null but is null");
        }
        return (this.encodeAsPrimary ? this.primary : this.fallback).encode(result);
    }

    @Override
    @NonNull
    public <T> ListRequest.Builder<T> decode(@NonNull ListRequest.Builder<T> bldr, @NonNull String token) throws BadListingException.InvalidPageToken {
        if (bldr == null) {
            throw new NullPointerException("bldr is marked non-null but is null");
        }
        if (token == null) {
            throw new NullPointerException("token is marked non-null but is null");
        }
        try {
            return this.primary.decode(bldr, token);
        }
        catch (BadListingException.InvalidPageToken primaryFailed) {
            try {
                return this.fallback.decode(bldr, token);
            }
            catch (BadListingException.InvalidPageToken fallbackFailed) {
                primaryFailed.addSuppressed(fallbackFailed);
                throw primaryFailed;
            }
        }
    }

    @Generated
    public static FallbackPageTokenBuilder builder() {
        return new FallbackPageTokenBuilder();
    }

    @NonNull
    @Generated
    public PageToken getPrimary() {
        return this.primary;
    }

    @NonNull
    @Generated
    public PageToken getFallback() {
        return this.fallback;
    }

    @Generated
    public boolean isEncodeAsPrimary() {
        return this.encodeAsPrimary;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FallbackPageToken)) {
            return false;
        }
        FallbackPageToken other = (FallbackPageToken)o;
        if (this.isEncodeAsPrimary() != other.isEncodeAsPrimary()) {
            return false;
        }
        PageToken this$primary = this.getPrimary();
        PageToken other$primary = other.getPrimary();
        if (this$primary == null ? other$primary != null : !this$primary.equals(other$primary)) {
            return false;
        }
        PageToken this$fallback = this.getFallback();
        PageToken other$fallback = other.getFallback();
        return !(this$fallback == null ? other$fallback != null : !this$fallback.equals(other$fallback));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEncodeAsPrimary() ? 79 : 97);
        PageToken $primary = this.getPrimary();
        result = result * 59 + ($primary == null ? 43 : $primary.hashCode());
        PageToken $fallback = this.getFallback();
        result = result * 59 + ($fallback == null ? 43 : $fallback.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FallbackPageToken(primary=" + this.getPrimary() + ", fallback=" + this.getFallback() + ", encodeAsPrimary=" + this.isEncodeAsPrimary() + ")";
    }

    @ConstructorProperties(value={"primary", "fallback", "encodeAsPrimary"})
    @Generated
    private FallbackPageToken(@NonNull PageToken primary, @NonNull PageToken fallback, boolean encodeAsPrimary) {
        if (primary == null) {
            throw new NullPointerException("primary is marked non-null but is null");
        }
        if (fallback == null) {
            throw new NullPointerException("fallback is marked non-null but is null");
        }
        this.primary = primary;
        this.fallback = fallback;
        this.encodeAsPrimary = encodeAsPrimary;
    }

    @Generated
    public static class FallbackPageTokenBuilder {
        @Generated
        private PageToken primary;
        @Generated
        private PageToken fallback;
        @Generated
        private boolean encodeAsPrimary;

        @Generated
        FallbackPageTokenBuilder() {
        }

        @Generated
        public FallbackPageTokenBuilder primary(@NonNull PageToken primary) {
            if (primary == null) {
                throw new NullPointerException("primary is marked non-null but is null");
            }
            this.primary = primary;
            return this;
        }

        @Generated
        public FallbackPageTokenBuilder fallback(@NonNull PageToken fallback) {
            if (fallback == null) {
                throw new NullPointerException("fallback is marked non-null but is null");
            }
            this.fallback = fallback;
            return this;
        }

        @Generated
        public FallbackPageTokenBuilder encodeAsPrimary(boolean encodeAsPrimary) {
            this.encodeAsPrimary = encodeAsPrimary;
            return this;
        }

        @Generated
        public FallbackPageToken build() {
            return new FallbackPageToken(this.primary, this.fallback, this.encodeAsPrimary);
        }

        @Generated
        public String toString() {
            return "FallbackPageToken.FallbackPageTokenBuilder(primary=" + this.primary + ", fallback=" + this.fallback + ", encodeAsPrimary=" + this.encodeAsPrimary + ")";
        }
    }
}

