/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.db.exception;

import java.util.concurrent.TimeUnit;
import tech.ydb.yoj.repository.db.exception.QueryInterruptedException;
import tech.ydb.yoj.repository.db.exception.RepositoryException;
import tech.ydb.yoj.repository.db.exception.UnavailableException;
import tech.ydb.yoj.util.retry.RetryPolicy;

public abstract class RetryableException
extends RepositoryException {
    private final RetryPolicy retryPolicy;

    protected RetryableException(String message, RetryPolicy retryPolicy, Throwable cause) {
        super(message, cause);
        this.retryPolicy = retryPolicy;
    }

    protected RetryableException(String message, RetryPolicy retryPolicy) {
        super(message);
        this.retryPolicy = retryPolicy;
    }

    protected RetryableException(String message, Throwable cause) {
        this(message, RetryPolicy.retryImmediately(), cause);
    }

    protected RetryableException(String message) {
        this(message, RetryPolicy.retryImmediately());
    }

    public void sleep(int attempt) {
        try {
            TimeUnit.MILLISECONDS.sleep(this.retryPolicy.calcDuration(attempt).toMillis());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new QueryInterruptedException("DB query interrupted", e);
        }
    }

    public RepositoryException rethrow() {
        return UnavailableException.afterRetries("Retries failed", this);
    }
}

