/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.db.cache;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ydb.yoj.repository.db.exception.QueryCancelledException;
import tech.ydb.yoj.repository.db.exception.QueryInterruptedException;
import tech.ydb.yoj.util.lang.Interrupts;

public abstract class DbValueUpdater<V> {
    protected static final Logger log = LoggerFactory.getLogger(DbValueUpdater.class);
    protected static final ThreadFactoryCreator DEFAULT_THREAD_FACTORY_CREATOR = name -> new ThreadFactoryBuilder().setNameFormat(name + "-update-thread-%d").setDaemon(true).build();
    protected static final Duration DEFAULT_CACHE_TIMEOUT = Duration.ofSeconds(30L);
    protected static final Duration DEFAULT_SHUTDOWN_TIMEOUT = Duration.ofSeconds(1L);
    protected static final Duration DEFAULT_MAX_LAG = Duration.ofMinutes(5L);
    protected static final Duration DEFAULT_MAX_READ_DURATION = Duration.ofSeconds(15L);
    protected final Duration pollInterval;
    protected final Duration shutdownTimeout;
    protected final Duration maxAge;
    protected final Duration maxReadDuration;
    protected final ThreadFactory threadFactory;
    protected final String name;
    private ScheduledExecutorService executor;
    private volatile CachedValue<V> cachedValue;

    public DbValueUpdater() {
        this(DEFAULT_THREAD_FACTORY_CREATOR);
    }

    public DbValueUpdater(@NonNull ThreadFactory threadFactory) {
        this((String __) -> threadFactory);
        if (threadFactory == null) {
            throw new NullPointerException("threadFactory is marked non-null but is null");
        }
    }

    public DbValueUpdater(@NonNull Duration pollInterval, @NonNull Duration shutdownTimeout, @NonNull Duration maxAge, @NonNull Duration maxReadDuration) {
        this(pollInterval, shutdownTimeout, maxAge, maxReadDuration, DEFAULT_THREAD_FACTORY_CREATOR);
        if (pollInterval == null) {
            throw new NullPointerException("pollInterval is marked non-null but is null");
        }
        if (shutdownTimeout == null) {
            throw new NullPointerException("shutdownTimeout is marked non-null but is null");
        }
        if (maxAge == null) {
            throw new NullPointerException("maxAge is marked non-null but is null");
        }
        if (maxReadDuration == null) {
            throw new NullPointerException("maxReadDuration is marked non-null but is null");
        }
    }

    public DbValueUpdater(@NonNull String name, @NonNull Duration pollInterval, @NonNull Duration shutdownTimeout, @NonNull Duration maxAge, @NonNull Duration maxReadDuration) {
        this(name, pollInterval, shutdownTimeout, maxAge, maxReadDuration, DEFAULT_THREAD_FACTORY_CREATOR);
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (pollInterval == null) {
            throw new NullPointerException("pollInterval is marked non-null but is null");
        }
        if (shutdownTimeout == null) {
            throw new NullPointerException("shutdownTimeout is marked non-null but is null");
        }
        if (maxAge == null) {
            throw new NullPointerException("maxAge is marked non-null but is null");
        }
        if (maxReadDuration == null) {
            throw new NullPointerException("maxReadDuration is marked non-null but is null");
        }
    }

    public DbValueUpdater(@NonNull ThreadFactoryCreator threadFactorySupplier) {
        this(DEFAULT_CACHE_TIMEOUT, DEFAULT_SHUTDOWN_TIMEOUT, DEFAULT_MAX_LAG, DEFAULT_MAX_READ_DURATION, threadFactorySupplier);
        if (threadFactorySupplier == null) {
            throw new NullPointerException("threadFactorySupplier is marked non-null but is null");
        }
    }

    public DbValueUpdater(@NonNull Duration pollInterval, @NonNull Duration shutdownTimeout, @NonNull Duration maxAge, @NonNull Duration maxReadDuration, @NonNull ThreadFactoryCreator threadFactorySupplier) {
        this(pollInterval, shutdownTimeout, maxAge, maxReadDuration, (DbValueUpdater<V> vu) -> new TypeToken<V>(vu.getClass()){}.getRawType().getSimpleName(), threadFactorySupplier);
        if (pollInterval == null) {
            throw new NullPointerException("pollInterval is marked non-null but is null");
        }
        if (shutdownTimeout == null) {
            throw new NullPointerException("shutdownTimeout is marked non-null but is null");
        }
        if (maxAge == null) {
            throw new NullPointerException("maxAge is marked non-null but is null");
        }
        if (maxReadDuration == null) {
            throw new NullPointerException("maxReadDuration is marked non-null but is null");
        }
        if (threadFactorySupplier == null) {
            throw new NullPointerException("threadFactorySupplier is marked non-null but is null");
        }
    }

    public DbValueUpdater(@NonNull String name, @NonNull Duration pollInterval, @NonNull Duration shutdownTimeout, @NonNull Duration maxAge, @NonNull Duration maxReadDuration, @NonNull ThreadFactoryCreator threadFactorySupplier) {
        this(pollInterval, shutdownTimeout, maxAge, maxReadDuration, (DbValueUpdater<V> __) -> name, threadFactorySupplier);
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (pollInterval == null) {
            throw new NullPointerException("pollInterval is marked non-null but is null");
        }
        if (shutdownTimeout == null) {
            throw new NullPointerException("shutdownTimeout is marked non-null but is null");
        }
        if (maxAge == null) {
            throw new NullPointerException("maxAge is marked non-null but is null");
        }
        if (maxReadDuration == null) {
            throw new NullPointerException("maxReadDuration is marked non-null but is null");
        }
        if (threadFactorySupplier == null) {
            throw new NullPointerException("threadFactorySupplier is marked non-null but is null");
        }
    }

    public DbValueUpdater(@NonNull Duration pollInterval, @NonNull Duration shutdownTimeout, @NonNull Duration maxAge, @NonNull Duration maxReadDuration, @NonNull Function<DbValueUpdater<V>, String> nameSupplier, @NonNull ThreadFactoryCreator threadFactoryCreator) {
        if (pollInterval == null) {
            throw new NullPointerException("pollInterval is marked non-null but is null");
        }
        if (shutdownTimeout == null) {
            throw new NullPointerException("shutdownTimeout is marked non-null but is null");
        }
        if (maxAge == null) {
            throw new NullPointerException("maxAge is marked non-null but is null");
        }
        if (maxReadDuration == null) {
            throw new NullPointerException("maxReadDuration is marked non-null but is null");
        }
        if (nameSupplier == null) {
            throw new NullPointerException("nameSupplier is marked non-null but is null");
        }
        if (threadFactoryCreator == null) {
            throw new NullPointerException("threadFactoryCreator is marked non-null but is null");
        }
        Preconditions.checkArgument((pollInterval.compareTo(Duration.ZERO) >= 0 ? 1 : 0) != 0, (Object)"poll interval must be >= 0");
        Preconditions.checkArgument((shutdownTimeout.compareTo(Duration.ZERO) >= 0 ? 1 : 0) != 0, (Object)"shutdown timeout must be >= 0");
        Preconditions.checkArgument((maxAge.compareTo(Duration.ZERO) > 0 ? 1 : 0) != 0, (Object)"max age must be > 0");
        Preconditions.checkArgument((maxReadDuration.compareTo(Duration.ZERO) > 0 ? 1 : 0) != 0, (Object)"max read duration must be > 0");
        this.pollInterval = pollInterval;
        this.shutdownTimeout = shutdownTimeout;
        this.maxAge = maxAge;
        this.maxReadDuration = maxReadDuration;
        this.name = nameSupplier.apply(this);
        this.threadFactory = threadFactoryCreator.createThreadFactory(this.name);
    }

    @NonNull
    protected abstract V doReadValue();

    public synchronized void start() {
        if (this.executor != null) {
            return;
        }
        this.executor = Executors.newSingleThreadScheduledExecutor(this.threadFactory);
        try {
            Future<Object> initialUpdate = this.executor.submit(this::update);
            Preconditions.checkState((null != initialUpdate.get(this.maxReadDuration.toMillis(), TimeUnit.MILLISECONDS) ? 1 : 0) != 0, (Object)("Initial update of ValueUpdater[" + this.name + "] must complete successfully"));
            long pollIntervalMs = this.pollInterval.toMillis();
            this.executor.scheduleWithFixedDelay(this::update, pollIntervalMs, pollIntervalMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | CancellationException | RejectedExecutionException e) {
            this.rollback((arg_0, arg_1, arg_2) -> ((Logger)log).warn(arg_0, arg_1, arg_2), "ValueUpdater[" + this.name + "] start was cancelled", e);
        }
        catch (TimeoutException e) {
            this.rollback((arg_0, arg_1, arg_2) -> ((Logger)log).error(arg_0, arg_1, arg_2), "Initial update for ValueUpdater[" + this.name + "] did not complete in " + this.maxReadDuration, e);
        }
        catch (Exception e) {
            Throwable rootCause = e instanceof ExecutionException ? e.getCause() : e;
            this.rollback((arg_0, arg_1, arg_2) -> ((Logger)log).error(arg_0, arg_1, arg_2), "Could not start ValueUpdater[" + this.name + "]", rootCause);
        }
    }

    private void rollback(TriConsumer<String, String, Throwable> logMethod, String message, Throwable cause) {
        logMethod.accept("{}; shutting down", message, cause);
        IllegalStateException ex = new IllegalStateException(message, cause);
        try {
            this.shutdown();
        }
        catch (Exception shutdownEx) {
            ex.addSuppressed(shutdownEx);
        }
        throw ex;
    }

    public synchronized void shutdown() {
        if (this.executor == null) {
            return;
        }
        this.executor.shutdownNow();
        Preconditions.checkState((boolean)Interrupts.awaitTermination((ExecutorService)this.executor, (Duration)this.shutdownTimeout), (String)"Could not stop ValueUpdater[%s] in %s", (Object)this.name, (Object)this.shutdownTimeout);
        this.executor = null;
        this.cachedValue = null;
    }

    public synchronized boolean isUpdaterActive() {
        return this.cachedValue != null;
    }

    @NonNull
    public V readCached() {
        CachedValue<V> cv = this.cachedValue;
        Preconditions.checkState((cv != null ? 1 : 0) != 0, (Object)"Value updater is not active");
        return cv.value;
    }

    @VisibleForTesting
    public void forceUpdate() {
        this.cachedValue = new CachedValue<V>(this.doReadValue(), Instant.now());
    }

    public String toString() {
        return "ValueUpdater[" + this.name + "]=" + this.cachedValue;
    }

    private V update() {
        V newValue = this.tryReadValue();
        Instant now = Instant.now();
        CachedValue<V> prevCached = this.cachedValue;
        Instant lastGoodPoll = prevCached == null ? null : prevCached.lastGoodPoll;
        Duration age = lastGoodPoll == null ? Duration.ZERO : Duration.between(lastGoodPoll, now);
        DbValueUpdater.logErrorIf(age.compareTo(this.maxAge) > 0, () -> String.format("[%s] Cached value is too old: %s > %s", this.name, age, this.maxAge));
        DbValueUpdater.logErrorIf(newValue == null && lastGoodPoll == null, () -> String.format("[%s] No read value available AND no cached value present", this.name));
        if (newValue != null) {
            this.cachedValue = new CachedValue<V>(newValue, now);
        }
        return newValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Nullable
    protected V tryReadValue() {
        V v;
        Instant started = Instant.now();
        try {
            v = this.doReadValue();
        }
        catch (QueryCancelledException | QueryInterruptedException e) {
            log.info("[{}] Cancelled/interrupted while trying to read value", (Object)this.name, (Object)e);
            V v2 = null;
            Instant finished = Instant.now();
            Duration readDuration = Duration.between(started, finished);
            if (readDuration.compareTo(this.maxReadDuration) > 0) {
                log.error("[{}] readValue() took too long: {} > {}", new Object[]{this.name, readDuration, this.maxReadDuration});
            }
            return v2;
        }
        catch (Exception e2) {
            log.warn("[{}] Could not read value: {}", new Object[]{this.name, e2.getClass().getSimpleName(), e2});
            V v3 = null;
            {
                catch (Throwable throwable) {
                    Instant finished = Instant.now();
                    Duration readDuration = Duration.between(started, finished);
                    if (readDuration.compareTo(this.maxReadDuration) > 0) {
                        log.error("[{}] readValue() took too long: {} > {}", new Object[]{this.name, readDuration, this.maxReadDuration});
                    }
                    throw throwable;
                }
            }
            Instant finished = Instant.now();
            Duration readDuration = Duration.between(started, finished);
            if (readDuration.compareTo(this.maxReadDuration) > 0) {
                log.error("[{}] readValue() took too long: {} > {}", new Object[]{this.name, readDuration, this.maxReadDuration});
            }
            return v3;
        }
        Instant finished = Instant.now();
        Duration readDuration = Duration.between(started, finished);
        if (readDuration.compareTo(this.maxReadDuration) > 0) {
            log.error("[{}] readValue() took too long: {} > {}", new Object[]{this.name, readDuration, this.maxReadDuration});
        }
        return v;
    }

    private static void logErrorIf(boolean errorCondition, Supplier<String> message) {
        if (errorCondition) {
            log.error(message.get());
        }
    }

    @FunctionalInterface
    public static interface ThreadFactoryCreator {
        public ThreadFactory createThreadFactory(String var1);
    }

    @FunctionalInterface
    private static interface TriConsumer<A, B, C> {
        public void accept(A var1, B var2, C var3);
    }

    private static final class CachedValue<V> {
        @NonNull
        private final V value;
        @NonNull
        private final Instant lastGoodPoll;

        @NonNull
        public String toString() {
            return this.value.toString();
        }

        @ConstructorProperties(value={"value", "lastGoodPoll"})
        @Generated
        public CachedValue(@NonNull V value, @NonNull Instant lastGoodPoll) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            if (lastGoodPoll == null) {
                throw new NullPointerException("lastGoodPoll is marked non-null but is null");
            }
            this.value = value;
            this.lastGoodPoll = lastGoodPoll;
        }

        @NonNull
        @Generated
        public V getValue() {
            return this.value;
        }

        @NonNull
        @Generated
        public Instant getLastGoodPoll() {
            return this.lastGoodPoll;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CachedValue)) {
                return false;
            }
            CachedValue other = (CachedValue)o;
            V this$value = this.getValue();
            V other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            Instant this$lastGoodPoll = this.getLastGoodPoll();
            Instant other$lastGoodPoll = other.getLastGoodPoll();
            return !(this$lastGoodPoll == null ? other$lastGoodPoll != null : !((Object)this$lastGoodPoll).equals(other$lastGoodPoll));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            V $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            Instant $lastGoodPoll = this.getLastGoodPoll();
            result = result * 59 + ($lastGoodPoll == null ? 43 : ((Object)$lastGoodPoll).hashCode());
            return result;
        }
    }
}

