/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.db;

import java.beans.ConstructorProperties;
import java.time.Duration;
import lombok.Generated;
import lombok.NonNull;
import tech.ydb.yoj.repository.db.IsolationLevel;
import tech.ydb.yoj.repository.db.cache.TransactionLog;

public final class TxOptions {
    @NonNull
    private final IsolationLevel isolationLevel;
    private final boolean firstLevelCache;
    private final TransactionLog.Level logLevel;
    private final boolean logStatementOnSuccess;
    private final ScanOptions scanOptions;
    private final TimeoutOptions timeoutOptions;
    private final boolean dryRun;
    private final boolean immediateWrites;

    public static TxOptions create(@NonNull IsolationLevel isolationLevel) {
        if (isolationLevel == null) {
            throw new NullPointerException("isolationLevel is marked non-null but is null");
        }
        return TxOptions.builder().isolationLevel(isolationLevel).firstLevelCache(true).logLevel(TransactionLog.Level.DEBUG).logStatementOnSuccess(true).build();
    }

    public boolean isReadOnly() {
        return !this.isReadWrite();
    }

    public boolean isReadWrite() {
        return this.isolationLevel.isReadWrite();
    }

    public boolean isImmutable() {
        return !this.isMutable();
    }

    public boolean isMutable() {
        return this.isReadWrite() && !this.isScan();
    }

    public boolean isScan() {
        return this.scanOptions != null;
    }

    public TimeoutOptions minTimeoutOptions(Duration timeoutFromExternalCtx) {
        if (timeoutFromExternalCtx == null && this.timeoutOptions == null) {
            return TimeoutOptions.DEFAULT;
        }
        if (this.timeoutOptions == null) {
            return new TimeoutOptions(timeoutFromExternalCtx);
        }
        if (timeoutFromExternalCtx == null) {
            return this.timeoutOptions;
        }
        if (this.timeoutOptions.getTimeout().compareTo(timeoutFromExternalCtx) < 0) {
            return this.timeoutOptions;
        }
        return new TimeoutOptions(timeoutFromExternalCtx);
    }

    @ConstructorProperties(value={"isolationLevel", "firstLevelCache", "logLevel", "logStatementOnSuccess", "scanOptions", "timeoutOptions", "dryRun", "immediateWrites"})
    @Generated
    TxOptions(@NonNull IsolationLevel isolationLevel, boolean firstLevelCache, TransactionLog.Level logLevel, boolean logStatementOnSuccess, ScanOptions scanOptions, TimeoutOptions timeoutOptions, boolean dryRun, boolean immediateWrites) {
        if (isolationLevel == null) {
            throw new NullPointerException("isolationLevel is marked non-null but is null");
        }
        this.isolationLevel = isolationLevel;
        this.firstLevelCache = firstLevelCache;
        this.logLevel = logLevel;
        this.logStatementOnSuccess = logStatementOnSuccess;
        this.scanOptions = scanOptions;
        this.timeoutOptions = timeoutOptions;
        this.dryRun = dryRun;
        this.immediateWrites = immediateWrites;
    }

    @Generated
    private static TxOptionsBuilder builder() {
        return new TxOptionsBuilder();
    }

    @NonNull
    @Generated
    public IsolationLevel getIsolationLevel() {
        return this.isolationLevel;
    }

    @Generated
    public boolean isFirstLevelCache() {
        return this.firstLevelCache;
    }

    @Generated
    public TransactionLog.Level getLogLevel() {
        return this.logLevel;
    }

    @Generated
    public boolean isLogStatementOnSuccess() {
        return this.logStatementOnSuccess;
    }

    @Generated
    public ScanOptions getScanOptions() {
        return this.scanOptions;
    }

    @Generated
    public TimeoutOptions getTimeoutOptions() {
        return this.timeoutOptions;
    }

    @Generated
    public boolean isDryRun() {
        return this.dryRun;
    }

    @Generated
    public boolean isImmediateWrites() {
        return this.immediateWrites;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TxOptions)) {
            return false;
        }
        TxOptions other = (TxOptions)o;
        if (this.isFirstLevelCache() != other.isFirstLevelCache()) {
            return false;
        }
        if (this.isLogStatementOnSuccess() != other.isLogStatementOnSuccess()) {
            return false;
        }
        if (this.isDryRun() != other.isDryRun()) {
            return false;
        }
        if (this.isImmediateWrites() != other.isImmediateWrites()) {
            return false;
        }
        IsolationLevel this$isolationLevel = this.getIsolationLevel();
        IsolationLevel other$isolationLevel = other.getIsolationLevel();
        if (this$isolationLevel == null ? other$isolationLevel != null : !((Object)((Object)this$isolationLevel)).equals((Object)other$isolationLevel)) {
            return false;
        }
        TransactionLog.Level this$logLevel = this.getLogLevel();
        TransactionLog.Level other$logLevel = other.getLogLevel();
        if (this$logLevel == null ? other$logLevel != null : !((Object)((Object)this$logLevel)).equals((Object)other$logLevel)) {
            return false;
        }
        ScanOptions this$scanOptions = this.getScanOptions();
        ScanOptions other$scanOptions = other.getScanOptions();
        if (this$scanOptions == null ? other$scanOptions != null : !((Object)this$scanOptions).equals(other$scanOptions)) {
            return false;
        }
        TimeoutOptions this$timeoutOptions = this.getTimeoutOptions();
        TimeoutOptions other$timeoutOptions = other.getTimeoutOptions();
        return !(this$timeoutOptions == null ? other$timeoutOptions != null : !((Object)this$timeoutOptions).equals(other$timeoutOptions));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isFirstLevelCache() ? 79 : 97);
        result = result * 59 + (this.isLogStatementOnSuccess() ? 79 : 97);
        result = result * 59 + (this.isDryRun() ? 79 : 97);
        result = result * 59 + (this.isImmediateWrites() ? 79 : 97);
        IsolationLevel $isolationLevel = this.getIsolationLevel();
        result = result * 59 + ($isolationLevel == null ? 43 : ((Object)((Object)$isolationLevel)).hashCode());
        TransactionLog.Level $logLevel = this.getLogLevel();
        result = result * 59 + ($logLevel == null ? 43 : ((Object)((Object)$logLevel)).hashCode());
        ScanOptions $scanOptions = this.getScanOptions();
        result = result * 59 + ($scanOptions == null ? 43 : ((Object)$scanOptions).hashCode());
        TimeoutOptions $timeoutOptions = this.getTimeoutOptions();
        result = result * 59 + ($timeoutOptions == null ? 43 : ((Object)$timeoutOptions).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TxOptions(isolationLevel=" + this.getIsolationLevel() + ", firstLevelCache=" + this.isFirstLevelCache() + ", logLevel=" + this.getLogLevel() + ", logStatementOnSuccess=" + this.isLogStatementOnSuccess() + ", scanOptions=" + this.getScanOptions() + ", timeoutOptions=" + this.getTimeoutOptions() + ", dryRun=" + this.isDryRun() + ", immediateWrites=" + this.isImmediateWrites() + ")";
    }

    @Generated
    public TxOptions withIsolationLevel(@NonNull IsolationLevel isolationLevel) {
        if (isolationLevel == null) {
            throw new NullPointerException("isolationLevel is marked non-null but is null");
        }
        return this.isolationLevel == isolationLevel ? this : new TxOptions(isolationLevel, this.firstLevelCache, this.logLevel, this.logStatementOnSuccess, this.scanOptions, this.timeoutOptions, this.dryRun, this.immediateWrites);
    }

    @Generated
    public TxOptions withFirstLevelCache(boolean firstLevelCache) {
        return this.firstLevelCache == firstLevelCache ? this : new TxOptions(this.isolationLevel, firstLevelCache, this.logLevel, this.logStatementOnSuccess, this.scanOptions, this.timeoutOptions, this.dryRun, this.immediateWrites);
    }

    @Generated
    public TxOptions withLogLevel(TransactionLog.Level logLevel) {
        return this.logLevel == logLevel ? this : new TxOptions(this.isolationLevel, this.firstLevelCache, logLevel, this.logStatementOnSuccess, this.scanOptions, this.timeoutOptions, this.dryRun, this.immediateWrites);
    }

    @Generated
    public TxOptions withLogStatementOnSuccess(boolean logStatementOnSuccess) {
        return this.logStatementOnSuccess == logStatementOnSuccess ? this : new TxOptions(this.isolationLevel, this.firstLevelCache, this.logLevel, logStatementOnSuccess, this.scanOptions, this.timeoutOptions, this.dryRun, this.immediateWrites);
    }

    @Generated
    public TxOptions withScanOptions(ScanOptions scanOptions) {
        return this.scanOptions == scanOptions ? this : new TxOptions(this.isolationLevel, this.firstLevelCache, this.logLevel, this.logStatementOnSuccess, scanOptions, this.timeoutOptions, this.dryRun, this.immediateWrites);
    }

    @Generated
    public TxOptions withTimeoutOptions(TimeoutOptions timeoutOptions) {
        return this.timeoutOptions == timeoutOptions ? this : new TxOptions(this.isolationLevel, this.firstLevelCache, this.logLevel, this.logStatementOnSuccess, this.scanOptions, timeoutOptions, this.dryRun, this.immediateWrites);
    }

    @Generated
    public TxOptions withDryRun(boolean dryRun) {
        return this.dryRun == dryRun ? this : new TxOptions(this.isolationLevel, this.firstLevelCache, this.logLevel, this.logStatementOnSuccess, this.scanOptions, this.timeoutOptions, dryRun, this.immediateWrites);
    }

    @Generated
    public TxOptions withImmediateWrites(boolean immediateWrites) {
        return this.immediateWrites == immediateWrites ? this : new TxOptions(this.isolationLevel, this.firstLevelCache, this.logLevel, this.logStatementOnSuccess, this.scanOptions, this.timeoutOptions, this.dryRun, immediateWrites);
    }

    @Generated
    private static class TxOptionsBuilder {
        @Generated
        private IsolationLevel isolationLevel;
        @Generated
        private boolean firstLevelCache;
        @Generated
        private TransactionLog.Level logLevel;
        @Generated
        private boolean logStatementOnSuccess;
        @Generated
        private ScanOptions scanOptions;
        @Generated
        private TimeoutOptions timeoutOptions;
        @Generated
        private boolean dryRun;
        @Generated
        private boolean immediateWrites;

        @Generated
        TxOptionsBuilder() {
        }

        @Generated
        private TxOptionsBuilder isolationLevel(@NonNull IsolationLevel isolationLevel) {
            if (isolationLevel == null) {
                throw new NullPointerException("isolationLevel is marked non-null but is null");
            }
            this.isolationLevel = isolationLevel;
            return this;
        }

        @Generated
        private TxOptionsBuilder firstLevelCache(boolean firstLevelCache) {
            this.firstLevelCache = firstLevelCache;
            return this;
        }

        @Generated
        private TxOptionsBuilder logLevel(TransactionLog.Level logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Generated
        private TxOptionsBuilder logStatementOnSuccess(boolean logStatementOnSuccess) {
            this.logStatementOnSuccess = logStatementOnSuccess;
            return this;
        }

        @Generated
        private TxOptionsBuilder scanOptions(ScanOptions scanOptions) {
            this.scanOptions = scanOptions;
            return this;
        }

        @Generated
        private TxOptionsBuilder timeoutOptions(TimeoutOptions timeoutOptions) {
            this.timeoutOptions = timeoutOptions;
            return this;
        }

        @Generated
        private TxOptionsBuilder dryRun(boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Generated
        private TxOptionsBuilder immediateWrites(boolean immediateWrites) {
            this.immediateWrites = immediateWrites;
            return this;
        }

        @Generated
        private TxOptions build() {
            return new TxOptions(this.isolationLevel, this.firstLevelCache, this.logLevel, this.logStatementOnSuccess, this.scanOptions, this.timeoutOptions, this.dryRun, this.immediateWrites);
        }

        @Generated
        public String toString() {
            return "TxOptions.TxOptionsBuilder(isolationLevel=" + this.isolationLevel + ", firstLevelCache=" + this.firstLevelCache + ", logLevel=" + this.logLevel + ", logStatementOnSuccess=" + this.logStatementOnSuccess + ", scanOptions=" + this.scanOptions + ", timeoutOptions=" + this.timeoutOptions + ", dryRun=" + this.dryRun + ", immediateWrites=" + this.immediateWrites + ")";
        }
    }

    public static final class ScanOptions {
        public static final ScanOptions DEFAULT = new ScanOptions(10000L, Duration.ofMinutes(5L), false);
        private final long maxSize;
        private final Duration timeout;
        private final boolean useNewSpliterator;

        @ConstructorProperties(value={"maxSize", "timeout", "useNewSpliterator"})
        @Generated
        public ScanOptions(long maxSize, Duration timeout, boolean useNewSpliterator) {
            this.maxSize = maxSize;
            this.timeout = timeout;
            this.useNewSpliterator = useNewSpliterator;
        }

        @Generated
        public long getMaxSize() {
            return this.maxSize;
        }

        @Generated
        public Duration getTimeout() {
            return this.timeout;
        }

        @Generated
        public boolean isUseNewSpliterator() {
            return this.useNewSpliterator;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ScanOptions)) {
                return false;
            }
            ScanOptions other = (ScanOptions)o;
            if (this.getMaxSize() != other.getMaxSize()) {
                return false;
            }
            if (this.isUseNewSpliterator() != other.isUseNewSpliterator()) {
                return false;
            }
            Duration this$timeout = this.getTimeout();
            Duration other$timeout = other.getTimeout();
            return !(this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $maxSize = this.getMaxSize();
            result = result * 59 + (int)($maxSize >>> 32 ^ $maxSize);
            result = result * 59 + (this.isUseNewSpliterator() ? 79 : 97);
            Duration $timeout = this.getTimeout();
            result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TxOptions.ScanOptions(maxSize=" + this.getMaxSize() + ", timeout=" + this.getTimeout() + ", useNewSpliterator=" + this.isUseNewSpliterator() + ")";
        }

        @Generated
        public ScanOptions withMaxSize(long maxSize) {
            return this.maxSize == maxSize ? this : new ScanOptions(maxSize, this.timeout, this.useNewSpliterator);
        }

        @Generated
        public ScanOptions withTimeout(Duration timeout) {
            return this.timeout == timeout ? this : new ScanOptions(this.maxSize, timeout, this.useNewSpliterator);
        }

        @Generated
        public ScanOptions withUseNewSpliterator(boolean useNewSpliterator) {
            return this.useNewSpliterator == useNewSpliterator ? this : new ScanOptions(this.maxSize, this.timeout, useNewSpliterator);
        }
    }

    public static final class TimeoutOptions {
        public static final TimeoutOptions DEFAULT = new TimeoutOptions(Duration.ofMinutes(5L));
        private static final long MAX_CANCEL_AFTER_DIFF = 100000000L;
        private static final long MIN_CANCEL_AFTER_DIFF = 50000000L;
        private static final double CANCEL_AFTER_DIFF_RATIO = 0.02;
        @NonNull
        private final Duration timeout;

        public Duration getCancelAfter() {
            long timeoutNanos = this.timeout.toNanos();
            long diffNanos = Math.round((double)timeoutNanos * 0.02);
            diffNanos = Math.max(diffNanos, 50000000L);
            long cancelAfterNanos = timeoutNanos - (diffNanos = Math.min(diffNanos, 100000000L));
            return cancelAfterNanos < 0L ? this.timeout : Duration.ofNanos(cancelAfterNanos);
        }

        public Long getDeadlineAfter() {
            return System.nanoTime() + this.timeout.toNanos();
        }

        @ConstructorProperties(value={"timeout"})
        @Generated
        public TimeoutOptions(@NonNull Duration timeout) {
            if (timeout == null) {
                throw new NullPointerException("timeout is marked non-null but is null");
            }
            this.timeout = timeout;
        }

        @NonNull
        @Generated
        public Duration getTimeout() {
            return this.timeout;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TimeoutOptions)) {
                return false;
            }
            TimeoutOptions other = (TimeoutOptions)o;
            Duration this$timeout = this.getTimeout();
            Duration other$timeout = other.getTimeout();
            return !(this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Duration $timeout = this.getTimeout();
            result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TxOptions.TimeoutOptions(timeout=" + this.getTimeout() + ")";
        }

        @Generated
        public TimeoutOptions withTimeout(@NonNull Duration timeout) {
            if (timeout == null) {
                throw new NullPointerException("timeout is marked non-null but is null");
            }
            return this.timeout == timeout ? this : new TimeoutOptions(timeout);
        }
    }
}

