/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.db.list;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import lombok.NonNull;
import tech.ydb.yoj.databind.expression.AndExpr;
import tech.ydb.yoj.databind.expression.FieldValue;
import tech.ydb.yoj.databind.expression.FilterExpression;
import tech.ydb.yoj.databind.expression.ListExpr;
import tech.ydb.yoj.databind.expression.NotExpr;
import tech.ydb.yoj.databind.expression.NullExpr;
import tech.ydb.yoj.databind.expression.OrExpr;
import tech.ydb.yoj.databind.expression.OrderExpression;
import tech.ydb.yoj.databind.expression.ScalarExpr;
import tech.ydb.yoj.databind.schema.Schema;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.EntityIdSchema;
import tech.ydb.yoj.repository.db.list.ListRequest;
import tech.ydb.yoj.repository.db.list.ListResult;
import tech.ydb.yoj.util.function.StreamSupplier;

public final class InMemoryQueries {
    public static <T extends Entity<T>> ListResult<T> list(@NonNull StreamSupplier<T> streamSupplier, @NonNull ListRequest<T> request) {
        if (streamSupplier == null) {
            throw new NullPointerException("streamSupplier is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        return ListResult.forPage(request, InMemoryQueries.find(streamSupplier, request.getFilter(), request.getOrderBy(), request.getPageSize() + 1, request.getOffset()));
    }

    public static <T extends Entity<T>> List<T> find(@NonNull StreamSupplier<T> streamSupplier, @Nullable FilterExpression<T> filter, @Nullable OrderExpression<T> orderBy, @Nullable Integer limit, @Nullable Long offset) {
        if (streamSupplier == null) {
            throw new NullPointerException("streamSupplier is marked non-null but is null");
        }
        if (limit == null && offset != null && offset > 0L) {
            throw new IllegalArgumentException("offset > 0 with limit=null is not supported");
        }
        try (Stream<T> stream = streamSupplier.stream();){
            Stream<Object> foundStream = stream;
            if (filter != null) {
                foundStream = foundStream.filter(InMemoryQueries.toPredicate(filter));
            }
            foundStream = orderBy != null ? foundStream.sorted(InMemoryQueries.toComparator(orderBy)) : foundStream.sorted(EntityIdSchema.SORT_ENTITY_BY_ID);
            foundStream = foundStream.skip(offset == null ? 0L : offset);
            if (limit != null) {
                foundStream = foundStream.limit(limit.intValue());
            }
            List list = foundStream.collect(Collectors.toList());
            return list;
        }
    }

    public static <T> Predicate<T> toPredicate(@NonNull FilterExpression<T> filter) {
        if (filter == null) {
            throw new NullPointerException("filter is marked non-null but is null");
        }
        return (Predicate)filter.visit(new FilterExpression.Visitor<T, Predicate<T>>(){

            public Predicate<T> visitScalarExpr(@NonNull ScalarExpr<T> scalarExpr) {
                if (scalarExpr == null) {
                    throw new NullPointerException("scalarExpr is marked non-null but is null");
                }
                Function<Object, Comparable> getActual = arg_0 -> scalarExpr.getActualValue(arg_0);
                Comparable expected = scalarExpr.getExpectedValue();
                return switch (scalarExpr.getOperator()) {
                    default -> throw new IncompatibleClassChangeError();
                    case ScalarExpr.Operator.EQ -> obj -> InMemoryQueries.eq((Comparable)getActual.apply(obj), expected);
                    case ScalarExpr.Operator.NEQ -> obj -> InMemoryQueries.neq((Comparable)getActual.apply(obj), expected);
                    case ScalarExpr.Operator.GT -> obj -> InMemoryQueries.compare((Comparable)getActual.apply(obj), expected) > 0;
                    case ScalarExpr.Operator.GTE -> obj -> InMemoryQueries.compare((Comparable)getActual.apply(obj), expected) >= 0;
                    case ScalarExpr.Operator.LT -> obj -> InMemoryQueries.compare((Comparable)getActual.apply(obj), expected) < 0;
                    case ScalarExpr.Operator.LTE -> obj -> InMemoryQueries.compare((Comparable)getActual.apply(obj), expected) <= 0;
                    case ScalarExpr.Operator.CONTAINS -> obj -> InMemoryQueries.contains((String)getActual.apply(obj), (String)((Object)expected));
                    case ScalarExpr.Operator.NOT_CONTAINS -> obj -> !InMemoryQueries.contains((String)getActual.apply(obj), (String)((Object)expected));
                    case ScalarExpr.Operator.STARTS_WITH -> obj -> InMemoryQueries.startsWith((String)getActual.apply(obj), (String)((Object)expected));
                    case ScalarExpr.Operator.ENDS_WITH -> obj -> InMemoryQueries.endsWith((String)getActual.apply(obj), (String)((Object)expected));
                };
            }

            public Predicate<T> visitNullExpr(@NonNull NullExpr<T> nullExpr) {
                if (nullExpr == null) {
                    throw new NullPointerException("nullExpr is marked non-null but is null");
                }
                switch (nullExpr.getOperator()) {
                    case IS_NULL: {
                        return arg_0 -> nullExpr.isActualValueNull(arg_0);
                    }
                    case IS_NOT_NULL: {
                        return Predicate.not(arg_0 -> nullExpr.isActualValueNull(arg_0));
                    }
                }
                throw new UnsupportedOperationException("Unsupported operator in nullability expression: " + nullExpr.getOperator());
            }

            public Predicate<T> visitListExpr(@NonNull ListExpr<T> listExpr) {
                if (listExpr == null) {
                    throw new NullPointerException("listExpr is marked non-null but is null");
                }
                Function<Object, Comparable> getActual = arg_0 -> listExpr.getActualValue(arg_0);
                List expected = listExpr.getExpectedValues();
                switch (listExpr.getOperator()) {
                    case IN: {
                        return obj -> expected.contains(getActual.apply(obj));
                    }
                    case NOT_IN: {
                        return obj -> !expected.contains(getActual.apply(obj));
                    }
                }
                throw new UnsupportedOperationException("Unsupported operator in filter expression: " + listExpr.getOperator());
            }

            public Predicate<T> visitAndExpr(@NonNull AndExpr<T> andExpr) {
                if (andExpr == null) {
                    throw new NullPointerException("andExpr is marked non-null but is null");
                }
                return andExpr.stream().map(expr -> (Predicate)expr.visit((FilterExpression.Visitor)this)).reduce(__ -> true, Predicate::and);
            }

            public Predicate<T> visitOrExpr(@NonNull OrExpr<T> orExpr) {
                if (orExpr == null) {
                    throw new NullPointerException("orExpr is marked non-null but is null");
                }
                return orExpr.stream().map(expr -> (Predicate)expr.visit((FilterExpression.Visitor)this)).reduce(__ -> false, Predicate::or);
            }

            public Predicate<T> visitNotExpr(@NonNull NotExpr<T> notExpr) {
                if (notExpr == null) {
                    throw new NullPointerException("notExpr is marked non-null but is null");
                }
                return ((Predicate)notExpr.getDelegate().visit((FilterExpression.Visitor)this)).negate();
            }
        });
    }

    public static <T extends Entity<T>> Comparator<T> toComparator(@NonNull OrderExpression<T> orderBy) {
        if (orderBy == null) {
            throw new NullPointerException("orderBy is marked non-null but is null");
        }
        Schema schema = orderBy.getSchema();
        return (a, b) -> {
            Map mapA = schema.flatten(a);
            Map mapB = schema.flatten(b);
            for (OrderExpression.SortKey sortKey : orderBy.getKeys()) {
                for (Schema.JavaField field : sortKey.getField().flatten().collect(Collectors.toList())) {
                    int res = InMemoryQueries.compare(FieldValue.getComparable((Map)mapA, (Schema.JavaField)field), FieldValue.getComparable((Map)mapB, (Schema.JavaField)field));
                    if (res == 0) continue;
                    return sortKey.getOrder() == OrderExpression.SortOrder.ASCENDING ? res : -res;
                }
            }
            return 0;
        };
    }

    private static int compare(@Nullable Comparable a, @Nullable Comparable b) {
        return Comparator.nullsFirst(Comparator.naturalOrder()).compare(a, b);
    }

    private static <T> boolean eq(@Nullable T a, @Nullable T b) {
        if (a == null && b == null) {
            return true;
        }
        if (a != null && b != null) {
            return a.equals(b);
        }
        return false;
    }

    private static <T> boolean neq(@Nullable T a, @Nullable T b) {
        if (a == null && b == null) {
            return false;
        }
        if (a != null && b != null) {
            return !a.equals(b);
        }
        return false;
    }

    private static boolean contains(@Nullable String input, @Nullable String substring) {
        if (input == null || substring == null) {
            return false;
        }
        return input.contains(substring);
    }

    private static boolean startsWith(@Nullable String input, @Nullable String substring) {
        if (input == null || substring == null) {
            return false;
        }
        return input.startsWith(substring);
    }

    private static boolean endsWith(@Nullable String input, @Nullable String substring) {
        if (input == null || substring == null) {
            return false;
        }
        return input.endsWith(substring);
    }
}

