/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.db.cache;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Supplier;
import lombok.NonNull;
import tech.ydb.yoj.repository.BaseDb;
import tech.ydb.yoj.repository.db.TxOptions;
import tech.ydb.yoj.repository.db.cache.FirstLevelCache;
import tech.ydb.yoj.repository.db.cache.TransactionLog;
import tech.ydb.yoj.repository.db.projection.ProjectionCache;
import tech.ydb.yoj.repository.db.projection.RoProjectionCache;
import tech.ydb.yoj.repository.db.projection.RwProjectionCache;

public class TransactionLocal {
    private final Map<Supplier<?>, Object> singletons = new IdentityHashMap();
    private final Supplier<FirstLevelCache> firstLevelCacheSupplier;
    private final Supplier<ProjectionCache> projectionCacheSupplier;
    private final Supplier<TransactionLog> logSupplier;

    public TransactionLocal(@NonNull TxOptions options) {
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        this.firstLevelCacheSupplier = options.isFirstLevelCache() ? FirstLevelCache::create : FirstLevelCache::empty;
        this.projectionCacheSupplier = options.isMutable() ? RwProjectionCache::new : RoProjectionCache::new;
        this.logSupplier = () -> new TransactionLog(options.getLogLevel());
    }

    public static TransactionLocal get() {
        return BaseDb.current(Holder.class).getTransactionLocal();
    }

    public <X> X instance(@NonNull Supplier<X> supplier) {
        if (supplier == null) {
            throw new NullPointerException("supplier is marked non-null but is null");
        }
        return (X)this.singletons.computeIfAbsent(supplier, Supplier::get);
    }

    public ProjectionCache projectionCache() {
        return this.instance(this.projectionCacheSupplier);
    }

    public FirstLevelCache firstLevelCache() {
        return this.instance(this.firstLevelCacheSupplier);
    }

    public TransactionLog log() {
        return this.instance(this.logSupplier);
    }

    public static interface Holder {
        public TransactionLocal getTransactionLocal();
    }
}

