/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.db;

import java.time.Duration;
import java.util.function.Supplier;
import tech.ydb.yoj.repository.db.IsolationLevel;
import tech.ydb.yoj.repository.db.TxManagerState;
import tech.ydb.yoj.repository.db.cache.TransactionLog;

public interface TxManager {
    public TxManager withName(String var1);

    public TxManager withLogContext(String var1);

    public TxManager separate();

    public TxManager delayedWrites();

    public TxManager immediateWrites();

    public TxManager noFirstLevelCache();

    public TxManager failOnUnknownSeparateTx();

    default public TxManager withName(String name, String logContext) {
        return this.withName(name).withLogContext(logContext);
    }

    public TxManager withMaxRetries(int var1);

    public TxManager withDryRun(boolean var1);

    default public TxManager withVerboseLogging() {
        return this.withLogLevel(TransactionLog.Level.DEBUG);
    }

    default public TxManager withBriefLogging() {
        return this.withLogLevel(TransactionLog.Level.INFO);
    }

    default public TxManager noLogging() {
        return this.withLogLevel(TransactionLog.Level.OFF);
    }

    public TxManager withLogLevel(TransactionLog.Level var1);

    public TxManager withLogStatementOnSuccess(boolean var1);

    public TxManager withTimeout(Duration var1);

    public <T> T tx(Supplier<T> var1);

    public void tx(Runnable var1);

    public ReadonlyBuilder readOnly();

    public ScanBuilder scan();

    public TxManagerState getState();

    public static interface ReadonlyBuilder {
        public ReadonlyBuilder withStatementIsolationLevel(IsolationLevel var1);

        default public ReadonlyBuilder withFirstLevelCache() {
            return this.withFirstLevelCache(true);
        }

        default public ReadonlyBuilder noFirstLevelCache() {
            return this.withFirstLevelCache(false);
        }

        public ReadonlyBuilder withFirstLevelCache(boolean var1);

        public <T> T run(Supplier<T> var1);

        default public void run(Runnable runnable) {
            this.run(() -> {
                runnable.run();
                return null;
            });
        }
    }

    public static interface ScanBuilder {
        public ScanBuilder withMaxSize(long var1);

        public ScanBuilder withTimeout(Duration var1);

        public <T> T run(Supplier<T> var1);

        default public void run(Runnable runnable) {
            this.run(() -> {
                runnable.run();
                return null;
            });
        }
    }
}

