/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.db;

import com.google.common.base.Preconditions;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import tech.ydb.yoj.repository.db.RepositoryTransaction;

public interface Tx {
    public void defer(Runnable var1);

    public void deferFinally(Runnable var1);

    public void deferBeforeCommit(Runnable var1);

    public String getName();

    public RepositoryTransaction getRepositoryTransaction();

    public static void checkSameTx(@Nullable Tx originTx) {
        if (originTx != null && Current.exists()) {
            Preconditions.checkState((originTx == Current.get() ? 1 : 0) != 0, (Object)"Can't call table from another transaction");
        }
    }

    public static class Current {
        private static final ThreadLocal<Tx> current = new ThreadLocal();

        public static boolean exists() {
            return null != current.get();
        }

        public static Tx get() throws IllegalStateException {
            Tx ctx = current.get();
            if (ctx == null) {
                throw new IllegalStateException("Operation is not allowed out of transaction context");
            }
            return ctx;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static <R> R runInTx(Tx tx, Supplier<R> supplier) {
            Tx existing = current.get();
            current.set(tx);
            try {
                R r = supplier.get();
                return r;
            }
            finally {
                current.set(existing);
            }
        }
    }
}

