/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.db;

import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;
import tech.ydb.yoj.databind.expression.FilterBuilder;
import tech.ydb.yoj.databind.expression.FilterExpression;
import tech.ydb.yoj.databind.expression.OrderBuilder;
import tech.ydb.yoj.databind.expression.OrderExpression;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.EntityExpressions;
import tech.ydb.yoj.repository.db.Table;

public final class TableQueryBuilder<T extends Entity<T>> {
    private final Table<T> table;
    private Set<? extends Entity.Id<T>> ids;
    private Set<?> keys;
    private String indexName = null;
    private Integer limit = null;
    private Long offset = null;
    private FilterExpression<T> filter = null;
    private FilterBuilder<T> filterBuilder = null;
    private OrderExpression<T> orderBy = null;

    public TableQueryBuilder(@NonNull Table<T> table) {
        if (table == null) {
            throw new NullPointerException("table is marked non-null but is null");
        }
        this.table = table;
    }

    public long count() {
        Preconditions.checkState((this.ids == null && this.keys == null ? 1 : 0) != 0, (Object)"Count query doesn't support selecting by ids/keys");
        FilterExpression<T> filter = this.getFinalFilter();
        if (filter == null) {
            return this.table.countAll();
        }
        return this.table.count(this.indexName, filter);
    }

    public boolean exists() {
        return this.findOne() != null;
    }

    @Nullable
    public T findOne() {
        List<T> results = this.find(1);
        return (T)(results.isEmpty() ? null : (Entity)results.get(0));
    }

    @Nullable
    public <V extends Table.View> V findOne(Class<V> viewClass) {
        List<V> results = this.limit(1L).find(viewClass, false);
        return (V)(results.isEmpty() ? null : (Table.View)results.get(0));
    }

    @NonNull
    public List<T> find() {
        return this.find(this.limit);
    }

    @NonNull
    public <V extends Table.View> List<V> find(Class<V> viewClass) {
        return this.find(viewClass, false);
    }

    private List<T> find(Integer limit) {
        if (this.ids == null && this.keys == null) {
            return this.table.find(this.indexName, this.getFinalFilter(), this.orderBy, limit, this.offset);
        }
        Preconditions.checkState((this.offset == null ? 1 : 0) != 0, (Object)"Query selecting by ids/keys does not support offset");
        if (this.ids != null) {
            Preconditions.checkState((this.indexName == null ? 1 : 0) != 0, (Object)"Query searching by ids must use PK but the secondary index is specified");
            return this.table.find(this.ids, this.getFinalFilter(), this.orderBy, limit);
        }
        Preconditions.checkState((this.indexName != null ? 1 : 0) != 0, (Object)"Query searching by arbitrary keys requires an appropriate index");
        return this.table.find(this.indexName, this.keys, this.getFinalFilter(), this.orderBy, limit);
    }

    public <V extends Table.View> List<V> find(Class<V> viewClass, boolean distinct) {
        if (this.ids == null && this.keys == null) {
            return this.table.find(viewClass, this.indexName, this.getFinalFilter(), this.orderBy, this.limit, this.offset, distinct);
        }
        Preconditions.checkState((!distinct ? 1 : 0) != 0, (Object)"Query searching by ids/keys does not support distinct");
        Preconditions.checkState((this.offset == null ? 1 : 0) != 0, (Object)"Query searching by ids/keys does not support offset");
        if (this.ids != null) {
            Preconditions.checkState((this.indexName == null ? 1 : 0) != 0, (Object)"Query searching by ids must use PK but the secondary index is specified");
            return this.table.find(viewClass, this.ids, this.getFinalFilter(), this.orderBy, this.limit);
        }
        Preconditions.checkState((this.indexName != null ? 1 : 0) != 0, (Object)"Query searching by arbitrary keys requires an appropriate index");
        return this.table.find(viewClass, this.indexName, this.keys, this.getFinalFilter(), this.orderBy, this.limit);
    }

    @NonNull
    public <ID extends Entity.Id<T>> List<ID> findIds() {
        return this.table.findIds(this.indexName, this.getFinalFilter(), this.orderBy, this.limit, this.offset);
    }

    @NonNull
    public <ID extends Entity.Id<T>> TableQueryBuilder<T> ids(Set<ID> ids) {
        Preconditions.checkState((this.keys == null ? 1 : 0) != 0, (Object)"You can't use both .ids and .keys methods");
        this.ids = ids;
        return this;
    }

    @NonNull
    public TableQueryBuilder<T> keys(Set<?> keys) {
        Preconditions.checkState((this.ids == null ? 1 : 0) != 0, (Object)"You can't use both .keys and .ids methods");
        this.keys = keys;
        return this;
    }

    @NonNull
    public TableQueryFieldFilterBuilder where(@NonNull String fieldPath) {
        if (fieldPath == null) {
            throw new NullPointerException("fieldPath is marked non-null but is null");
        }
        return new TableQueryFieldFilterBuilder(this.filterBuilder().where(fieldPath));
    }

    @NonNull
    public TableQueryBuilder<T> where(@NonNull UnaryOperator<FilterBuilder<T>> filterBuilderOp) {
        if (filterBuilderOp == null) {
            throw new NullPointerException("filterBuilderOp is marked non-null but is null");
        }
        return this.where(this.buildFilterExpression(filterBuilderOp));
    }

    @NonNull
    public TableQueryBuilder<T> where(@NonNull FilterExpression<T> filter) {
        if (filter == null) {
            throw new NullPointerException("filter is marked non-null but is null");
        }
        this.filterBuilder = this.filterBuilder().where(filter);
        return this;
    }

    private FilterBuilder<T> filterBuilder() {
        if (this.filterBuilder == null) {
            Preconditions.checkState((this.filter == null ? 1 : 0) != 0, (Object)"You can't use both .where/.and/.or and .filter methods");
            this.filterBuilder = EntityExpressions.newFilterBuilder(this.table.getType());
        }
        return this.filterBuilder;
    }

    @NonNull
    public TableQueryFieldFilterBuilder and(@NonNull String fieldPath) {
        if (fieldPath == null) {
            throw new NullPointerException("fieldPath is marked non-null but is null");
        }
        return new TableQueryFieldFilterBuilder(this.filterBuilder().and(fieldPath));
    }

    @NonNull
    public TableQueryBuilder<T> and(@Nullable FilterExpression<T> filter) {
        this.filterBuilder = this.filterBuilder().and(filter);
        return this;
    }

    @NonNull
    public TableQueryBuilder<T> and(@NonNull UnaryOperator<FilterBuilder<T>> filterBuilderOp) {
        if (filterBuilderOp == null) {
            throw new NullPointerException("filterBuilderOp is marked non-null but is null");
        }
        return this.and(this.buildFilterExpression(filterBuilderOp));
    }

    @NonNull
    public TableQueryFieldFilterBuilder or(@NonNull String fieldPath) {
        if (fieldPath == null) {
            throw new NullPointerException("fieldPath is marked non-null but is null");
        }
        return new TableQueryFieldFilterBuilder(this.filterBuilder().or(fieldPath));
    }

    @NonNull
    public TableQueryBuilder<T> or(@NonNull FilterExpression<T> filter) {
        if (filter == null) {
            throw new NullPointerException("filter is marked non-null but is null");
        }
        this.filterBuilder = this.filterBuilder().or(filter);
        return this;
    }

    @NonNull
    public TableQueryBuilder<T> or(@NonNull UnaryOperator<FilterBuilder<T>> filterBuilderOp) {
        if (filterBuilderOp == null) {
            throw new NullPointerException("filterBuilderOp is marked non-null but is null");
        }
        return this.or(this.buildFilterExpression(filterBuilderOp));
    }

    @Nullable
    private FilterExpression<T> getFinalFilter() {
        if (this.filter != null) {
            return this.filter;
        }
        if (this.filterBuilder != null) {
            return this.filterBuilder.build();
        }
        return null;
    }

    @NonNull
    public TableQueryBuilder<T> orderBy(@Nullable OrderExpression<T> orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    @NonNull
    public TableQueryBuilder<T> orderBy(@NonNull UnaryOperator<OrderBuilder<T>> orderBuilderOp) {
        if (orderBuilderOp == null) {
            throw new NullPointerException("orderBuilderOp is marked non-null but is null");
        }
        return this.orderBy(((OrderBuilder)orderBuilderOp.apply(EntityExpressions.newOrderBuilder(this.table.getType()))).build());
    }

    public TableQueryBuilder<T> defaultOrder() {
        this.orderBy = EntityExpressions.defaultOrder(this.table.getType());
        return this;
    }

    @NonNull
    public TableQueryBuilder<T> filter(@Nullable FilterExpression<T> filter) {
        Preconditions.checkState((this.filterBuilder == null ? 1 : 0) != 0, (Object)"You can't use both .filter and .where/.and/.or methods");
        this.filter = filter;
        return this;
    }

    @NonNull
    public TableQueryBuilder<T> filter(@NonNull UnaryOperator<FilterBuilder<T>> filterBuilderOp) {
        if (filterBuilderOp == null) {
            throw new NullPointerException("filterBuilderOp is marked non-null but is null");
        }
        return this.filter(this.buildFilterExpression(filterBuilderOp));
    }

    @NonNull
    public TableQueryBuilder<T> offset(long offset) {
        this.offset = offset;
        return this;
    }

    @NonNull
    public TableQueryBuilder<T> limit(long limit) {
        Preconditions.checkArgument((limit > 0L ? 1 : 0) != 0, (Object)"'limit' must be greater than zero");
        this.limit = Math.toIntExact(limit);
        return this;
    }

    @NonNull
    public TableQueryBuilder<T> index(String indexName) {
        this.indexName = indexName;
        return this;
    }

    private FilterExpression<T> buildFilterExpression(UnaryOperator<FilterBuilder<T>> filterBuilderOp) {
        return ((FilterBuilder)filterBuilderOp.apply(EntityExpressions.newFilterBuilder(this.table.getType()))).build();
    }

    public class TableQueryFieldFilterBuilder {
        @NonNull
        private final FilterBuilder.FieldBuilder fieldBuilder;

        @SafeVarargs
        @NonNull
        public final <V> TableQueryBuilder<T> in(@NonNull V possibleValue, V ... otherPossibleValues) {
            if (possibleValue == null) {
                throw new NullPointerException("possibleValue is marked non-null but is null");
            }
            if (otherPossibleValues == null) {
                throw new NullPointerException("otherPossibleValues is marked non-null but is null");
            }
            TableQueryBuilder.this.filterBuilder = this.fieldBuilder.in(possibleValue, (Object[])otherPossibleValues);
            return TableQueryBuilder.this;
        }

        @NonNull
        public <V> TableQueryBuilder<T> in(@NonNull @NonNull Collection<@NonNull ? extends V> values) {
            if (values == null) {
                throw new NullPointerException("values is marked non-null but is null");
            }
            TableQueryBuilder.this.filterBuilder = this.fieldBuilder.in(values);
            return TableQueryBuilder.this;
        }

        @SafeVarargs
        @NonNull
        public final <V> TableQueryBuilder<T> notIn(@NonNull V impossibleValue, V ... otherImpossibleValues) {
            if (impossibleValue == null) {
                throw new NullPointerException("impossibleValue is marked non-null but is null");
            }
            if (otherImpossibleValues == null) {
                throw new NullPointerException("otherImpossibleValues is marked non-null but is null");
            }
            TableQueryBuilder.this.filterBuilder = this.fieldBuilder.notIn(impossibleValue, (Object[])otherImpossibleValues);
            return TableQueryBuilder.this;
        }

        @NonNull
        public <V> TableQueryBuilder<T> notIn(@NonNull @NonNull Collection<@NonNull ? extends V> values) {
            if (values == null) {
                throw new NullPointerException("values is marked non-null but is null");
            }
            TableQueryBuilder.this.filterBuilder = this.fieldBuilder.notIn(values);
            return TableQueryBuilder.this;
        }

        @NonNull
        public TableQueryBuilder<T> eq(@Nullable Object value) {
            TableQueryBuilder.this.filterBuilder = this.fieldBuilder.eq(value);
            return TableQueryBuilder.this;
        }

        @NonNull
        public TableQueryBuilder<T> neq(@Nullable Object value) {
            TableQueryBuilder.this.filterBuilder = this.fieldBuilder.neq(value);
            return TableQueryBuilder.this;
        }

        @NonNull
        public TableQueryBuilder<T> lt(@NonNull Object value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            TableQueryBuilder.this.filterBuilder = this.fieldBuilder.lt(value);
            return TableQueryBuilder.this;
        }

        @NonNull
        public TableQueryBuilder<T> lte(@NonNull Object value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            TableQueryBuilder.this.filterBuilder = this.fieldBuilder.lte(value);
            return TableQueryBuilder.this;
        }

        @NonNull
        public TableQueryBuilder<T> gt(@NonNull Object value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            TableQueryBuilder.this.filterBuilder = this.fieldBuilder.gt(value);
            return TableQueryBuilder.this;
        }

        @NonNull
        public TableQueryBuilder<T> gte(@NonNull Object value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            TableQueryBuilder.this.filterBuilder = this.fieldBuilder.gte(value);
            return TableQueryBuilder.this;
        }

        @NonNull
        public TableQueryBuilder<T> between(@NonNull Object min, @NonNull Object max) {
            if (min == null) {
                throw new NullPointerException("min is marked non-null but is null");
            }
            if (max == null) {
                throw new NullPointerException("max is marked non-null but is null");
            }
            TableQueryBuilder.this.filterBuilder = this.fieldBuilder.between(min, max);
            return TableQueryBuilder.this;
        }

        @NonNull
        public TableQueryBuilder<T> isNull() {
            TableQueryBuilder.this.filterBuilder = this.fieldBuilder.isNull();
            return TableQueryBuilder.this;
        }

        @NonNull
        public TableQueryBuilder<T> isNotNull() {
            TableQueryBuilder.this.filterBuilder = this.fieldBuilder.isNotNull();
            return TableQueryBuilder.this;
        }

        @ConstructorProperties(value={"fieldBuilder"})
        @Generated
        private TableQueryFieldFilterBuilder(FilterBuilder.FieldBuilder fieldBuilder) {
            if (fieldBuilder == null) {
                throw new NullPointerException("fieldBuilder is marked non-null but is null");
            }
            this.fieldBuilder = fieldBuilder;
        }
    }
}

