/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.db;

import com.google.common.base.Preconditions;
import io.prometheus.client.Counter;
import io.prometheus.client.Histogram;
import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ydb.yoj.repository.db.IsolationLevel;
import tech.ydb.yoj.repository.db.Repository;
import tech.ydb.yoj.repository.db.Tx;
import tech.ydb.yoj.repository.db.TxImpl;
import tech.ydb.yoj.repository.db.TxManager;
import tech.ydb.yoj.repository.db.TxManagerState;
import tech.ydb.yoj.repository.db.TxOptions;
import tech.ydb.yoj.repository.db.cache.TransactionLog;
import tech.ydb.yoj.repository.db.exception.RetryableException;
import tech.ydb.yoj.util.lang.CallStack;
import tech.ydb.yoj.util.lang.Strings;

public final class StdTxManager
implements TxManager,
TxManagerState {
    public static volatile boolean useNewTxNameGeneration = false;
    private static final Logger log = LoggerFactory.getLogger(StdTxManager.class);
    private static final CallStack callStack = new CallStack();
    private static final int DEFAULT_MAX_ATTEMPT_COUNT = 100;
    private static final double[] TX_ATTEMPTS_BUCKETS = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 12.0, 14.0, 16.0, 18.0, 20.0, 25.0, 35.0, 40.0, 45.0, 50.0, 60.0, 70.0, 80.0, 90.0, 100.0};
    private static final double[] DURATION_BUCKETS = new double[]{0.001, 0.0025, 0.005, 0.0075, 0.01, 0.025, 0.05, 0.075, 0.1, 0.25, 0.5, 0.75, 1.0, 2.5, 5.0, 7.5, 10.0, 25.0, 50.0, 75.0, 100.0};
    private static final Histogram totalDuration = (Histogram)((Histogram.Builder)Histogram.build((String)"tx_total_duration_seconds", (String)"Tx total duration (seconds)").labelNames(new String[]{"tx_name"})).buckets(DURATION_BUCKETS).register();
    private static final Histogram attemptDuration = (Histogram)((Histogram.Builder)Histogram.build((String)"tx_attempt_duration_seconds", (String)"Tx attempt duration (seconds)").labelNames(new String[]{"tx_name"})).buckets(DURATION_BUCKETS).register();
    private static final Histogram attempts = (Histogram)((Histogram.Builder)Histogram.build((String)"tx_attempts", (String)"Tx attempts spent to success").labelNames(new String[]{"tx_name"})).buckets(TX_ATTEMPTS_BUCKETS).register();
    private static final Counter results = (Counter)((Counter.Builder)Counter.build((String)"tx_result", (String)"Tx commits/rollbacks/fails").labelNames(new String[]{"tx_name", "result"})).register();
    private static final Counter retries = (Counter)((Counter.Builder)Counter.build((String)"tx_retries", (String)"Tx retry reasons").labelNames(new String[]{"tx_name", "reason"})).register();
    private static final AtomicLong txLogIdSeq = new AtomicLong();
    private static final Pattern PACKAGE_PATTERN = Pattern.compile(".*\\.");
    private static final Pattern INNER_CLASS_PATTERN = Pattern.compile("\\$.*");
    private static final Pattern SHORTEN_NAME_PATTERN = Pattern.compile("([A-Z][a-z]{2})[a-z]+");
    private final Repository repository;
    private final int maxAttemptCount;
    private final String name;
    private final Integer logLine;
    private final String logContext;
    private final TxOptions options;
    private final SeparatePolicy separatePolicy;
    private final Set<String> skipCallerPackages;
    private final long txLogId = txLogIdSeq.incrementAndGet();

    public StdTxManager(Repository repository) {
        this(repository, 100, null, null, null, TxOptions.create(IsolationLevel.SERIALIZABLE_READ_WRITE), SeparatePolicy.LOG, Set.of());
    }

    @Deprecated
    public StdTxManager(Repository repository, int maxAttemptCount, String name, Integer logLine, String logContext, TxOptions options) {
        this(repository, maxAttemptCount, name, logLine, logContext, options, SeparatePolicy.LOG, Set.of());
    }

    @Override
    public TxManager separate() {
        return this.withSeparatePolicy(SeparatePolicy.ALLOW);
    }

    @Override
    public TxManager delayedWrites() {
        return this.withOptions(this.options.withImmediateWrites(false));
    }

    @Override
    public TxManager immediateWrites() {
        return this.withOptions(this.options.withImmediateWrites(true));
    }

    @Override
    public TxManager noFirstLevelCache() {
        return this.withOptions(this.options.withFirstLevelCache(false));
    }

    @Override
    public TxManager failOnUnknownSeparateTx() {
        return this.withSeparatePolicy(SeparatePolicy.STRICT);
    }

    @Override
    public TxManager withMaxRetries(int maxRetries) {
        Preconditions.checkArgument((maxRetries >= 0 ? 1 : 0) != 0, (Object)"retry count must be >= 0");
        return this.withMaxAttemptCount(1 + maxRetries);
    }

    @Override
    public TxManager withDryRun(boolean dryRun) {
        return this.withOptions(this.options.withDryRun(dryRun));
    }

    @Override
    public TxManager withTimeout(Duration timeout) {
        return this.withOptions(this.options.withTimeoutOptions(new TxOptions.TimeoutOptions(timeout)));
    }

    @Override
    public TxManager withLogLevel(TransactionLog.Level level) {
        return this.withOptions(this.options.withLogLevel(level));
    }

    @Override
    public TxManager withLogStatementOnSuccess(boolean logStatementOnSuccess) {
        return this.withOptions(this.options.withLogStatementOnSuccess(logStatementOnSuccess));
    }

    @Override
    public TxManager.ReadonlyBuilder readOnly() {
        return new ReadonlyBuilderImpl(this.options.withIsolationLevel(IsolationLevel.ONLINE_CONSISTENT_READ_ONLY));
    }

    @Override
    public TxManager.ScanBuilder scan() {
        return new ScanBuilderImpl(TxOptions.ScanOptions.DEFAULT);
    }

    @Override
    public void tx(Runnable runnable) {
        this.tx(() -> {
            runnable.run();
            return null;
        });
    }

    @Override
    public <T> T tx(Supplier<T> supplier) {
        if (this.name == null) {
            return this.withGeneratedNameAndLine().tx(supplier);
        }
        StdTxManager.checkSeparatePolicy(this.separatePolicy, this.name);
        return this.txImpl(supplier);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T txImpl(Supplier<T> supplier) {
        RetryableException lastRetryableException = null;
        TxImpl lastTx = null;
        try {
            Histogram.Timer ignored = ((Histogram.Child)totalDuration.labels(new String[]{this.name})).startTimer();
            for (int attempt = 1; attempt <= this.maxAttemptCount; ++attempt) {
                try {
                    T result;
                    ((Histogram.Child)attempts.labels(new String[]{this.name})).observe((double)attempt);
                    try (Histogram.Timer ignored1 = ((Histogram.Child)attemptDuration.labels(new String[]{this.name})).startTimer();){
                        lastTx = new TxImpl(this.name, this.repository.startTransaction(this.options), this.options);
                        result = this.runAttempt(supplier, lastTx);
                    }
                    if (this.options.isDryRun()) {
                        ((Counter.Child)results.labels(new String[]{this.name, "rollback"})).inc();
                        ((Counter.Child)results.labels(new String[]{this.name, "dry_run"})).inc();
                    } else {
                        ((Counter.Child)results.labels(new String[]{this.name, "commit"})).inc();
                    }
                    T t = result;
                    return t;
                }
                catch (RetryableException e) {
                    ((Counter.Child)retries.labels(new String[]{this.name, this.getExceptionNameForMetric(e)})).inc();
                    lastRetryableException = e;
                    if (attempt + 1 > this.maxAttemptCount) continue;
                    e.sleep(attempt);
                    continue;
                    catch (Exception e2) {
                        ((Counter.Child)results.labels(new String[]{this.name, "rollback"})).inc();
                        throw e2;
                    }
                }
            }
            ((Counter.Child)results.labels(new String[]{this.name, "fail"})).inc();
            throw ((RetryableException)Objects.requireNonNull(lastRetryableException)).rethrow();
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
        }
        finally {
            if (!this.options.isDryRun() && lastTx != null) {
                lastTx.runDeferredFinally();
            }
        }
    }

    private static void checkSeparatePolicy(SeparatePolicy separatePolicy, String txName) {
        if (!Tx.Current.exists()) {
            return;
        }
        switch (separatePolicy) {
            case ALLOW: {
                break;
            }
            case STRICT: {
                throw new IllegalStateException(String.format("Transaction %s was run when another transaction is active", txName));
            }
            case LOG: {
                log.warn("Transaction '{}' was run when another transaction is active. Perhaps unexpected behavior. Use TxManager.separate() to avoid this message", (Object)txName);
            }
        }
    }

    private String getExceptionNameForMetric(RetryableException e) {
        return Strings.removeSuffix((String)e.getClass().getSimpleName(), (String)"Exception");
    }

    /*
     * Exception decompiling
     */
    private <T> T runAttempt(Supplier<T> supplier, TxImpl tx) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private StdTxManager withGeneratedNameAndLine() {
        return useNewTxNameGeneration ? this.withGeneratedNameAndLineNew() : this.withGeneratedNameAndLineOld();
    }

    private StdTxManager withGeneratedNameAndLineOld() {
        String pkg = StdTxManager.class.getPackage().getName();
        for (StackTraceElement ste : new Exception().getStackTrace()) {
            if (ste.getClassName().startsWith(pkg)) continue;
            String name = ste.getClassName().replaceFirst(".*\\.", "").replaceFirst("\\$.*", "").replaceAll("([A-Z][a-z]{2})[a-z]+", "$1") + "#" + ste.getMethodName().replaceAll("([A-Z][a-z]{2})[a-z]+", "$1");
            return this.withName(name).withLogLine(ste.getLineNumber());
        }
        throw new IllegalStateException("Stacktrace doesn't contain elements from other packages");
    }

    private StdTxManager withGeneratedNameAndLineNew() {
        record TxInfo(String name, int lineNumber) {
        }
        TxInfo info = (TxInfo)callStack.findCallingFrame().skipPackage(StdTxManager.class.getPackageName()).skipPackages(this.skipCallerPackages).map(f -> new TxInfo(StdTxManager.txName(f.getClassName(), f.getMethodName()), f.getLineNumber()));
        return this.withName(info.name).withLogLine(info.lineNumber);
    }

    @NonNull
    private static String txName(String className, String methodName) {
        String cn = StdTxManager.replaceFirst(className, PACKAGE_PATTERN, "");
        cn = StdTxManager.replaceFirst(cn, INNER_CLASS_PATTERN, "");
        cn = StdTxManager.replaceAll(cn, SHORTEN_NAME_PATTERN, "$1");
        String mn = StdTxManager.replaceAll(methodName, SHORTEN_NAME_PATTERN, "$1");
        return cn + "#" + mn;
    }

    private static String replaceFirst(String input, Pattern regex, String replacement) {
        return regex.matcher(input).replaceFirst(replacement);
    }

    private static String replaceAll(String input, Pattern regex, String replacement) {
        return regex.matcher(input).replaceAll(replacement);
    }

    private String formatTx() {
        return this.formatTxId() + " {" + this.formatTxName(true) + "}";
    }

    private String formatTxId() {
        return Strings.leftPad((String)Long.toUnsignedString(this.txLogId, 36), (int)6, (char)'0') + this.options.getIsolationLevel().getTxIdSuffix();
    }

    private String formatTxName(boolean withContext) {
        return this.name + (String)(this.logLine != null ? ":" + this.logLine : "") + (String)(withContext && this.logContext != null ? "/" + this.logContext : "");
    }

    @Override
    public TxManagerState getState() {
        return this;
    }

    @Override
    public boolean isFirstLevelCache() {
        return this.options.isFirstLevelCache();
    }

    @Override
    @Nullable
    public IsolationLevel getIsolationLevel() {
        return this.options.isScan() ? null : this.options.getIsolationLevel();
    }

    @Override
    public boolean isReadOnly() {
        return this.options.isReadOnly();
    }

    @Override
    public boolean isScan() {
        return this.options.isScan();
    }

    public String toString() {
        return this.repository.getClass().getSimpleName();
    }

    @ConstructorProperties(value={"repository", "maxAttemptCount", "name", "logLine", "logContext", "options", "separatePolicy", "skipCallerPackages"})
    @Generated
    private StdTxManager(Repository repository, int maxAttemptCount, String name, Integer logLine, String logContext, TxOptions options, SeparatePolicy separatePolicy, Set<String> skipCallerPackages) {
        this.repository = repository;
        this.maxAttemptCount = maxAttemptCount;
        this.name = name;
        this.logLine = logLine;
        this.logContext = logContext;
        this.options = options;
        this.separatePolicy = separatePolicy;
        this.skipCallerPackages = skipCallerPackages;
    }

    @Override
    @Generated
    public Repository getRepository() {
        return this.repository;
    }

    @Generated
    private StdTxManager withMaxAttemptCount(int maxAttemptCount) {
        return this.maxAttemptCount == maxAttemptCount ? this : new StdTxManager(this.repository, maxAttemptCount, this.name, this.logLine, this.logContext, this.options, this.separatePolicy, this.skipCallerPackages);
    }

    @Override
    @Generated
    public StdTxManager withName(String name) {
        return this.name == name ? this : new StdTxManager(this.repository, this.maxAttemptCount, name, this.logLine, this.logContext, this.options, this.separatePolicy, this.skipCallerPackages);
    }

    @Generated
    private StdTxManager withLogLine(Integer logLine) {
        return this.logLine == logLine ? this : new StdTxManager(this.repository, this.maxAttemptCount, this.name, logLine, this.logContext, this.options, this.separatePolicy, this.skipCallerPackages);
    }

    @Override
    @Generated
    public StdTxManager withLogContext(String logContext) {
        return this.logContext == logContext ? this : new StdTxManager(this.repository, this.maxAttemptCount, this.name, this.logLine, logContext, this.options, this.separatePolicy, this.skipCallerPackages);
    }

    @Override
    @Generated
    public String getLogContext() {
        return this.logContext;
    }

    @Generated
    private StdTxManager withOptions(TxOptions options) {
        return this.options == options ? this : new StdTxManager(this.repository, this.maxAttemptCount, this.name, this.logLine, this.logContext, options, this.separatePolicy, this.skipCallerPackages);
    }

    @Generated
    private StdTxManager withSeparatePolicy(SeparatePolicy separatePolicy) {
        return this.separatePolicy == separatePolicy ? this : new StdTxManager(this.repository, this.maxAttemptCount, this.name, this.logLine, this.logContext, this.options, separatePolicy, this.skipCallerPackages);
    }

    @Generated
    public StdTxManager withSkipCallerPackages(Set<String> skipCallerPackages) {
        return this.skipCallerPackages == skipCallerPackages ? this : new StdTxManager(this.repository, this.maxAttemptCount, this.name, this.logLine, this.logContext, this.options, this.separatePolicy, skipCallerPackages);
    }

    private static enum SeparatePolicy {
        ALLOW,
        LOG,
        STRICT;

    }

    private class ReadonlyBuilderImpl
    implements TxManager.ReadonlyBuilder {
        private final TxOptions options;

        @Override
        public TxManager.ReadonlyBuilder withStatementIsolationLevel(IsolationLevel isolationLevel) {
            Preconditions.checkArgument((boolean)isolationLevel.isReadOnly(), (String)"readOnly() can only be used with a read-only tx isolation level, but got: %s", (Object)((Object)isolationLevel));
            return this.withOptions(this.options.withIsolationLevel(isolationLevel));
        }

        @Override
        public TxManager.ReadonlyBuilder withFirstLevelCache(boolean firstLevelCache) {
            return this.withOptions(this.options.withFirstLevelCache(firstLevelCache));
        }

        @Override
        public <T> T run(Supplier<T> supplier) throws RetryableException {
            return StdTxManager.this.withOptions(this.options).tx(supplier);
        }

        @ConstructorProperties(value={"options"})
        @Generated
        public ReadonlyBuilderImpl(TxOptions options) {
            this.options = options;
        }

        @Generated
        private ReadonlyBuilderImpl withOptions(TxOptions options) {
            return this.options == options ? this : new ReadonlyBuilderImpl(options);
        }
    }

    private class ScanBuilderImpl
    implements TxManager.ScanBuilder {
        private final TxOptions.ScanOptions options;

        @Override
        public TxManager.ScanBuilder withMaxSize(long maxSize) {
            return this.withOptions(this.options.withMaxSize(maxSize));
        }

        @Override
        public TxManager.ScanBuilder withTimeout(Duration timeout) {
            return this.withOptions(this.options.withTimeout(timeout));
        }

        @Override
        public <T> T run(Supplier<T> supplier) throws RetryableException {
            TxOptions txOptions = StdTxManager.this.options.withScanOptions(this.options).withFirstLevelCache(false);
            return StdTxManager.this.withOptions(txOptions).tx(supplier);
        }

        @ConstructorProperties(value={"options"})
        @Generated
        public ScanBuilderImpl(TxOptions.ScanOptions options) {
            this.options = options;
        }

        @Generated
        private ScanBuilderImpl withOptions(TxOptions.ScanOptions options) {
            return this.options == options ? this : new ScanBuilderImpl(options);
        }
    }
}

