/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.db;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import tech.ydb.yoj.databind.schema.Schema;
import tech.ydb.yoj.databind.schema.configuration.SchemaRegistry;
import tech.ydb.yoj.databind.schema.naming.NamingStrategy;
import tech.ydb.yoj.databind.schema.reflect.ReflectField;
import tech.ydb.yoj.databind.schema.reflect.Reflector;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.EntityIdSchema;

public final class EntitySchema<T extends Entity<T>>
extends Schema<T> {
    private static final Type ENTITY_TYPE_PARAMETER = Entity.class.getTypeParameters()[0];
    private final SchemaRegistry registry;

    public static <T extends Entity<T>> EntitySchema<T> of(Class<T> type) {
        return EntitySchema.of(type, null);
    }

    public static <T extends Entity<T>> EntitySchema<T> of(Class<T> type, NamingStrategy namingStrategy) {
        return EntitySchema.of(SchemaRegistry.getDefault(), type, namingStrategy);
    }

    public static <T extends Entity<T>> EntitySchema<T> of(SchemaRegistry registry, Class<T> type) {
        return EntitySchema.of(registry, type, null);
    }

    public static <T extends Entity<T>> EntitySchema<T> of(SchemaRegistry registry, Class<T> type, NamingStrategy namingStrategy) {
        return EntitySchema.of(registry, SchemaRegistry.SchemaKey.of(type, (NamingStrategy)namingStrategy));
    }

    public static <T extends Entity<T>> EntitySchema<T> of(SchemaRegistry registry, SchemaRegistry.SchemaKey<T> key) {
        return (EntitySchema)registry.getOrCreate(EntitySchema.class, (k, r) -> new EntitySchema(k, r, registry), key);
    }

    private EntitySchema(SchemaRegistry.SchemaKey<T> key, Reflector reflector, SchemaRegistry registry) {
        super(EntitySchema.checkEntityType(key), reflector);
        this.registry = registry;
    }

    private static <T extends Entity<T>> SchemaRegistry.SchemaKey<T> checkEntityType(SchemaRegistry.SchemaKey<T> key) {
        Class<?> idFieldType;
        Class entityType = key.clazz();
        if (!Entity.class.isAssignableFrom(entityType)) {
            throw new IllegalArgumentException(String.format("Entity type [%s] must implement [%s]", entityType.getName(), Entity.class));
        }
        Class<?> entityTypeFromEntityIface = EntitySchema.resolveEntityTypeFromEntityIface(entityType);
        if (!entityTypeFromEntityIface.equals(entityType)) {
            throw new IllegalArgumentException(String.format("Entity type [%s] must implement [%s] specified by the same type, but it is specified by [%s]", entityType.getName(), Entity.class, entityTypeFromEntityIface.getName()));
        }
        try {
            idFieldType = entityType.getDeclaredField("id").getType();
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException(String.format("Entity type [%s] does not contain a mandatory \"%s\" field", entityType.getName(), "id"));
        }
        if (!Entity.Id.class.isAssignableFrom(idFieldType)) {
            throw new IllegalArgumentException(String.format("Entity ID type [%s] must implement [%s]", idFieldType.getName(), Entity.Id.class));
        }
        Class<?> entityTypeFromIdType = EntityIdSchema.resolveEntityType(idFieldType);
        if (!entityTypeFromIdType.equals(entityType)) {
            throw new IllegalArgumentException(String.format("An identifier field \"%s\" has a type [%s] that is not an identifier type for an entity of type [%s]", "id", idFieldType.getName(), entityType.getName()));
        }
        return key;
    }

    static Class<?> resolveEntityTypeFromEntityIface(Class<?> entityType) {
        return TypeToken.of(entityType).resolveType(ENTITY_TYPE_PARAMETER).getRawType();
    }

    protected boolean isFlattenable(ReflectField field) {
        return Entity.Id.class.isAssignableFrom(field.getType());
    }

    public <ID extends Entity.Id<T>> EntityIdSchema<ID> getIdSchema() {
        return EntityIdSchema.from(this);
    }

    public List<Schema.JavaField> flattenId() {
        return this.getIdSchema().flattenFields();
    }

    public Map<String, Object> flattenId(Entity.Id<T> idValue) {
        return this.getIdSchema().flatten(idValue);
    }

    @Generated
    SchemaRegistry getRegistry() {
        return this.registry;
    }
}

