/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.db;

import lombok.NonNull;
import tech.ydb.yoj.databind.expression.FilterBuilder;
import tech.ydb.yoj.databind.expression.OrderBuilder;
import tech.ydb.yoj.databind.expression.OrderExpression;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.EntitySchema;

public final class EntityExpressions {
    private EntityExpressions() {
    }

    public static <T extends Entity<T>> FilterBuilder<T> newFilterBuilder(@NonNull Class<T> entityType) {
        if (entityType == null) {
            throw new NullPointerException("entityType is marked non-null but is null");
        }
        return FilterBuilder.forSchema(EntityExpressions.schema(entityType));
    }

    public static <T extends Entity<T>> OrderBuilder<T> newOrderBuilder(@NonNull Class<T> entityType) {
        if (entityType == null) {
            throw new NullPointerException("entityType is marked non-null but is null");
        }
        return OrderBuilder.forSchema(EntityExpressions.schema(entityType));
    }

    private static <T extends Entity<T>> EntitySchema<T> schema(@NonNull Class<T> entityType) {
        if (entityType == null) {
            throw new NullPointerException("entityType is marked non-null but is null");
        }
        return EntitySchema.of(entityType);
    }

    public static <T extends Entity<T>> OrderExpression<T> defaultOrder(@NonNull Class<T> entityType) {
        if (entityType == null) {
            throw new NullPointerException("entityType is marked non-null but is null");
        }
        return EntityExpressions.orderById(entityType, OrderExpression.SortOrder.ASCENDING);
    }

    public static <T extends Entity<T>> OrderExpression<T> orderById(Class<T> entityType, OrderExpression.SortOrder sortOrder) {
        return EntityExpressions.newOrderBuilder(entityType).orderBy(new OrderExpression.SortKey(EntityExpressions.schema(entityType).getField("id"), sortOrder)).build();
    }
}

