/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.db;

import java.beans.ConstructorProperties;
import java.time.Duration;
import java.util.function.Supplier;
import lombok.Generated;
import lombok.NonNull;
import tech.ydb.yoj.repository.db.IsolationLevel;
import tech.ydb.yoj.repository.db.TxManager;
import tech.ydb.yoj.repository.db.TxManagerState;
import tech.ydb.yoj.repository.db.cache.TransactionLog;
import tech.ydb.yoj.repository.db.exception.RetryableException;

public abstract class DelegatingTxManager
implements TxManager {
    protected final TxManager delegate;

    protected DelegatingTxManager(@NonNull TxManager delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate is marked non-null but is null");
        }
        this.delegate = delegate;
    }

    protected <T> T doRunTx(Supplier<T> supplier) {
        return supplier.get();
    }

    protected <T> Supplier<T> wrapTxBody(Supplier<T> supplier) {
        return supplier;
    }

    protected abstract TxManager createTxManager(TxManager var1);

    @Override
    public final void tx(Runnable runnable) {
        this.tx(() -> {
            runnable.run();
            return null;
        });
    }

    @Override
    public final <T> T tx(Supplier<T> supplier) {
        return (T)this.doRunTx(() -> this.delegate.tx(this.wrapTxBody(supplier)));
    }

    @Override
    public final TxManager withName(String name, String logContext) {
        return this.createTxManager(this.delegate.withName(name, logContext));
    }

    @Override
    public final TxManager withName(String name) {
        return this.createTxManager(this.delegate.withName(name));
    }

    @Override
    public final TxManager withLogContext(String logContext) {
        return this.createTxManager(this.delegate.withLogContext(logContext));
    }

    @Override
    public final TxManager separate() {
        return this.createTxManager(this.delegate.separate());
    }

    @Override
    public TxManager delayedWrites() {
        return this.createTxManager(this.delegate.delayedWrites());
    }

    @Override
    public final TxManager immediateWrites() {
        return this.createTxManager(this.delegate.immediateWrites());
    }

    @Override
    public final TxManager noFirstLevelCache() {
        return this.createTxManager(this.delegate.noFirstLevelCache());
    }

    @Override
    public final TxManager failOnUnknownSeparateTx() {
        return this.createTxManager(this.delegate.failOnUnknownSeparateTx());
    }

    @Override
    public final TxManager withMaxRetries(int maxRetries) {
        return this.createTxManager(this.delegate.withMaxRetries(maxRetries));
    }

    @Override
    public final TxManager withDryRun(boolean dryRun) {
        return this.createTxManager(this.delegate.withDryRun(dryRun));
    }

    @Override
    public final TxManager withLogLevel(TransactionLog.Level level) {
        return this.createTxManager(this.delegate.withLogLevel(level));
    }

    @Override
    public TxManager withLogStatementOnSuccess(boolean logStatementOnSuccess) {
        return this.createTxManager(this.delegate.withLogStatementOnSuccess(logStatementOnSuccess));
    }

    @Override
    public final TxManager withTimeout(Duration timeout) {
        return this.createTxManager(this.delegate.withTimeout(timeout));
    }

    @Override
    public final TxManager withVerboseLogging() {
        return this.createTxManager(this.delegate.withVerboseLogging());
    }

    @Override
    public final TxManager withBriefLogging() {
        return this.createTxManager(this.delegate.withBriefLogging());
    }

    @Override
    public final TxManager noLogging() {
        return this.createTxManager(this.delegate.noLogging());
    }

    @Override
    public final TxManager.ReadonlyBuilder readOnly() {
        return new ReadonlyBuilderImpl(this.delegate.readOnly());
    }

    @Override
    public final TxManager.ScanBuilder scan() {
        return new ScanBuilderImpl(this.delegate.scan());
    }

    @Override
    public final TxManagerState getState() {
        return this.delegate.getState();
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "[" + this.delegate + "]";
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    protected final Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private final class ReadonlyBuilderImpl
    implements TxManager.ReadonlyBuilder {
        private final TxManager.ReadonlyBuilder delegate;

        @Override
        public TxManager.ReadonlyBuilder withStatementIsolationLevel(IsolationLevel isolationLevel) {
            return new ReadonlyBuilderImpl(this.delegate.withStatementIsolationLevel(isolationLevel));
        }

        @Override
        public TxManager.ReadonlyBuilder withFirstLevelCache(boolean firstLevelCache) {
            return new ReadonlyBuilderImpl(this.delegate.withFirstLevelCache(firstLevelCache));
        }

        @Override
        public <T> T run(Supplier<T> supplier) throws RetryableException {
            return (T)DelegatingTxManager.this.doRunTx(() -> this.delegate.run(DelegatingTxManager.this.wrapTxBody(supplier)));
        }

        @ConstructorProperties(value={"delegate"})
        @Generated
        private ReadonlyBuilderImpl(TxManager.ReadonlyBuilder delegate) {
            this.delegate = delegate;
        }
    }

    private final class ScanBuilderImpl
    implements TxManager.ScanBuilder {
        private final TxManager.ScanBuilder delegate;

        @Override
        public TxManager.ScanBuilder withMaxSize(long maxSize) {
            return new ScanBuilderImpl(this.delegate.withMaxSize(maxSize));
        }

        @Override
        public TxManager.ScanBuilder withTimeout(Duration timeout) {
            return new ScanBuilderImpl(this.delegate.withTimeout(timeout));
        }

        @Override
        public <T> T run(Supplier<T> supplier) throws RetryableException {
            return (T)DelegatingTxManager.this.doRunTx(() -> this.delegate.run(DelegatingTxManager.this.wrapTxBody(supplier)));
        }

        @ConstructorProperties(value={"delegate"})
        @Generated
        private ScanBuilderImpl(TxManager.ScanBuilder delegate) {
            this.delegate = delegate;
        }
    }
}

