/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.db.list;

import java.beans.ConstructorProperties;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import tech.ydb.yoj.databind.schema.Schema;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.list.ListRequest;

public abstract class GenericListResult<T, R>
implements Iterable<R> {
    @NonNull
    private final List<R> entries;
    @NonNull
    private final Schema<R> resultSchema;
    private final boolean lastPage;
    @NonNull
    private final ListRequest<T> request;

    @Override
    @NonNull
    public final Iterator<R> iterator() {
        return this.entries.iterator();
    }

    @Override
    public final void forEach(@NonNull Consumer<? super R> action) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        this.entries.forEach(action);
    }

    @Override
    @NonNull
    public final Spliterator<R> spliterator() {
        return this.entries.spliterator();
    }

    @NonNull
    public final Stream<R> stream() {
        return this.entries.stream();
    }

    public final int size() {
        return this.entries.size();
    }

    public final boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public final R first() {
        if (this.entries.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.entries.get(0);
    }

    public final R last() {
        if (this.entries.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.entries.get(this.entries.size() - 1);
    }

    @NonNull
    public ListRequest.ListingParams<T> getParams() {
        return this.request.getParams();
    }

    @NonNull
    public Schema<T> getRequestSchema() {
        return this.request.getSchema();
    }

    @NonNull
    @Generated
    public List<R> getEntries() {
        return this.entries;
    }

    @NonNull
    @Generated
    public Schema<R> getResultSchema() {
        return this.resultSchema;
    }

    @Generated
    public boolean isLastPage() {
        return this.lastPage;
    }

    @NonNull
    @Generated
    public ListRequest<T> getRequest() {
        return this.request;
    }

    @ConstructorProperties(value={"entries", "resultSchema", "lastPage", "request"})
    @Generated
    protected GenericListResult(@NonNull List<R> entries, @NonNull Schema<R> resultSchema, boolean lastPage, @NonNull ListRequest<T> request) {
        if (entries == null) {
            throw new NullPointerException("entries is marked non-null but is null");
        }
        if (resultSchema == null) {
            throw new NullPointerException("resultSchema is marked non-null but is null");
        }
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        this.entries = entries;
        this.resultSchema = resultSchema;
        this.lastPage = lastPage;
        this.request = request;
    }

    public static abstract class Builder<T extends Entity<T>, R, Target> {
        protected List<R> entries;
        protected boolean lastPage;
        protected final ListRequest<T> request;

        Builder(ListRequest<T> request) {
            this.request = request;
        }

        @NonNull
        public Builder<T, R, Target> entries(@NonNull List<R> entries) {
            if (entries == null) {
                throw new NullPointerException("entries is marked non-null but is null");
            }
            this.entries = entries;
            return this;
        }

        @NonNull
        public Builder<T, R, Target> lastPage(boolean lastPage) {
            this.lastPage = lastPage;
            return this;
        }

        @NonNull
        public abstract Target build();

        @NonNull
        public String toString() {
            return "Builder(entries=" + this.entries + ", lastPage=" + this.lastPage + ", request=" + this.request + ")";
        }
    }
}

