/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.db.cache;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;

public final class TransactionLog {
    private final Level logLevel;
    private final List<String> messages = new ArrayList<String>();

    public void debug(String message) {
        this.log(Level.DEBUG, message);
    }

    public void info(String message) {
        this.log(Level.INFO, message);
    }

    public void debug(String message, Object ... args) {
        this.log(Level.DEBUG, message, args);
    }

    public void info(String message, Object ... args) {
        this.log(Level.INFO, message, args);
    }

    private void log(Level level, String message, Object ... args) {
        if (this.logLevel.acceptsMessageAt(level)) {
            this.log0(args.length == 0 ? message : String.format(message, args));
        }
    }

    private void log(Level level, String message) {
        if (this.logLevel.acceptsMessageAt(level)) {
            this.log0(message);
        }
    }

    private void log0(String message) {
        this.messages.add(message);
    }

    public String format(String prefix) {
        return this.messages.stream().map(l -> "\n  " + prefix + l).collect(Collectors.joining());
    }

    @ConstructorProperties(value={"logLevel"})
    @Generated
    public TransactionLog(Level logLevel) {
        this.logLevel = logLevel;
    }

    public static enum Level {
        DEBUG,
        INFO,
        OFF;


        public boolean acceptsMessageAt(Level level) {
            return this.compareTo(level) <= 0;
        }
    }
}

