/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.db;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import lombok.NonNull;
import tech.ydb.yoj.databind.FieldValueType;
import tech.ydb.yoj.databind.schema.Schema;
import tech.ydb.yoj.databind.schema.configuration.SchemaRegistry;
import tech.ydb.yoj.databind.schema.naming.NamingStrategy;
import tech.ydb.yoj.databind.schema.reflect.ReflectField;
import tech.ydb.yoj.repository.db.Entity;
import tech.ydb.yoj.repository.db.EntitySchema;

public final class EntityIdSchema<ID extends Entity.Id<?>>
extends Schema<ID>
implements Comparator<ID> {
    public static final String ID_FIELD_NAME = "id";
    private static final String ID_SUBFIELD_PATH_PREFIX = "id.";
    private static final String ID_SUBFIELD_NAME_PREFIX = "id_";
    public static final Comparator<Entity<?>> SORT_ENTITY_BY_ID = Comparator.comparing(Entity::getId, (a, b) -> EntityIdSchema.ofEntity(a.getType()).compare(a, b));
    private static final Type ENTITY_TYPE_PARAMETER = Entity.Id.class.getTypeParameters()[0];
    private static final Set<FieldValueType> ALLOWED_ID_FIELD_TYPES = Set.of(FieldValueType.STRING, FieldValueType.INTEGER, FieldValueType.ENUM, FieldValueType.BOOLEAN, FieldValueType.TIMESTAMP);

    public static <T extends Entity<T>> Comparator<Entity.Id<T>> getIdComparator(Class<T> type) {
        return Comparator.comparing(id -> id, (a, b) -> EntityIdSchema.ofEntity(type).compare(a, b));
    }

    private <E extends Entity<E>> EntityIdSchema(EntitySchema<E> entitySchema) {
        super(entitySchema, ID_FIELD_NAME);
        this.flattenFields().stream().filter(f -> !ALLOWED_ID_FIELD_TYPES.contains(FieldValueType.forJavaType((Type)f.getType()))).findAny().ifPresent(f -> {
            throw new IllegalArgumentException(String.format("Leaf ID field \"[%s].%s\" <java=%s, db=%s> is none of the allowed types %s", this.getType().getName(), f.getName(), f.getType(), FieldValueType.forJavaType((Type)f.getType()), ALLOWED_ID_FIELD_TYPES));
        });
    }

    protected boolean isFlattenable(ReflectField field) {
        return true;
    }

    public static <T extends Entity<T>, ID extends Entity.Id<T>> EntityIdSchema<ID> ofEntity(Class<T> entityType) {
        return EntityIdSchema.ofEntity(entityType, null);
    }

    public static <T extends Entity<T>, ID extends Entity.Id<T>> EntityIdSchema<ID> ofEntity(Class<T> entityType, NamingStrategy namingStrategy) {
        return EntityIdSchema.ofEntity(SchemaRegistry.getDefault(), entityType, namingStrategy);
    }

    public static <T extends Entity<T>, ID extends Entity.Id<T>> EntityIdSchema<ID> ofEntity(SchemaRegistry registry, Class<T> entityType, NamingStrategy namingStrategy) {
        EntitySchema<T> entitySchema = EntitySchema.of(registry, entityType, namingStrategy);
        return EntityIdSchema.from(entitySchema);
    }

    public static <T extends Entity<T>, ID extends Entity.Id<T>> EntityIdSchema<ID> of(Class<ID> idType) {
        return EntityIdSchema.of(idType, null);
    }

    public static <T extends Entity<T>, ID extends Entity.Id<T>> EntityIdSchema<ID> of(Class<ID> idType, NamingStrategy namingStrategy) {
        return EntityIdSchema.of(SchemaRegistry.getDefault(), idType, namingStrategy);
    }

    public static <T extends Entity<T>, ID extends Entity.Id<T>> EntityIdSchema<ID> of(SchemaRegistry registry, Class<ID> idType) {
        return EntityIdSchema.of(registry, idType, null);
    }

    public static <T extends Entity<T>, ID extends Entity.Id<T>> EntityIdSchema<ID> of(SchemaRegistry registry, Class<ID> idType, NamingStrategy namingStrategy) {
        Class<ID> entityType = EntityIdSchema.resolveEntityType(idType);
        EntitySchema<ID> entitySchema = EntitySchema.of(registry, entityType, namingStrategy);
        return EntityIdSchema.from(entitySchema);
    }

    public static <T extends Entity<T>, ID extends Entity.Id<T>> EntityIdSchema<ID> from(EntitySchema<T> entitySchema) {
        SchemaRegistry.SchemaKey key = SchemaRegistry.SchemaKey.of((Class)entitySchema.getType(), (NamingStrategy)entitySchema.getNamingStrategy());
        return (EntityIdSchema)entitySchema.getRegistry().getOrCreate(EntityIdSchema.class, (k, r) -> new EntityIdSchema(entitySchema), key);
    }

    static Class<?> resolveEntityType(Class<?> idType) {
        return TypeToken.of(idType).resolveType(ENTITY_TYPE_PARAMETER).getRawType();
    }

    public static boolean isIdField(@NonNull Schema.JavaField field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        return EntityIdSchema.isIdFieldPath(field.getPath());
    }

    public static boolean isIdFieldPath(@NonNull String path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return path.equals(ID_FIELD_NAME) || path.startsWith(ID_SUBFIELD_PATH_PREFIX);
    }

    public static boolean isIdFieldName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return name.equals(ID_FIELD_NAME) || name.startsWith(ID_SUBFIELD_NAME_PREFIX);
    }

    @Override
    public int compare(@NonNull ID a, @NonNull ID b) {
        if (a == null) {
            throw new NullPointerException("a is marked non-null but is null");
        }
        if (b == null) {
            throw new NullPointerException("b is marked non-null but is null");
        }
        Map idA = this.flatten(a);
        Map idB = this.flatten(b);
        for (String fieldName : this.flattenFieldNames()) {
            int res = EntityIdSchema.compare(EntityIdSchema.toComparable(idA.get(fieldName)), EntityIdSchema.toComparable(idB.get(fieldName)));
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    @Nullable
    private static Comparable toComparable(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Enum) {
            return ((Enum)value).name();
        }
        if (value instanceof Comparable) {
            return (Comparable)value;
        }
        if (value instanceof Number) {
            return Long.valueOf(((Number)value).longValue());
        }
        throw new IllegalArgumentException("ID fields must implement Comparable");
    }

    private static <E extends Comparable<? super E>> int compare(@Nullable E a, @Nullable E b) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        return a.compareTo(b);
    }
}

