/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.db;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.CheckForNull;
import lombok.NonNull;
import tech.ydb.yoj.repository.db.EntityIdSchema;
import tech.ydb.yoj.repository.db.EntitySchema;
import tech.ydb.yoj.repository.db.Table;
import tech.ydb.yoj.repository.db.Tx;

public interface Entity<E extends Entity<E>>
extends Table.ViewId<E> {
    @Override
    public Id<E> getId();

    default public E postLoad() {
        return (E)this;
    }

    default public E preSave() {
        return (E)this;
    }

    default public List<Entity<?>> createProjections() {
        return List.of();
    }

    public static interface Id<E extends Entity<E>> {
        @CheckForNull
        @Deprecated
        default public E resolve() {
            return Tx.Current.get().getRepositoryTransaction().table(this.getType()).find(this);
        }

        @Deprecated
        @NonNull
        default public <EXCEPTION extends Exception> E resolve(Supplier<? extends EXCEPTION> throwIfAbsent) throws EXCEPTION {
            return Tx.Current.get().getRepositoryTransaction().table(this.getType()).find(this, throwIfAbsent);
        }

        default public Class<E> getType() {
            return new TypeToken<E>(this.getClass()){}.getRawType();
        }

        default public boolean isPartial() {
            EntityIdSchema schema = EntitySchema.of(this.getType()).getIdSchema();
            List columns = schema.flattenFields();
            Map nonNullFields = schema.flatten(this);
            return columns.size() > nonNullFields.size();
        }
    }
}

