/*
 * Decompiled with CFR 0.152.
 */
package tech.ydb.yoj.repository.ydb.yql;

import com.google.common.primitives.Primitives;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.UnsafeByteOperations;
import java.beans.ConstructorProperties;
import java.lang.reflect.Type;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.ydb.proto.ValueProtos;
import tech.ydb.table.values.proto.ProtoValue;
import tech.ydb.yoj.DeprecationWarnings;
import tech.ydb.yoj.databind.ByteArray;
import tech.ydb.yoj.databind.CustomValueTypes;
import tech.ydb.yoj.databind.DbType;
import tech.ydb.yoj.databind.FieldValueType;
import tech.ydb.yoj.databind.schema.CustomValueTypeInfo;
import tech.ydb.yoj.databind.schema.Schema;
import tech.ydb.yoj.repository.db.common.CommonConverters;
import tech.ydb.yoj.repository.db.exception.ConversionException;
import tech.ydb.yoj.repository.ydb.yql.YqlType;
import tech.ydb.yoj.util.lang.BetterCollectors;

public final class YqlPrimitiveType
implements YqlType {
    private static final Logger log = LoggerFactory.getLogger(YqlPrimitiveType.class);
    private static volatile boolean typeMappingExplicitlySet = false;
    private static final Map<ValueProtos.Type.PrimitiveTypeId, String> YQL_TYPE_NAMES = Map.ofEntries(Map.entry(ValueProtos.Type.PrimitiveTypeId.BOOL, "Bool"), Map.entry(ValueProtos.Type.PrimitiveTypeId.UINT8, "Uint8"), Map.entry(ValueProtos.Type.PrimitiveTypeId.INT32, "Int32"), Map.entry(ValueProtos.Type.PrimitiveTypeId.UINT32, "Uint32"), Map.entry(ValueProtos.Type.PrimitiveTypeId.INT64, "Int64"), Map.entry(ValueProtos.Type.PrimitiveTypeId.UINT64, "Uint64"), Map.entry(ValueProtos.Type.PrimitiveTypeId.FLOAT, "Float"), Map.entry(ValueProtos.Type.PrimitiveTypeId.DOUBLE, "Double"), Map.entry(ValueProtos.Type.PrimitiveTypeId.DATE, "Date"), Map.entry(ValueProtos.Type.PrimitiveTypeId.DATETIME, "Datetime"), Map.entry(ValueProtos.Type.PrimitiveTypeId.TIMESTAMP, "Timestamp"), Map.entry(ValueProtos.Type.PrimitiveTypeId.INTERVAL, "Interval"), Map.entry(ValueProtos.Type.PrimitiveTypeId.STRING, "String"), Map.entry(ValueProtos.Type.PrimitiveTypeId.UTF8, "Utf8"), Map.entry(ValueProtos.Type.PrimitiveTypeId.JSON, "Json"), Map.entry(ValueProtos.Type.PrimitiveTypeId.JSON_DOCUMENT, "JsonDocument"));
    private static final Setter BOOL_SETTER = (b, v) -> b.setBoolValue(((Boolean)v).booleanValue());
    private static final Setter BYTE_SETTER = (b, v) -> b.setInt32Value((int)((Number)v).byteValue());
    private static final Setter BYTE_UINT_SETTER = (b, v) -> b.setUint32Value((int)((Number)v).byteValue());
    private static final Setter SHORT_SETTER = (b, v) -> b.setInt32Value((int)((Number)v).shortValue());
    private static final Setter INT_SETTER = (b, v) -> b.setInt32Value(((Number)v).intValue());
    private static final Setter UINT_SETTER = (b, v) -> b.setUint32Value(((Number)v).intValue());
    private static final Setter LONG_SETTER = (b, v) -> b.setInt64Value(((Number)v).longValue());
    private static final Setter ULONG_SETTER = (b, v) -> b.setUint64Value(((Number)v).longValue());
    private static final Setter FLOAT_SETTER = (b, v) -> b.setFloatValue(((Number)v).floatValue());
    private static final Setter DOUBLE_SETTER = (b, v) -> b.setDoubleValue(((Number)v).doubleValue());
    private static final Setter STRING_SETTER = (b, v) -> b.setBytesValue(ByteString.copyFromUtf8((String)((String)v)));
    private static final Setter TEXT_SETTER = (b, v) -> b.setTextValue((String)v);
    private static final Setter BYTES_SETTER = (b, v) -> b.setBytesValue(UnsafeByteOperations.unsafeWrap((byte[])((byte[])v)));
    private static final Setter BYTE_ARRAY_SETTER = (b, v) -> b.setBytesValue(UnsafeByteOperations.unsafeWrap((byte[])((ByteArray)v).getArray()));
    private static final Setter INSTANT_SETTER = (b, v) -> b.setInt64Value(((Instant)v).toEpochMilli());
    private static final Setter INSTANT_UINT_SETTER = (b, v) -> b.setUint64Value(((Instant)v).toEpochMilli());
    private static final Setter INSTANT_SECOND_SETTER = (b, v) -> b.setInt64Value(((Instant)v).getEpochSecond());
    private static final Setter INSTANT_UINT_SECOND_SETTER = (b, v) -> b.setUint64Value(((Instant)v).getEpochSecond());
    private static final Setter TIMESTAMP_SETTER = (b, v) -> b.setUint64Value(ProtoValue.fromTimestamp((Instant)((Instant)v)).getUint64Value());
    private static final Setter TIMESTAMP_SECONDS_SETTER = (b, v) -> b.setUint64Value(ProtoValue.fromTimestamp((Instant)((Instant)v).truncatedTo(ChronoUnit.SECONDS)).getUint64Value());
    private static final Setter TIMESTAMP_MILLI_SETTER = (b, v) -> b.setUint64Value(ProtoValue.fromTimestamp((Instant)((Instant)v).truncatedTo(ChronoUnit.MILLIS)).getUint64Value());
    private static final Setter DURATION_SETTER = (b, v) -> b.setInt64Value(ProtoValue.fromInterval((Duration)((Duration)v)).getInt64Value());
    private static final Setter DURATION_UINT_SETTER = (b, v) -> b.setUint64Value(ProtoValue.fromInterval((Duration)((Duration)v)).getInt64Value());
    private static final Setter DURATION_MILLI_SETTER = (b, v) -> b.setInt64Value(((Duration)v).toMillis());
    private static final Setter DURATION_MILLI_UINT_SETTER = (b, v) -> b.setUint64Value(((Duration)v).toMillis());
    private static final Setter DURATION_SECOND_SETTER = (b, v) -> b.setInt32Value(Math.toIntExact(((Duration)v).toSeconds()));
    private static final Setter DURATION_SECOND_UINT_SETTER = (b, v) -> b.setUint32Value(Math.toIntExact(((Duration)v).toSeconds()));
    private static final Setter DURATION_UTF8_SETTER = (b, v) -> b.setTextValue(((Duration)v).truncatedTo(ChronoUnit.MICROS).toString());
    private static final Setter UUID_STRING_SETTER = (arg_0, arg_1) -> ((CommonConverters.ThrowingSetter)CommonConverters.uuidValueSetter((BiConsumer)STRING_SETTER)).accept(arg_0, arg_1);
    private static final Setter UUID_UTF8_SETTER = (arg_0, arg_1) -> ((CommonConverters.ThrowingSetter)CommonConverters.uuidValueSetter((BiConsumer)TEXT_SETTER)).accept(arg_0, arg_1);
    private static final Function<Type, Setter> ENUM_NAME_STRING_SETTERS = type -> (arg_0, arg_1) -> ((CommonConverters.ThrowingSetter)CommonConverters.enumValueSetter((Type)type, (BiConsumer)STRING_SETTER)).accept(arg_0, arg_1);
    private static final Function<Type, Setter> ENUM_NAME_UTF8_SETTERS = type -> (arg_0, arg_1) -> ((CommonConverters.ThrowingSetter)CommonConverters.enumValueSetter((Type)type, (BiConsumer)TEXT_SETTER)).accept(arg_0, arg_1);
    private static final Function<Type, Setter> ENUM_TO_STRING_STRING_SETTERS = type -> (arg_0, arg_1) -> ((CommonConverters.ThrowingSetter)CommonConverters.enumToStringValueSetter((Type)type, (BiConsumer)STRING_SETTER)).accept(arg_0, arg_1);
    private static final Function<Type, Setter> ENUM_TO_STRING_UTF8_SETTERS = type -> (arg_0, arg_1) -> ((CommonConverters.ThrowingSetter)CommonConverters.enumToStringValueSetter((Type)type, (BiConsumer)TEXT_SETTER)).accept(arg_0, arg_1);
    private static final Function<Type, Setter> JSON_STRING_SETTERS = type -> (arg_0, arg_1) -> ((CommonConverters.ThrowingSetter)CommonConverters.opaqueObjectValueSetter((Type)type, (BiConsumer)STRING_SETTER)).accept(arg_0, arg_1);
    private static final Function<Type, Setter> JSON_UTF8_SETTERS = type -> (arg_0, arg_1) -> ((CommonConverters.ThrowingSetter)CommonConverters.opaqueObjectValueSetter((Type)type, (BiConsumer)TEXT_SETTER)).accept(arg_0, arg_1);
    private static final Function<Type, Setter> STRING_VALUE_STRING_SETTERS = type -> (d, v) -> STRING_SETTER.accept(d, v.toString());
    private static final Function<Type, Setter> STRING_VALUE_UTF8_SETTERS = type -> (d, v) -> TEXT_SETTER.accept(d, v.toString());
    private static final Getter BOOL_GETTER = ValueProtos.Value::getBoolValue;
    private static final Getter BYTE_GETTER = value -> (byte)value.getInt32Value();
    private static final Getter BYTE_UINT_GETTER = value -> (byte)value.getUint32Value();
    private static final Getter SHORT_GETTER = value -> (short)value.getInt32Value();
    private static final Getter INT_GETTER = ValueProtos.Value::getInt32Value;
    private static final Getter UINT_GETTER = ValueProtos.Value::getUint32Value;
    private static final Getter LONG_GETTER = ValueProtos.Value::getInt64Value;
    private static final Getter ULONG_GETTER = ValueProtos.Value::getUint64Value;
    private static final Getter U32LONG_GETTER = value -> Integer.toUnsignedLong(value.getUint32Value());
    private static final Getter FLOAT_GETTER = ValueProtos.Value::getFloatValue;
    private static final Getter DOUBLE_GETTER = ValueProtos.Value::getDoubleValue;
    private static final Getter STRING_GETTER = v -> v.getBytesValue().toStringUtf8();
    private static final Getter TEXT_GETTER = ValueProtos.Value::getTextValue;
    private static final Getter BYTES_GETTER = v -> v.getBytesValue().toByteArray();
    private static final Getter BYTE_ARRAY_GETTER = v -> ByteArray.wrap((byte[])v.getBytesValue().toByteArray());
    private static final Getter INSTANT_GETTER = v -> Instant.ofEpochMilli(v.getInt64Value());
    private static final Getter INSTANT_UINT_GETTER = v -> Instant.ofEpochMilli(v.getUint64Value());
    private static final Getter INSTANT_SECOND_GETTER = v -> Instant.ofEpochSecond(v.getInt64Value());
    private static final Getter INSTANT_UINT_SECOND_GETTER = v -> Instant.ofEpochSecond(v.getUint64Value());
    private static final Getter TIMESTAMP_GETTER = ProtoValue::toTimestamp;
    private static final Getter TIMESTAMP_SECONDS_GETTER = v -> ProtoValue.toTimestamp((ValueProtos.Value)v).truncatedTo(ChronoUnit.SECONDS);
    private static final Getter TIMESTAMP_MILLI_GETTER = v -> ProtoValue.toTimestamp((ValueProtos.Value)v).truncatedTo(ChronoUnit.MILLIS);
    private static final Getter DURATION_GETTER = ProtoValue::toInterval;
    private static final Getter DURATION_UINT_GETTER = v -> Duration.of(v.getUint64Value(), ChronoUnit.MICROS);
    private static final Getter DURATION_MILLI_GETTER = v -> Duration.ofMillis(v.getInt64Value());
    private static final Getter DURATION_MILLI_UINT_GETTER = v -> Duration.ofMillis(v.getUint64Value());
    private static final Getter DURATION_SECOND_GETTER = v -> Duration.ofSeconds(v.getInt32Value());
    private static final Getter DURATION_SECOND_UINT_GETTER = v -> Duration.ofSeconds(v.getUint32Value());
    private static final Getter DURATION_UTF8_GETTER = v -> Duration.parse(v.getTextValue());
    private static final Getter UUID_STRING_GETTER = arg_0 -> ((CommonConverters.ThrowingGetter)CommonConverters.uuidValueGetter((Function)STRING_GETTER)).apply(arg_0);
    private static final Getter UUID_UTF8_GETTER = arg_0 -> ((CommonConverters.ThrowingGetter)CommonConverters.uuidValueGetter((Function)TEXT_GETTER)).apply(arg_0);
    private static final Getter CONTAINER_VALUE_GETTER = new YdbContainerValueGetter();
    private static final Function<Type, Getter> ENUM_NAME_STRING_GETTERS = type -> arg_0 -> ((CommonConverters.ThrowingGetter)CommonConverters.enumValueGetter((Type)type, (Function)STRING_GETTER)).apply(arg_0);
    private static final Function<Type, Getter> ENUM_NAME_UTF8_GETTERS = type -> arg_0 -> ((CommonConverters.ThrowingGetter)CommonConverters.enumValueGetter((Type)type, (Function)TEXT_GETTER)).apply(arg_0);
    private static final Function<Type, Getter> ENUM_TO_STRING_STRING_GETTERS = type -> arg_0 -> ((CommonConverters.ThrowingGetter)CommonConverters.enumToStringValueGetter((Type)type, (Function)STRING_GETTER)).apply(arg_0);
    private static final Function<Type, Getter> ENUM_TO_STRING_UTF8_GETTERS = type -> arg_0 -> ((CommonConverters.ThrowingGetter)CommonConverters.enumToStringValueGetter((Type)type, (Function)TEXT_GETTER)).apply(arg_0);
    private static final Function<Type, Getter> JSON_STRING_GETTERS = type -> arg_0 -> ((CommonConverters.ThrowingGetter)CommonConverters.opaqueObjectValueGetter((Type)type, (Function)STRING_GETTER)).apply(arg_0);
    private static final Function<Type, Getter> JSON_UTF8_GETTERS = type -> arg_0 -> ((CommonConverters.ThrowingGetter)CommonConverters.opaqueObjectValueGetter((Type)type, (Function)TEXT_GETTER)).apply(arg_0);
    private static final Function<Type, Getter> STRING_VALUE_STRING_GETTERS = type -> STRING_GETTER;
    private static final Function<Type, Getter> STRING_VALUE_UTF8_GETTERS = type -> TEXT_GETTER;
    private static final Map<YqlTypeSelector, YqlPrimitiveType> YQL_TYPES = new ConcurrentHashMap<YqlTypeSelector, YqlPrimitiveType>();
    private static final Map<Type, YqlTypeSelector> JAVA_DEFAULT_YQL_TYPES = new HashMap<Type, YqlTypeSelector>();
    private static final Map<ValueYqlTypeSelector, JavaYqlTypeAccessors> JAVA_YQL_TYPE_ACCESSORS = new HashMap<ValueYqlTypeSelector, JavaYqlTypeAccessors>();
    private static final Map<FieldValueType, ValueYqlTypeSelector> VALUE_DEFAULT_YQL_TYPES = new HashMap<FieldValueType, ValueYqlTypeSelector>();
    private final Type javaType;
    private final ValueProtos.Type.PrimitiveTypeId yqlType;
    private final BiConsumer<ValueProtos.Value.Builder, Object> setter;
    private final Function<ValueProtos.Value, Object> getter;
    private static final Descriptors.FieldDescriptor ITEMS_FIELD;
    private static final Descriptors.FieldDescriptor PAIRS_FIELD;

    private static void checkSupportedYqlType(ValueProtos.Type.PrimitiveTypeId primitiveTypeId) {
        if (YQL_TYPE_NAMES.containsKey(primitiveTypeId)) {
            return;
        }
        throw new RuntimeException(String.format("Not supported YQL type: %s", primitiveTypeId));
    }

    private static ValueProtos.Type.PrimitiveTypeId convertToYqlType(String columnType) {
        try {
            return ValueProtos.Type.PrimitiveTypeId.valueOf((String)columnType);
        }
        catch (IllegalArgumentException e) {
            throw new ConversionException("Unknown column type: " + columnType);
        }
    }

    private static void registerYqlType(Type javaType, ValueProtos.Type.PrimitiveTypeId yqlType, String qualifier, boolean isDefault, Setter setter, Getter getter) {
        YqlPrimitiveType.checkSupportedYqlType(yqlType);
        YqlTypeSelector typeSelector = new YqlTypeSelector(javaType, yqlType, qualifier);
        YQL_TYPES.compute(typeSelector, (k, v) -> {
            if (v == null) {
                return new YqlPrimitiveType(javaType, yqlType, setter, getter);
            }
            throw new RuntimeException(String.format("YQL type %s is already registered!", k));
        });
        if (isDefault) {
            JAVA_DEFAULT_YQL_TYPES.compute(javaType, (k, v) -> {
                if (v == null) {
                    return typeSelector;
                }
                throw new RuntimeException(String.format("Default YQL type %s is already specified for Java type %s. Cannot be changed to %s!", v, javaType, typeSelector));
            });
        }
    }

    private static void registerPrimitiveTypes() {
        HashMap yqlTypes = new HashMap();
        YQL_TYPES.forEach((selector, yqlType) -> {
            Class primitiveType;
            YqlTypeSelector primitiveSelector;
            Type type = selector.getJavaType();
            if (type instanceof Class && Primitives.isWrapperType((Class)((Class)type)) && !YQL_TYPES.containsKey(primitiveSelector = selector.withJavaType(primitiveType = Primitives.unwrap((Class)((Class)type))))) {
                yqlTypes.put(selector.withJavaType(primitiveType), new YqlPrimitiveType(primitiveType, yqlType.getYqlType(), yqlType.getSetter(), yqlType.getGetter()));
            }
        });
        YQL_TYPES.putAll(yqlTypes);
        HashMap javaDefaultYqlTypes = new HashMap();
        JAVA_DEFAULT_YQL_TYPES.forEach((type, selector) -> {
            Class primitiveType;
            if (type instanceof Class && Primitives.isWrapperType((Class)((Class)type)) && !JAVA_DEFAULT_YQL_TYPES.containsKey(primitiveType = Primitives.unwrap((Class)((Class)type)))) {
                javaDefaultYqlTypes.put(primitiveType, selector.withJavaType(primitiveType));
            }
        });
        JAVA_DEFAULT_YQL_TYPES.putAll(javaDefaultYqlTypes);
    }

    private static void registerYqlType(FieldValueType valueType, ValueProtos.Type.PrimitiveTypeId yqlType, String qualifier, boolean isDefault, Function<Type, Setter> setters, Function<Type, Getter> getters) {
        YqlPrimitiveType.checkSupportedYqlType(yqlType);
        ValueYqlTypeSelector typeSelector = new ValueYqlTypeSelector(valueType, yqlType, qualifier);
        JAVA_YQL_TYPE_ACCESSORS.compute(typeSelector, (k, v) -> {
            if (v == null) {
                return new JavaYqlTypeAccessors(setters, getters);
            }
            throw new RuntimeException(String.format("YQL type %s is already registered!", k));
        });
        if (isDefault) {
            VALUE_DEFAULT_YQL_TYPES.compute(valueType, (k, v) -> {
                if (v == null) {
                    return typeSelector;
                }
                throw new RuntimeException(String.format("Default YQL type %s is already specified for value type %s. Cannot be changed to %s!", v, valueType, typeSelector));
            });
        }
    }

    @Deprecated(forRemoval=true)
    public static void changeStringDefaultTypeToUtf8() {
        DeprecationWarnings.warnOnce((String)"YqlPrimitiveType.changeStringDefaultTypeToUtf8()", (String)"You are using YqlPrimitiveType.changeStringDefaultTypeToUtf8() which will be removed in YOJ 3.0.0.Please use YqlPrimitiveType.useNewMappingFor(STRING, ENUM, UUID) if you wish to use to map Strings, Enums and UUIDs to `UTF8` (`TEXT`) YDB column type (i.e., UTF-8 encoded text).", (Object[])new Object[0]);
        YqlPrimitiveType.useRecommendedMappingFor(FieldValueType.STRING, FieldValueType.ENUM, FieldValueType.UUID);
    }

    @Deprecated(forRemoval=true)
    public static void resetStringDefaultTypeToDefaults() {
        DeprecationWarnings.warnOnce((String)"YqlPrimitiveType.resetStringDefaultTypeToDefaults()", (String)"You are using YqlPrimitiveType.resetStringDefaultTypeToDefaults() which will be removed in YOJ 3.0.0. Please use YqlPrimitiveType.useLegacyMappingFor(STRING, ENUM, UUID) if you wish to use to map Strings, Enums and UUIDs to `STRING` (`BYTES`) YDB column type (i.e., byte array).", (Object[])new Object[0]);
        YqlPrimitiveType.useLegacyMappingFor(FieldValueType.STRING, FieldValueType.ENUM, FieldValueType.UUID);
    }

    @Deprecated
    public static void useLegacyMappingFor(FieldValueType ... fieldValueTypes) {
        typeMappingExplicitlySet = true;
        block5: for (FieldValueType fvt : fieldValueTypes) {
            switch (fvt) {
                case STRING: 
                case ENUM: {
                    VALUE_DEFAULT_YQL_TYPES.put(fvt, new ValueYqlTypeSelector(fvt, ValueProtos.Type.PrimitiveTypeId.STRING, null));
                    continue block5;
                }
                case UUID: {
                    YqlTypeSelector selector = new YqlTypeSelector((Type)((Object)Instant.class), ValueProtos.Type.PrimitiveTypeId.STRING, null);
                    JAVA_DEFAULT_YQL_TYPES.put((Type)((Object)UUID.class), selector);
                    YQL_TYPES.put(selector, new YqlPrimitiveType((Type)((Object)UUID.class), ValueProtos.Type.PrimitiveTypeId.STRING, UUID_STRING_SETTER, UUID_STRING_GETTER));
                    continue block5;
                }
                case TIMESTAMP: {
                    YqlTypeSelector selector = new YqlTypeSelector((Type)((Object)Instant.class), ValueProtos.Type.PrimitiveTypeId.INT64, null);
                    JAVA_DEFAULT_YQL_TYPES.put((Type)((Object)Instant.class), selector);
                    YQL_TYPES.put(selector, new YqlPrimitiveType((Type)((Object)Instant.class), ValueProtos.Type.PrimitiveTypeId.INT64, INSTANT_SETTER, INSTANT_GETTER));
                }
            }
        }
    }

    public static void useRecommendedMappingFor(FieldValueType ... fieldValueTypes) {
        typeMappingExplicitlySet = true;
        block5: for (FieldValueType fvt : fieldValueTypes) {
            switch (fvt) {
                case STRING: 
                case ENUM: {
                    VALUE_DEFAULT_YQL_TYPES.put(fvt, new ValueYqlTypeSelector(fvt, ValueProtos.Type.PrimitiveTypeId.UTF8, null));
                    continue block5;
                }
                case UUID: {
                    YqlTypeSelector selector = new YqlTypeSelector((Type)((Object)Instant.class), ValueProtos.Type.PrimitiveTypeId.UTF8, null);
                    JAVA_DEFAULT_YQL_TYPES.put((Type)((Object)UUID.class), selector);
                    YQL_TYPES.put(selector, new YqlPrimitiveType((Type)((Object)UUID.class), ValueProtos.Type.PrimitiveTypeId.UTF8, UUID_UTF8_SETTER, UUID_UTF8_GETTER));
                    continue block5;
                }
                case TIMESTAMP: {
                    YqlTypeSelector selector = new YqlTypeSelector((Type)((Object)Instant.class), ValueProtos.Type.PrimitiveTypeId.TIMESTAMP, null);
                    JAVA_DEFAULT_YQL_TYPES.put((Type)((Object)Instant.class), selector);
                    YQL_TYPES.put(selector, new YqlPrimitiveType((Type)((Object)Instant.class), ValueProtos.Type.PrimitiveTypeId.TIMESTAMP, TIMESTAMP_SETTER, TIMESTAMP_GETTER));
                }
            }
        }
    }

    @Deprecated(forRemoval=true)
    @NonNull
    public static YqlPrimitiveType of(Type javaType) {
        DeprecationWarnings.warnOnce((String)"YqlPrimitiveType.of(Type)", (String)"You are using YqlPrimitiveType.of(Type) which will be removed in YOJ 3.0.0. Please use YqlPrimitiveType.of(JavaField) instead", (Object[])new Object[0]);
        FieldValueType valueType = FieldValueType.forJavaType((Type)javaType, null, null);
        return YqlPrimitiveType.resolveYqlType(javaType, valueType, null, null);
    }

    @NonNull
    public static YqlPrimitiveType of(Schema.JavaField column) {
        ValueProtos.Type.PrimitiveTypeId yqlType = null;
        if (column.getDbType() != DbType.DEFAULT) {
            yqlType = YqlPrimitiveType.convertToYqlType(column.getDbType().typeString());
        }
        Type javaType = column.getType();
        FieldValueType valueType = column.getValueType();
        String qualifier = column.getDbTypeQualifier();
        CustomValueTypeInfo cvt = column.getCustomValueTypeInfo();
        YqlPrimitiveType underlyingType = YqlPrimitiveType.resolveYqlType(cvt != null ? cvt.getColumnClass() : javaType, valueType, yqlType, qualifier);
        if (cvt == null) {
            return underlyingType;
        }
        return new YqlPrimitiveType(javaType, underlyingType.yqlType, (b, o) -> underlyingType.setter.accept((ValueProtos.Value.Builder)b, CustomValueTypes.preconvert((Schema.JavaField)column, (Object)o)), v -> CustomValueTypes.postconvert((Schema.JavaField)column, (Object)underlyingType.getter.apply((ValueProtos.Value)v)));
    }

    @NonNull
    private static YqlPrimitiveType resolveYqlType(Type javaType, FieldValueType valueType, ValueProtos.Type.PrimitiveTypeId yqlType, String qualifier) {
        YqlTypeSelector typeSelector;
        if (!typeMappingExplicitlySet) {
            typeMappingExplicitlySet = true;
            log.error("YOJ's Java<->YDB type mapping IS NOT specified explicitly! See https://github.com/ydb-platform/yoj-project/issues/20#issuecomment-1971661677");
        }
        switch (valueType) {
            case STRING: 
            case ENUM: 
            case OBJECT: {
                YqlTypeSelector typeSelector2;
                ValueYqlTypeSelector defaultSelector = VALUE_DEFAULT_YQL_TYPES.get(valueType);
                if (yqlType == null) {
                    if (defaultSelector == null) {
                        throw new ConversionException("Unsupported value type: " + String.valueOf(valueType));
                    }
                    typeSelector2 = new YqlTypeSelector(javaType, defaultSelector.getYqlType(), qualifier == null ? defaultSelector.getQualifier() : qualifier);
                } else {
                    typeSelector2 = new YqlTypeSelector(javaType, yqlType, qualifier);
                }
                return YQL_TYPES.computeIfAbsent(typeSelector2, k -> {
                    ValueYqlTypeSelector valueTypeSelector = new ValueYqlTypeSelector(valueType, typeSelector2.getYqlType(), typeSelector2.getQualifier());
                    JavaYqlTypeAccessors typeAccessors = JAVA_YQL_TYPE_ACCESSORS.get(valueTypeSelector);
                    if (typeAccessors == null && qualifier == null && defaultSelector != null && defaultSelector.getQualifier() != null) {
                        typeAccessors = JAVA_YQL_TYPE_ACCESSORS.get(valueTypeSelector.withQualifier(defaultSelector.getQualifier()));
                    }
                    if (typeAccessors == null) {
                        throw new ConversionException("Unsupported column type: " + String.valueOf(typeSelector2));
                    }
                    Setter setter = typeAccessors.getSetters().apply(javaType);
                    Getter getter = typeAccessors.getGetters().apply(javaType);
                    return new YqlPrimitiveType(javaType, typeSelector2.getYqlType(), setter, getter);
                });
            }
            case COMPOSITE: {
                throw new ConversionException("Tried to call YqlType.of() with a composite value of type " + String.valueOf(javaType));
            }
        }
        YqlTypeSelector defaultTypeSelector = JAVA_DEFAULT_YQL_TYPES.get(javaType);
        if (yqlType == null) {
            if (defaultTypeSelector == null) {
                throw new ConversionException("Unsupported Java type: " + String.valueOf(javaType));
            }
            typeSelector = qualifier == null ? defaultTypeSelector : defaultTypeSelector.withQualifier(qualifier);
        } else {
            typeSelector = new YqlTypeSelector(javaType, yqlType, qualifier);
        }
        YqlPrimitiveType type = YQL_TYPES.get(typeSelector);
        if (type == null && qualifier == null && defaultTypeSelector != null && defaultTypeSelector.getQualifier() != null) {
            type = YQL_TYPES.get(typeSelector.withQualifier(defaultTypeSelector.getQualifier()));
        }
        if (type == null) {
            throw new ConversionException("Unsupported column type: " + String.valueOf(typeSelector));
        }
        return type;
    }

    @Override
    public String getYqlTypeName() {
        return YQL_TYPE_NAMES.get(this.yqlType);
    }

    @Override
    public ValueProtos.Type.Builder getYqlTypeBuilder() {
        return ValueProtos.Type.newBuilder().setTypeId(this.yqlType);
    }

    @Override
    public ValueProtos.Value.Builder toYql(Object value) {
        ValueProtos.Value.Builder builder = ValueProtos.Value.newBuilder();
        try {
            this.setter.accept(builder, value);
        }
        catch (Exception e) {
            throw new ConversionException(String.format("Could not convert Java value of type \"%s\" to YDB value of type \"%s\": %s", this.javaType.getTypeName(), this.getYqlTypeName(), value), (Throwable)e);
        }
        return builder;
    }

    private static Descriptors.FieldDescriptor getValueDescriptor(String name) {
        return ValueProtos.Value.getDescriptor().findFieldByName(name);
    }

    @Override
    public Object fromYql(ValueProtos.Value value) {
        if (value.getValueCase() == ValueProtos.Value.ValueCase.NULL_FLAG_VALUE) {
            return null;
        }
        boolean hasList = value.getRepeatedFieldCount(ITEMS_FIELD) > 0;
        boolean hasDict = value.getRepeatedFieldCount(PAIRS_FIELD) > 0;
        boolean hasContainer = hasList || hasDict;
        boolean hasPrimitiveValue = value.getValueCase() != ValueProtos.Value.ValueCase.VALUE_NOT_SET;
        try {
            if (!hasPrimitiveValue) {
                return CommonConverters.fromObject((Type)this.javaType, hasContainer ? CONTAINER_VALUE_GETTER.apply(value) : null);
            }
            if (hasContainer) {
                throw new IllegalArgumentException("both primitive and container types are found in the same message");
            }
            return this.getter.apply(value);
        }
        catch (Exception e) {
            throw new ConversionException(String.format("Could not convert YDB value of type \"%s\" to Java value of type \"%s\": %s", this.getYqlTypeName(), this.javaType.getTypeName(), value), (Throwable)e);
        }
    }

    @Generated
    public Type getJavaType() {
        return this.javaType;
    }

    @Generated
    public ValueProtos.Type.PrimitiveTypeId getYqlType() {
        return this.yqlType;
    }

    @Generated
    public BiConsumer<ValueProtos.Value.Builder, Object> getSetter() {
        return this.setter;
    }

    @Generated
    public Function<ValueProtos.Value, Object> getGetter() {
        return this.getter;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof YqlPrimitiveType)) {
            return false;
        }
        YqlPrimitiveType other = (YqlPrimitiveType)o;
        Type this$javaType = this.getJavaType();
        Type other$javaType = other.getJavaType();
        if (this$javaType == null ? other$javaType != null : !this$javaType.equals(other$javaType)) {
            return false;
        }
        ValueProtos.Type.PrimitiveTypeId this$yqlType = this.getYqlType();
        ValueProtos.Type.PrimitiveTypeId other$yqlType = other.getYqlType();
        if (this$yqlType == null ? other$yqlType != null : !this$yqlType.equals(other$yqlType)) {
            return false;
        }
        BiConsumer<ValueProtos.Value.Builder, Object> this$setter = this.getSetter();
        BiConsumer<ValueProtos.Value.Builder, Object> other$setter = other.getSetter();
        if (this$setter == null ? other$setter != null : !this$setter.equals(other$setter)) {
            return false;
        }
        Function<ValueProtos.Value, Object> this$getter = this.getGetter();
        Function<ValueProtos.Value, Object> other$getter = other.getGetter();
        return !(this$getter == null ? other$getter != null : !this$getter.equals(other$getter));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Type $javaType = this.getJavaType();
        result = result * 59 + ($javaType == null ? 43 : $javaType.hashCode());
        ValueProtos.Type.PrimitiveTypeId $yqlType = this.getYqlType();
        result = result * 59 + ($yqlType == null ? 43 : $yqlType.hashCode());
        BiConsumer<ValueProtos.Value.Builder, Object> $setter = this.getSetter();
        result = result * 59 + ($setter == null ? 43 : $setter.hashCode());
        Function<ValueProtos.Value, Object> $getter = this.getGetter();
        result = result * 59 + ($getter == null ? 43 : $getter.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "YqlPrimitiveType(javaType=" + String.valueOf(this.getJavaType()) + ", yqlType=" + String.valueOf(this.getYqlType()) + ", setter=" + String.valueOf(this.getSetter()) + ", getter=" + String.valueOf(this.getGetter()) + ")";
    }

    @ConstructorProperties(value={"javaType", "yqlType", "setter", "getter"})
    @Generated
    private YqlPrimitiveType(Type javaType, ValueProtos.Type.PrimitiveTypeId yqlType, BiConsumer<ValueProtos.Value.Builder, Object> setter, Function<ValueProtos.Value, Object> getter) {
        this.javaType = javaType;
        this.yqlType = yqlType;
        this.setter = setter;
        this.getter = getter;
    }

    static {
        YqlPrimitiveType.registerYqlType(Boolean.class, ValueProtos.Type.PrimitiveTypeId.BOOL, null, true, BOOL_SETTER, BOOL_GETTER);
        YqlPrimitiveType.registerYqlType(Byte.class, ValueProtos.Type.PrimitiveTypeId.INT32, null, true, BYTE_SETTER, BYTE_GETTER);
        YqlPrimitiveType.registerYqlType(Byte.class, ValueProtos.Type.PrimitiveTypeId.UINT8, null, false, BYTE_UINT_SETTER, BYTE_UINT_GETTER);
        YqlPrimitiveType.registerYqlType(Short.class, ValueProtos.Type.PrimitiveTypeId.INT32, null, true, SHORT_SETTER, SHORT_GETTER);
        YqlPrimitiveType.registerYqlType(Integer.class, ValueProtos.Type.PrimitiveTypeId.INT32, null, true, INT_SETTER, INT_GETTER);
        YqlPrimitiveType.registerYqlType(Integer.class, ValueProtos.Type.PrimitiveTypeId.UINT32, null, false, UINT_SETTER, UINT_GETTER);
        YqlPrimitiveType.registerYqlType(Integer.class, ValueProtos.Type.PrimitiveTypeId.UINT8, null, false, BYTE_UINT_SETTER, UINT_GETTER);
        YqlPrimitiveType.registerYqlType(Long.class, ValueProtos.Type.PrimitiveTypeId.INT64, null, true, LONG_SETTER, LONG_GETTER);
        YqlPrimitiveType.registerYqlType(Long.class, ValueProtos.Type.PrimitiveTypeId.UINT32, null, false, UINT_SETTER, U32LONG_GETTER);
        YqlPrimitiveType.registerYqlType(Long.class, ValueProtos.Type.PrimitiveTypeId.UINT64, null, false, ULONG_SETTER, ULONG_GETTER);
        YqlPrimitiveType.registerYqlType(Float.class, ValueProtos.Type.PrimitiveTypeId.FLOAT, null, true, FLOAT_SETTER, FLOAT_GETTER);
        YqlPrimitiveType.registerYqlType(Double.class, ValueProtos.Type.PrimitiveTypeId.DOUBLE, null, true, DOUBLE_SETTER, DOUBLE_GETTER);
        YqlPrimitiveType.registerYqlType(byte[].class, ValueProtos.Type.PrimitiveTypeId.STRING, null, true, BYTES_SETTER, BYTES_GETTER);
        YqlPrimitiveType.registerYqlType(ByteArray.class, ValueProtos.Type.PrimitiveTypeId.STRING, null, true, BYTE_ARRAY_SETTER, BYTE_ARRAY_GETTER);
        YqlPrimitiveType.registerYqlType(Instant.class, ValueProtos.Type.PrimitiveTypeId.INT64, null, true, INSTANT_SETTER, INSTANT_GETTER);
        YqlPrimitiveType.registerYqlType(Instant.class, ValueProtos.Type.PrimitiveTypeId.INT64, "Milliseconds", false, INSTANT_SETTER, INSTANT_GETTER);
        YqlPrimitiveType.registerYqlType(Instant.class, ValueProtos.Type.PrimitiveTypeId.UINT64, null, false, INSTANT_UINT_SETTER, INSTANT_UINT_GETTER);
        YqlPrimitiveType.registerYqlType(Instant.class, ValueProtos.Type.PrimitiveTypeId.UINT64, "Milliseconds", false, INSTANT_UINT_SETTER, INSTANT_UINT_GETTER);
        YqlPrimitiveType.registerYqlType(Instant.class, ValueProtos.Type.PrimitiveTypeId.INT64, "Seconds", false, INSTANT_SECOND_SETTER, INSTANT_SECOND_GETTER);
        YqlPrimitiveType.registerYqlType(Instant.class, ValueProtos.Type.PrimitiveTypeId.UINT64, "Seconds", false, INSTANT_UINT_SECOND_SETTER, INSTANT_UINT_SECOND_GETTER);
        YqlPrimitiveType.registerYqlType(Instant.class, ValueProtos.Type.PrimitiveTypeId.TIMESTAMP, null, false, TIMESTAMP_SETTER, TIMESTAMP_GETTER);
        YqlPrimitiveType.registerYqlType(Instant.class, ValueProtos.Type.PrimitiveTypeId.TIMESTAMP, "Seconds", false, TIMESTAMP_SECONDS_SETTER, TIMESTAMP_SECONDS_GETTER);
        YqlPrimitiveType.registerYqlType(Instant.class, ValueProtos.Type.PrimitiveTypeId.TIMESTAMP, "Milliseconds", false, TIMESTAMP_MILLI_SETTER, TIMESTAMP_MILLI_GETTER);
        YqlPrimitiveType.registerYqlType(Duration.class, ValueProtos.Type.PrimitiveTypeId.INTERVAL, null, true, DURATION_SETTER, DURATION_GETTER);
        YqlPrimitiveType.registerYqlType(Duration.class, ValueProtos.Type.PrimitiveTypeId.INT64, null, false, DURATION_SETTER, DURATION_GETTER);
        YqlPrimitiveType.registerYqlType(Duration.class, ValueProtos.Type.PrimitiveTypeId.UINT64, null, false, DURATION_UINT_SETTER, DURATION_UINT_GETTER);
        YqlPrimitiveType.registerYqlType(Duration.class, ValueProtos.Type.PrimitiveTypeId.INT64, "Milliseconds", false, DURATION_MILLI_SETTER, DURATION_MILLI_GETTER);
        YqlPrimitiveType.registerYqlType(Duration.class, ValueProtos.Type.PrimitiveTypeId.UINT64, "Milliseconds", false, DURATION_MILLI_UINT_SETTER, DURATION_MILLI_UINT_GETTER);
        YqlPrimitiveType.registerYqlType(Duration.class, ValueProtos.Type.PrimitiveTypeId.INT32, null, false, DURATION_SECOND_SETTER, DURATION_SECOND_GETTER);
        YqlPrimitiveType.registerYqlType(Duration.class, ValueProtos.Type.PrimitiveTypeId.UINT32, null, false, DURATION_SECOND_UINT_SETTER, DURATION_SECOND_UINT_GETTER);
        YqlPrimitiveType.registerYqlType(Duration.class, ValueProtos.Type.PrimitiveTypeId.UTF8, null, false, DURATION_UTF8_SETTER, DURATION_UTF8_GETTER);
        YqlPrimitiveType.registerYqlType(UUID.class, ValueProtos.Type.PrimitiveTypeId.UTF8, null, true, UUID_UTF8_SETTER, UUID_UTF8_GETTER);
        YqlPrimitiveType.registerYqlType(UUID.class, ValueProtos.Type.PrimitiveTypeId.STRING, null, false, UUID_STRING_SETTER, UUID_STRING_GETTER);
        YqlPrimitiveType.registerPrimitiveTypes();
        YqlPrimitiveType.registerYqlType(FieldValueType.STRING, ValueProtos.Type.PrimitiveTypeId.STRING, null, true, STRING_VALUE_STRING_SETTERS, STRING_VALUE_STRING_GETTERS);
        YqlPrimitiveType.registerYqlType(FieldValueType.STRING, ValueProtos.Type.PrimitiveTypeId.UTF8, null, false, STRING_VALUE_UTF8_SETTERS, STRING_VALUE_UTF8_GETTERS);
        YqlPrimitiveType.registerYqlType(FieldValueType.STRING, ValueProtos.Type.PrimitiveTypeId.JSON, null, false, STRING_VALUE_UTF8_SETTERS, STRING_VALUE_UTF8_GETTERS);
        YqlPrimitiveType.registerYqlType(FieldValueType.ENUM, ValueProtos.Type.PrimitiveTypeId.STRING, null, true, ENUM_NAME_STRING_SETTERS, ENUM_NAME_STRING_GETTERS);
        YqlPrimitiveType.registerYqlType(FieldValueType.ENUM, ValueProtos.Type.PrimitiveTypeId.UTF8, null, false, ENUM_NAME_UTF8_SETTERS, ENUM_NAME_UTF8_GETTERS);
        YqlPrimitiveType.registerYqlType(FieldValueType.ENUM, ValueProtos.Type.PrimitiveTypeId.STRING, "name", false, ENUM_NAME_STRING_SETTERS, ENUM_NAME_STRING_GETTERS);
        YqlPrimitiveType.registerYqlType(FieldValueType.ENUM, ValueProtos.Type.PrimitiveTypeId.UTF8, "name", false, ENUM_NAME_UTF8_SETTERS, ENUM_NAME_UTF8_GETTERS);
        YqlPrimitiveType.registerYqlType(FieldValueType.ENUM, ValueProtos.Type.PrimitiveTypeId.STRING, "toString", false, ENUM_TO_STRING_STRING_SETTERS, ENUM_TO_STRING_STRING_GETTERS);
        YqlPrimitiveType.registerYqlType(FieldValueType.ENUM, ValueProtos.Type.PrimitiveTypeId.UTF8, "toString", false, ENUM_TO_STRING_UTF8_SETTERS, ENUM_TO_STRING_UTF8_GETTERS);
        YqlPrimitiveType.registerYqlType(FieldValueType.OBJECT, ValueProtos.Type.PrimitiveTypeId.JSON, null, true, JSON_UTF8_SETTERS, JSON_UTF8_GETTERS);
        YqlPrimitiveType.registerYqlType(FieldValueType.OBJECT, ValueProtos.Type.PrimitiveTypeId.JSON_DOCUMENT, null, false, JSON_UTF8_SETTERS, JSON_UTF8_GETTERS);
        YqlPrimitiveType.registerYqlType(FieldValueType.OBJECT, ValueProtos.Type.PrimitiveTypeId.STRING, null, false, JSON_STRING_SETTERS, JSON_STRING_GETTERS);
        YqlPrimitiveType.registerYqlType(FieldValueType.OBJECT, ValueProtos.Type.PrimitiveTypeId.UTF8, null, false, JSON_UTF8_SETTERS, JSON_UTF8_GETTERS);
        ITEMS_FIELD = YqlPrimitiveType.getValueDescriptor("items");
        PAIRS_FIELD = YqlPrimitiveType.getValueDescriptor("pairs");
    }

    private static final class YqlTypeSelector {
        @NonNull
        private final Type javaType;
        @NonNull
        private final ValueProtos.Type.PrimitiveTypeId yqlType;
        private final String qualifier;

        @ConstructorProperties(value={"javaType", "yqlType", "qualifier"})
        @Generated
        public YqlTypeSelector(@NonNull Type javaType, @NonNull ValueProtos.Type.PrimitiveTypeId yqlType, String qualifier) {
            if (javaType == null) {
                throw new NullPointerException("javaType is marked non-null but is null");
            }
            if (yqlType == null) {
                throw new NullPointerException("yqlType is marked non-null but is null");
            }
            this.javaType = javaType;
            this.yqlType = yqlType;
            this.qualifier = qualifier;
        }

        @NonNull
        @Generated
        public Type getJavaType() {
            return this.javaType;
        }

        @NonNull
        @Generated
        public ValueProtos.Type.PrimitiveTypeId getYqlType() {
            return this.yqlType;
        }

        @Generated
        public String getQualifier() {
            return this.qualifier;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof YqlTypeSelector)) {
                return false;
            }
            YqlTypeSelector other = (YqlTypeSelector)o;
            Type this$javaType = this.getJavaType();
            Type other$javaType = other.getJavaType();
            if (this$javaType == null ? other$javaType != null : !this$javaType.equals(other$javaType)) {
                return false;
            }
            ValueProtos.Type.PrimitiveTypeId this$yqlType = this.getYqlType();
            ValueProtos.Type.PrimitiveTypeId other$yqlType = other.getYqlType();
            if (this$yqlType == null ? other$yqlType != null : !this$yqlType.equals(other$yqlType)) {
                return false;
            }
            String this$qualifier = this.getQualifier();
            String other$qualifier = other.getQualifier();
            return !(this$qualifier == null ? other$qualifier != null : !this$qualifier.equals(other$qualifier));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Type $javaType = this.getJavaType();
            result = result * 59 + ($javaType == null ? 43 : $javaType.hashCode());
            ValueProtos.Type.PrimitiveTypeId $yqlType = this.getYqlType();
            result = result * 59 + ($yqlType == null ? 43 : $yqlType.hashCode());
            String $qualifier = this.getQualifier();
            result = result * 59 + ($qualifier == null ? 43 : $qualifier.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "YqlPrimitiveType.YqlTypeSelector(javaType=" + String.valueOf(this.getJavaType()) + ", yqlType=" + String.valueOf(this.getYqlType()) + ", qualifier=" + this.getQualifier() + ")";
        }

        @Generated
        public YqlTypeSelector withJavaType(@NonNull Type javaType) {
            if (javaType == null) {
                throw new NullPointerException("javaType is marked non-null but is null");
            }
            return this.javaType == javaType ? this : new YqlTypeSelector(javaType, this.yqlType, this.qualifier);
        }

        @Generated
        public YqlTypeSelector withQualifier(String qualifier) {
            return this.qualifier == qualifier ? this : new YqlTypeSelector(this.javaType, this.yqlType, qualifier);
        }
    }

    private static interface Setter
    extends BiConsumer<ValueProtos.Value.Builder, Object> {
    }

    private static interface Getter
    extends Function<ValueProtos.Value, Object> {
    }

    private static final class ValueYqlTypeSelector {
        @NonNull
        private final FieldValueType valueType;
        @NonNull
        private final ValueProtos.Type.PrimitiveTypeId yqlType;
        private final String qualifier;

        @ConstructorProperties(value={"valueType", "yqlType", "qualifier"})
        @Generated
        public ValueYqlTypeSelector(@NonNull FieldValueType valueType, @NonNull ValueProtos.Type.PrimitiveTypeId yqlType, String qualifier) {
            if (valueType == null) {
                throw new NullPointerException("valueType is marked non-null but is null");
            }
            if (yqlType == null) {
                throw new NullPointerException("yqlType is marked non-null but is null");
            }
            this.valueType = valueType;
            this.yqlType = yqlType;
            this.qualifier = qualifier;
        }

        @NonNull
        @Generated
        public FieldValueType getValueType() {
            return this.valueType;
        }

        @NonNull
        @Generated
        public ValueProtos.Type.PrimitiveTypeId getYqlType() {
            return this.yqlType;
        }

        @Generated
        public String getQualifier() {
            return this.qualifier;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ValueYqlTypeSelector)) {
                return false;
            }
            ValueYqlTypeSelector other = (ValueYqlTypeSelector)o;
            FieldValueType this$valueType = this.getValueType();
            FieldValueType other$valueType = other.getValueType();
            if (this$valueType == null ? other$valueType != null : !this$valueType.equals(other$valueType)) {
                return false;
            }
            ValueProtos.Type.PrimitiveTypeId this$yqlType = this.getYqlType();
            ValueProtos.Type.PrimitiveTypeId other$yqlType = other.getYqlType();
            if (this$yqlType == null ? other$yqlType != null : !this$yqlType.equals(other$yqlType)) {
                return false;
            }
            String this$qualifier = this.getQualifier();
            String other$qualifier = other.getQualifier();
            return !(this$qualifier == null ? other$qualifier != null : !this$qualifier.equals(other$qualifier));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            FieldValueType $valueType = this.getValueType();
            result = result * 59 + ($valueType == null ? 43 : $valueType.hashCode());
            ValueProtos.Type.PrimitiveTypeId $yqlType = this.getYqlType();
            result = result * 59 + ($yqlType == null ? 43 : $yqlType.hashCode());
            String $qualifier = this.getQualifier();
            result = result * 59 + ($qualifier == null ? 43 : $qualifier.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "YqlPrimitiveType.ValueYqlTypeSelector(valueType=" + String.valueOf(this.getValueType()) + ", yqlType=" + String.valueOf(this.getYqlType()) + ", qualifier=" + this.getQualifier() + ")";
        }

        @Generated
        public ValueYqlTypeSelector withQualifier(String qualifier) {
            return this.qualifier == qualifier ? this : new ValueYqlTypeSelector(this.valueType, this.yqlType, qualifier);
        }
    }

    private static final class JavaYqlTypeAccessors {
        @NonNull
        private final Function<Type, Setter> setters;
        @NonNull
        private final Function<Type, Getter> getters;

        @ConstructorProperties(value={"setters", "getters"})
        @Generated
        public JavaYqlTypeAccessors(@NonNull Function<Type, Setter> setters, @NonNull Function<Type, Getter> getters) {
            if (setters == null) {
                throw new NullPointerException("setters is marked non-null but is null");
            }
            if (getters == null) {
                throw new NullPointerException("getters is marked non-null but is null");
            }
            this.setters = setters;
            this.getters = getters;
        }

        @NonNull
        @Generated
        public Function<Type, Setter> getSetters() {
            return this.setters;
        }

        @NonNull
        @Generated
        public Function<Type, Getter> getGetters() {
            return this.getters;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JavaYqlTypeAccessors)) {
                return false;
            }
            JavaYqlTypeAccessors other = (JavaYqlTypeAccessors)o;
            Function<Type, Setter> this$setters = this.getSetters();
            Function<Type, Setter> other$setters = other.getSetters();
            if (this$setters == null ? other$setters != null : !this$setters.equals(other$setters)) {
                return false;
            }
            Function<Type, Getter> this$getters = this.getGetters();
            Function<Type, Getter> other$getters = other.getGetters();
            return !(this$getters == null ? other$getters != null : !this$getters.equals(other$getters));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Function<Type, Setter> $setters = this.getSetters();
            result = result * 59 + ($setters == null ? 43 : $setters.hashCode());
            Function<Type, Getter> $getters = this.getGetters();
            result = result * 59 + ($getters == null ? 43 : $getters.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "YqlPrimitiveType.JavaYqlTypeAccessors(setters=" + String.valueOf(this.getSetters()) + ", getters=" + String.valueOf(this.getGetters()) + ")";
        }
    }

    private static class YdbContainerValueGetter
    implements Getter {
        private static final Map<ValueProtos.Value.ValueCase, Getter> VALUE_CASE_GETTERS = Map.ofEntries(Map.entry(ValueProtos.Value.ValueCase.NULL_FLAG_VALUE, x -> null), Map.entry(ValueProtos.Value.ValueCase.BOOL_VALUE, BOOL_GETTER), Map.entry(ValueProtos.Value.ValueCase.INT32_VALUE, INT_GETTER), Map.entry(ValueProtos.Value.ValueCase.UINT32_VALUE, UINT_GETTER), Map.entry(ValueProtos.Value.ValueCase.INT64_VALUE, LONG_GETTER), Map.entry(ValueProtos.Value.ValueCase.UINT64_VALUE, ULONG_GETTER), Map.entry(ValueProtos.Value.ValueCase.TEXT_VALUE, TEXT_GETTER), Map.entry(ValueProtos.Value.ValueCase.BYTES_VALUE, STRING_GETTER), Map.entry(ValueProtos.Value.ValueCase.FLOAT_VALUE, FLOAT_GETTER), Map.entry(ValueProtos.Value.ValueCase.DOUBLE_VALUE, DOUBLE_GETTER));

        private YdbContainerValueGetter() {
        }

        @Override
        public Object apply(ValueProtos.Value value) {
            if (value.getRepeatedFieldCount(ITEMS_FIELD) > 0) {
                return value.getItemsList().stream().map(this::apply).collect(Collectors.toList());
            }
            if (value.getRepeatedFieldCount(PAIRS_FIELD) > 0) {
                return value.getPairsList().stream().collect(BetterCollectors.toMapNullFriendly(pair -> this.apply(pair.getKey()), pair -> this.apply(pair.getPayload())));
            }
            Getter getter = VALUE_CASE_GETTERS.get(value.getValueCase());
            if (getter == null) {
                throw new IllegalArgumentException("value type is unsupported for " + String.valueOf(value.getValueCase()));
            }
            return getter.apply(value);
        }
    }
}

